/*
 * Decompiled with CFR 0.152.
 */
class ComplexElement
extends AnElement {
    float[] myData;
    int SizeXY;
    int readmode;

    ComplexElement(int n, int n2, int n3, double d) {
        super(n, n2, n3, d);
        this.myData = new float[2 * this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        AnElement.DataType = AnElement.ComplexType;
        this.readmode = 0;
    }

    void AdvanceReadMode() {
        this.readmode = (this.readmode + 1) % 4;
    }

    void SetReadMode(int n) {
        this.readmode = n % 4;
    }

    void Clear() {
        for (int i = 0; i < 2 * this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0.0f;
        }
    }

    void DeleteData() {
        this.myData = null;
    }

    int GetStdByteNum() {
        return 4;
    }

    void SetValueAt(int n, int n2, int n3, double d) {
        this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3)] = (float)d;
    }

    void SetValueAt(int n, int n2, int n3, float f, float f2) {
        this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3)] = f;
        this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3) + 1] = f2;
    }

    int GetIntValueAt(int n, int n2, int n3) {
        return (int)((this.GetRawValueAt(n, n2, n3) - this.shift) * this.scaleI);
    }

    int GetByteValueAt(int n, int n2, int n3) {
        return (int)((this.GetRawValueAt(n, n2, n3) - this.shift) * this.scaleB);
    }

    double GetRawValueAt(int n, int n2, int n3) {
        float f = this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3)];
        float f2 = this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3) + 1];
        switch (this.readmode) {
            case 0: {
                return Math.sqrt(f * f + f2 * f2);
            }
            case 1: {
                return Math.atan2(f, f2) * 180.0 / Math.PI;
            }
            case 2: {
                return f;
            }
        }
        return f2;
    }

    double GetValueAt(int n, int n2, int n3) {
        return this.GetRawValueAt(n, n2, n3) * this.ScaleV + this.OffsetV;
    }

    String GetValueStringAt(int n, int n2, int n3) {
        float f = this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3)];
        float f2 = this.myData[2 * (n + this.Sizes[0] * n2 + this.SizeXY * n3) + 1];
        return this.nf.format(this.GetValueAt(n, n2, n3)) + " (" + this.nf.format(f) + ", " + this.nf.format(f2) + "i)";
    }

    void ConvertSliceFromSimilar(int n, int n2, Object object, int n3, int n4) {
        float[] fArray = (float[])object;
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[2 * (i + this.Sizes[0] * this.Sizes[1] * n)] = fArray[n2 * this.SizeXY + i + n4];
        }
    }

    void ConvertSliceFromByte(int n, int n2, byte[] byArray, int n3, int n4) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n5 = 4 * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += n3) {
            int n6;
            int n7;
            int n8 = 0;
            for (n7 = 1; n7 < 4; ++n7) {
                n6 = byArray[2 * (n2 * n5 + 4 * (i + n4)) + n7] & 0xFF;
                n8 |= n6 << 8 * n7;
            }
            this.myData[2 * (i + this.SizeXY * n)] = f = Float.intBitsToFloat(n8);
            n8 = 0;
            for (n7 = 1; n7 < 4; ++n7) {
                n6 = byArray[2 * (n2 * n5 + 4 * (i + n4)) + 4 + n7] & 0xFF;
                n8 |= n6 << 8 * n7;
            }
            this.myData[2 * (i + this.SizeXY * n) + 1] = f2 = Float.intBitsToFloat(n8);
        }
    }

    void ConvertSliceFromRGB(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        throw new IllegalArgumentException("Int: Inapplicable conversion\n");
    }

    void CopySliceToSimilar(int n, Object object) {
        float[] fArray = (float[])object;
        int n2 = 0;
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    fArray[n2] = (float)this.GetRawValueAt(k, j, i);
                    ++n2;
                }
            }
        }
    }
}

