/*
 * Decompiled with CFR 0.152.
 */
class ByteElement
extends AnElement {
    byte[] myData;
    int SizeXY;

    ByteElement(int n, int n2, int n3) {
        super(n, n2, n3, 256.0);
        this.myData = new byte[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        AnElement.DataType = AnElement.ByteType;
    }

    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0;
        }
    }

    void DeleteData() {
        this.myData = null;
    }

    int GetStdByteNum() {
        return 1;
    }

    void SetValueAt(int n, int n2, int n3, double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 255.0) {
            d = 255.0;
        }
        this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] = (byte)d;
    }

    int GetIntValueAt(int n, int n2, int n3) {
        int n4 = this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] & 0xFF;
        return (int)(((double)n4 - this.shift) * this.scaleI);
    }

    int GetByteValueAt(int n, int n2, int n3) {
        int n4 = this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] & 0xFF;
        return (int)(((double)n4 - this.shift) * this.scaleB);
    }

    double GetRawValueAt(int n, int n2, int n3) {
        double d = this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] & 0xFF;
        return d;
    }

    double GetValueAt(int n, int n2, int n3) {
        int n4 = this.myData[n + this.Sizes[0] * n2 + this.SizeXY * n3] & 0xFF;
        return (double)n4 * this.ScaleV + this.OffsetV;
    }

    void ConvertSliceFromSimilar(int n, int n2, Object object, int n3, int n4) {
        byte[] byArray = (byte[])object;
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = byArray[n2 * this.SizeXY + i + n4];
        }
    }

    void ConvertSliceFromByte(int n, int n2, byte[] byArray, int n3, int n4) {
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = byArray[n2 * this.SizeXY + i + n4];
        }
    }

    void ConvertSliceFromRGB(int n, int n2, int[] nArray, int n3, int n4, int n5) {
        int n6 = n5 * 8;
        for (int i = 0; i < this.SizeXY; i += n3) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * n] = (byte)(nArray[n2 * this.SizeXY + i + n4] >> n6 & 0xFF);
        }
    }

    void CopySliceToSimilar(int n, Object object) {
        byte[] byArray = (byte[])object;
        for (int i = 0; i < this.SizeXY; ++i) {
            byArray[i] = this.myData[i + this.Sizes[0] * this.Sizes[1] * n];
        }
    }
}

