%dip_subpixmax   Refine local maxima to subpixel accuracy (for 2D only, C code might work for nD)
%    p = dip_subpixmax(in, mask, method)
%
%   in
%      Grayscale image.
%   mask
%      binary mask of ongrid local maxima from dip_Maxima()
%   method - 'default', 'linear', 'parabolic', 'gaussian', 'bspline'
%      Method used to locate the subpixel maxima from its 3x3 neighborhood. 
%   p
%      Output array of subpixel coordinates ( Npix x dim )
%
% EXAMPLE: Harris corner detector with subpixel accuracy:
%	a = readim, Ix = dip_sobelgradient(a,0); Iy = dip_sobelgradient(a,1);
%	Ix2 = gaussf(Ix^2, 3); Iy2 = gaussf(Iy^2, 3); Ixy = gaussf(Ix*Iy, 3);
%	cim = (Ix2*Iy2 - Ixy^2)/(Ix2 + Iy2 + eps)
%	cmask = dip_maxima(cim,[],[10 10],'elliptic');
%	p = dip_subpixmax(cim,cmask,'parabolic')  % linear (separable)
%	overlay(cim,cmask),hold on,plot(p(:,1),p(:,2),'+'), hold off

% (C) Copyright 1999-2000               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Tuan Pham, June 2004.

%
%LITERATURE
%C.L. xxx xxx, xxxxx fill me in xxxxxxxxx, M.Sc. Thesis, Delft University of Technology, 1998
%SEE ALSO
%
