%IFT   Fourier Transform (inverse)
%
% SYNOPSIS:
%  image_out = ift(image_in)

% (C) Copyright 1999-2000               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Lucas van Vliet, May 2000.

function image_out = ift(varargin)

if nargin==0
   if exist('private/Fourier.jpg','file')
      image_out = dip_image(imread('private/Fourier.jpg'));
      image_out = mirror(image_out,'y-axis');
      return
   end
end

d = struct('menu','Transforms',...
           'display','Inverse Fourier Transform',...
           'inparams',struct('name',       {'image_in'},...
                             'description',{'Input image'},...
                             'type',       {'image'},...
                             'dim_check',  {0},...
                             'range_check',{[]},...
                             'required',   {1},...
                             'default',    {'a'}...
                            ),...
           'outparams',struct('name',{'image_out'},...
                              'description',{'Output image'},...
                              'type',{'image'}...
                              )...
          );
if nargin == 1
   s = varargin{1};
   if ischar(s) & strcmp(s,'DIP_GetParamList')
      image_out = d;
      return
   end
end
try
   [image_in] = getparams(d,varargin{:});
catch
   if ~isempty(paramerror)
      error(paramerror)
   else
      error(firsterr)
   end
end


dimProcess = ones(1,ndims(image_in));

image_out = dip_fouriertransform(image_in, 'inverse', dimProcess);