%SIGN   Signum function.
%   For each pixel in X, SIGN(X) returns 1 if the pixel
%   is greater than zero, 0 if it equals zero and -1 if it is
%   less than zero. For complex X, SIGN(X) = X / ABS(X).

% (C) Copyright 1999-2009               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, October 2000.
% 7 April 2009: Output is always sint8.

function out = sign(in)
try
   [in,dims,out_dip_type,out_phys] = do1input(in);
   out = compute1('sign',in,dims,'sint8',out_phys);
catch
   error(di_firsterr)
end
