%[IN1,IN2,DIMS,OUT_TYPE,OUT_PHYS] = DO2INPUTS(IN1,IN2)
%    Checks images, converts to doubles, and determines
%    the output type that should be generated.
%    DO2INPUTS(IN1,IN2,'MAX') uses DI_FINDTYPEX instead
%    of DI_FINDTYPE to determine OUT_TYPE.

% (C) Copyright 1999-2009               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 18 January 2001:  Added DIMS parameter. Changed all calls to this
%                   function accordingly.
% 22 June 2001:     Dimensionality of input determined through DI_NDIMS if
%                   it is a MATLAB array. Correct for 0D and 1D arrays now.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
%                   Calling dip_image on non-object inputs to make this simpler.
% 14 August 2006:   Fixed dimensionality matching test.
% February 2008:    Adding pixel dimensions and units to dip_image. (BR)
% 10 March 2008:    Fixed error due to physDims variable not being a stuct.
% 7 April 2009:     Added MODE input argument.

function [in1,in2,dims,out_type,out_phys] = do2inputs(in1,in2,mode)
if nargin == 2
   mode = 0;
elseif nargin == 3
   if ischar(mode) & strcmp(upper(mode),'MAX')
      mode = 1;
   else
      mode = 0;
   end
else
   error('Erroneus input.');
end
if nargout < 2
   error('Erroneus output.')
end
if di_isdipimobj(in1)
   phy1 = in1.physDims;
else
   in1 = dip_image(in1);
   phy1 = di_defaultphysdims(0); % 0D phys dims signals this image doesn't have any phys dims.
end
if di_isdipimobj(in2)
   phy2 = in2.physDims;
else
   in2 = dip_image(in2);
   phy2 = di_defaultphysdims(0); % 0D phys dims signals this image doesn't have any phys dims.
end
nd1 = in1.dims;
nd2 = in2.dims;
dims = max(nd1,nd2); % in case one is scalar
if nargout > 3
   if mode
      out_type = di_findtypex(in1.dip_type,in2.dip_type);
   else
      out_type = di_findtype(in1.dip_type,in2.dip_type);
   end
end
if nargout > 4
   out_phys = di_findphysdims(phy1,phy2);
end
in1 = in1.data;
in2 = in2.data;
s1 = size(in1); s1 = [s1,ones(1,nd1-length(s1))];
s2 = size(in2); s2 = [s2,ones(1,nd2-length(s2))];
if (prod(s1) ~= 1) & (prod(s2) ~= 1)
   if nd1~=nd2, error('Dimensionalities do not match.'); end
   if any(s1~=s2), error('Sizes do not match.'); end
% else: let one or both elements be scalar.
end
