%OUT = COMPUTE0ARRAY(OPERATION,IN)
%    This applies OPERATION on each tensor in the image:
%    IN{1} OPERATION IN{2} OPERATION IN{3} ...
%
%    This function should be called after DOARRAYINPUTS if the ARRAYOP
%    flag returned was non-zero (true).
%
%    Be careful!!!!
%    This function only works for operations that are "separable",
%    like MAX, MIN and PLUS.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, November 2000.
% 18 January 2001: Keeping the maximum dimensionality.
% 10 March 2008: Fixed bug. COMPUTE2 has a new PHYSDIMS input parameter.

function out = compute0array(operation,in)
if nargin ~= 2
   error('Erroneus input.')
end
s = imarsize(in);
N = prod(s);
out = in(1);
dip_type = in(1).dip_type;
physDims = in(1).physDims;
dims = in(1).dims;
for ii=2:N
   dip_type = di_findtype(dip_type,in(ii).dip_type);
   physDims = di_findphysdims(physDims,in(ii).physDims);
   dims = max(dims,in(ii).dims);
   out = compute2(operation,out.data,in(ii).data,dims,dip_type,physDims);
end
