/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class JpegWriter
implements PlugIn {
    public static final int DEFAULT_QUALITY = 75;
    private static int quality;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        imagePlus.startTiming();
        this.saveAsJpeg(imagePlus, string);
        IJ.showTime(imagePlus, imagePlus.getStartTime(), "JpegWriter: ");
    }

    void saveAsJpeg(ImagePlus imagePlus, String string) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imagePlus.getImage(), 0, 0, null);
            graphics2D.dispose();
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality((float)((double)quality / 100.0), true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            IJ.showMessage("Jpeg Writer", "" + exception);
        }
    }

    public static void setQuality(int n) {
        quality = n;
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 100) {
            quality = 100;
        }
    }

    public static int getQuality() {
        return quality;
    }

    static {
        JpegWriter.setQuality(Prefs.getInt("jpeg", 75));
    }
}

