/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.MacroInstaller;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener {
    public static final String VERSION = "1.30s";
    public static Color backgroundColor = new Color(220, 220, 220);
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static final String RESULTS_X = "results.x";
    private static final String RESULTS_Y = "results.y";
    private static final String RESULTS_WIDTH = "results.width";
    private static final String RESULTS_HEIGHT = "results.height";
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuiting;
    boolean hotkey;

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("ImageJ");
        int n;
        this.applet = applet;
        String string = Prefs.load(this, applet);
        Menus menus = new Menus(this, applet);
        String string2 = menus.addMenuBar();
        menus.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(100, 18);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        Point point = this.getPreferredLocation();
        Dimension dimension = this.toolbar.getPreferredSize();
        int n2 = dimension.width + 10;
        int n3 = 100;
        this.setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        ((Component)this).setBounds(point.x, point.y, n2, n3);
        ((Component)this).setLocation(point.x, point.y);
        this.pack();
        this.setResizable(false);
        this.show();
        if (IJ.isMacOSX()) {
            ((Component)this).setLocation(point.x + 1, point.y + 1);
            ((Component)this).setLocation(point.x, point.y);
            this.pack();
        }
        if (string != null) {
            IJ.error(string);
        }
        if (string2 != null) {
            IJ.error(string2);
        }
        if (IJ.isMacintosh()) {
            IJ.runPlugIn("QuitHandler", "");
        }
        if (IJ.isJava2() && applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", "");
        }
        String string3 = (n = menus.installMacros()) == 1 ? " macro)" : " macros)";
        IJ.showStatus("Version 1.30s (" + Menus.nPlugins + " commands, " + n + string3);
    }

    void showResults() {
        TextWindow textWindow = new TextWindow("Results", "", 300, 200);
        TextPanel textPanel = textWindow.getTextPanel();
        textPanel.addKeyListener(this);
        IJ.setTextPanel(textPanel);
    }

    void setIcon() {
        URL uRL = this.getClass().getResource("/microscope.gif");
        if (uRL == null) {
            return;
        }
        Image image = null;
        try {
            image = this.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public Point getPreferredLocation() {
        int n;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n3 = Prefs.getInt(IJ_X, -99);
        int n4 = Prefs.getInt(IJ_Y, -99);
        if (n3 != -99 && n4 != -99 && n3 < n2 - 75) {
            return new Point(n3, n4);
        }
        Dimension dimension = this.toolbar.getPreferredSize();
        double d = n2 > 832 ? 0.8 : 0.9;
        int n5 = (int)(d * (double)(n2 - (n = dimension.width + 10)));
        if (n5 < 10) {
            n5 = 10;
        }
        int n6 = 32;
        return new Point(n5, n6);
    }

    void showStatus(String string) {
        this.statusLine.setText(string);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String string) {
        new Executer(string, WindowManager.getCurrentImage());
    }

    public void runFilterPlugIn(Object object, String string, String string2) {
        IJ.runFilterPlugIn(object, string, string2);
    }

    public Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        return IJ.runUserPlugIn(string, string2, string3, bl);
    }

    public static String modifiers(int n) {
        String string = " [ ";
        if (n == 0) {
            return "";
        }
        if ((n & 1) != 0) {
            string = string + "Shift ";
        }
        if ((n & 2) != 0) {
            string = string + "Control ";
        }
        if ((n & 4) != 0) {
            string = string + "Meta ";
        }
        if ((n & 8) != 0) {
            string = string + "Alt ";
        }
        string = string + "] ";
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            this.hotkey = false;
            if (string != null) {
                this.doCommand(string);
            }
            if (IJ.debugMode) {
                IJ.log("actionPerformed: " + actionEvent);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        MenuComponent menuComponent = (MenuComponent)((Object)menuItem.getParent());
        String string = itemEvent.getItem().toString();
        if ((Menu)menuComponent == Menus.window) {
            WindowManager.activateWindow(string, menuItem);
        } else {
            this.doCommand(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Cloneable cloneable;
        boolean bl;
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        this.hotkey = false;
        if (n == 17 || n == 16) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyCode=" + n + " (" + KeyEvent.getKeyText(n) + ") keyChar=\"" + c + "\" (" + c + ") " + KeyEvent.getKeyModifiersText(n2));
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 8) != 0;
        String string = "";
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        boolean bl5 = bl = imagePlus != null && imagePlus.getStackSize() > 1;
        if (imagePlus != null && !bl3 && (c >= ' ' && c <= '\u00ff' || c == '\b' || c == '\n') && (cloneable = imagePlus.getRoi()) instanceof TextRoi) {
            if (bl4) {
                switch (c) {
                    case 'm': 
                    case 'u': {
                        c = '\u00b5';
                        break;
                    }
                    case 'A': {
                        c = '\u0081';
                        break;
                    }
                }
            }
            ((TextRoi)cloneable).addChar(c);
            return;
        }
        cloneable = Menus.getShortcuts();
        string = bl2 ? (String)cloneable.get(new Integer(n + 200)) : (String)cloneable.get(new Integer(n));
        if (string == null) {
            switch (n) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    string = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: 
                case 187: {
                    string = "Start Animation [=]";
                    break;
                }
                case 47: 
                case 191: {
                    string = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    string = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    string = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Roi roi = null;
                    if (imagePlus != null) {
                        roi = imagePlus.getRoi();
                    }
                    if (roi == null) {
                        return;
                    }
                    if ((n2 & 8) != 0) {
                        roi.nudgeCorner(n);
                    } else {
                        roi.nudge(n);
                    }
                    return;
                }
                case 27: {
                    if (imagePlus != null) {
                        imagePlus.getWindow().running = false;
                    }
                    Macro.abort();
                    Interpreter.abort();
                    if (Interpreter.getInstance() != null) {
                        IJ.beep();
                    }
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (string != null && !string.equals("")) {
            if (string.equals("Fill")) {
                this.hotkey = true;
            }
            if (string.charAt(0) == '^') {
                MacroInstaller.doShortcut(string);
            } else {
                this.doCommand(string);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        IJ.setKeyUp(keyEvent.getKeyCode());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        boolean bl = true;
        if (Menus.window.getItemCount() > 5) {
            bl = IJ.showMessageWithCancel("ImageJ", "Are you sure you want to quit ImageJ?");
        }
        if (bl) {
            this.doCommand("Quit");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void register(Class clazz) {
        if (!this.classes.contains(clazz)) {
            this.classes.addElement(clazz);
        }
    }

    public void quit() {
        if (!WindowManager.closeAllWindows()) {
            return;
        }
        if (this.applet == null) {
            Prefs.savePreferences();
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.exitWhenQuiting) {
            System.exit(0);
        }
    }

    public void savePreferences(Properties properties) {
        Point point = this.getLocation();
        ((Hashtable)properties).put(IJ_X, Integer.toString(point.x));
        ((Hashtable)properties).put(IJ_Y, Integer.toString(point.y));
    }

    public static void main(String[] stringArray) {
        ImageJ imageJ = IJ.getInstance();
        if (imageJ == null || imageJ != null && !imageJ.isShowing()) {
            imageJ = new ImageJ(null);
            imageJ.exitWhenQuiting = true;
        }
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].endsWith(".txt")) {
                    if (bl) {
                        new Opener().open(stringArray[n]);
                    } else {
                        new MacroRunner(new File(stringArray[n]));
                        bl = true;
                    }
                } else {
                    Opener opener = new Opener();
                    ImagePlus imagePlus = opener.openImage(stringArray[n]);
                    if (imagePlus != null) {
                        imagePlus.show();
                    }
                }
                ++n;
            }
        }
    }
}

