/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GUI;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.MenuBar;
import java.awt.TextArea;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

class View5D_
extends PlugInFrame
implements PlugIn {
    int previousId;
    ImagePlus imp;
    ImageProcessor ip;
    My3DData data3d = null;
    TextArea myLabel;
    MenuBar IJMenu;
    Vector panels = new Vector();
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;

    public void UpdatePanels() {
        for (int i = 0; i < this.panels.size(); ++i) {
            ((ImgPanel)this.panels.elementAt((int)i)).c1.UpdateAllNoCoord();
        }
    }

    public boolean LoadImg(int n) {
        int n2;
        int n3 = 1;
        int n4 = 1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            return false;
        }
        this.ip = this.imp.getProcessor();
        ImageStack imageStack = this.imp.getStack();
        this.SizeX = imageStack.getWidth();
        this.SizeY = imageStack.getHeight();
        if (n > 0) {
            this.SizeZ = 1;
            n3 = imageStack.getSize();
        } else {
            this.SizeZ = imageStack.getSize();
            if (this.SizeZ > 1) {
                n2 = (int)IJ.getNumber("Importing Stack. Number of Slices: ", this.SizeZ);
                n4 = this.SizeZ / n2;
                if (n4 > 1) {
                    n4 = (int)IJ.getNumber("Importing Stack. Number of Times: ", n4);
                }
                n3 = this.SizeZ / (n2 * n4);
                this.SizeZ = n2;
            }
        }
        n2 = 0;
        int n8 = -1;
        int n9 = -1;
        int n10 = AnElement.ByteType;
        int n11 = 1;
        int n12 = 8;
        int n13 = this.imp.getType();
        switch (n13) {
            case 3: {
                n10 = AnElement.ByteType;
                n11 = 1;
                n12 = 8;
                break;
            }
            case 4: {
                n10 = AnElement.ByteType;
                n11 = 1;
                n12 = 8;
                n3 = 3;
                break;
            }
            case 0: {
                n10 = AnElement.ByteType;
                n11 = 1;
                n12 = 8;
                break;
            }
            case 1: {
                n10 = AnElement.IntegerType;
                n11 = 2;
                n12 = 16;
                break;
            }
            case 2: {
                n10 = AnElement.FloatType;
                n11 = 4;
                n12 = 32;
            }
        }
        double[] dArray = new double[5];
        for (int i = 0; i < 5; ++i) {
            dArray[i] = 1.0;
        }
        double[] dArray2 = new double[5];
        for (int i = 0; i < 5; ++i) {
            dArray2[i] = 0.0;
        }
        double d = 1.0;
        double d2 = 0.0;
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[5];
        stringArray[0] = "X";
        stringArray[1] = "Y";
        stringArray[2] = "Z";
        stringArray[3] = "Elements";
        stringArray[4] = "Time";
        stringArray2[0] = "pixels";
        stringArray2[1] = "ypixels";
        stringArray2[2] = "zpixels";
        stringArray2[3] = "elements";
        stringArray2[4] = "time";
        String string = "intensity";
        String string2 = "a.u.";
        Calibration calibration = this.imp.getCalibration();
        if (calibration.scaled()) {
            dArray[0] = calibration.pixelWidth;
            dArray[1] = calibration.pixelHeight;
            dArray[2] = calibration.pixelDepth;
            dArray2[0] = calibration.xOrigin;
            dArray2[1] = calibration.yOrigin;
            dArray2[2] = calibration.zOrigin;
            if (calibration.getUnits() != "") {
                stringArray2[0] = calibration.getUnits();
                stringArray2[1] = calibration.getUnits();
                stringArray2[2] = calibration.getUnits();
            }
            if (calibration.frameInterval != 0.0 && dArray[2] == 0.0) {
                dArray[2] = calibration.frameInterval;
                stringArray2[2] = "seconds";
            }
        }
        if (calibration.calibrated()) {
            string = "calib. int.";
            string2 = calibration.getValueUnit();
            d2 = calibration.getCValue(0);
            d = calibration.getCValue(1.0) - d2;
        }
        if (this.data3d == null) {
            if (n3 > 1) {
                n5 = 0;
                n6 = 1;
            }
            if (n3 > 2) {
                n7 = 2;
            }
            if (n3 >= 5) {
                n5 = -1;
                n6 = -1;
                n7 = -1;
            }
            this.data3d = new My3DData(this, this.SizeX, this.SizeY, this.SizeZ, n3, n4, n5, n6, n7, n2, n8, n9, n10, n11, n12, dArray, dArray2, d, d2, stringArray, stringArray2);
            for (int i = 0; i < n3; ++i) {
                this.data3d.SetValueScale(i, d, d2, string, string2);
            }
        } else {
            if (this.SizeX != this.data3d.SizeX || this.SizeY != this.data3d.SizeY || this.SizeZ != this.data3d.SizeZ) {
                IJ.error("New image to load does not correspond in size! ...Not loading it.");
                System.out.println("Error! Size of new image to load does not correspond to old image\n");
                return false;
            }
            for (int i = 0; i < n3; ++i) {
                int n14 = this.data3d.GenerateNewElement(n10, n11, n12, dArray, dArray2, d, d2, stringArray, stringArray2);
                this.data3d.SetValueScale(n14, d, d2, string, string2);
            }
        }
        this.data3d.SetUp(n10, this, n3, n4, n13);
        if (n3 == 1 && this.data3d.Elements <= 3 && this.data3d.Elements > 1) {
            this.data3d.ActiveElement = 0;
            this.data3d.MarkChannel(0);
            this.data3d.MarkAsHistoDim(0);
            this.data3d.ActiveElement = 1;
            this.data3d.MarkChannel(1);
            this.data3d.MarkAsHistoDim(1);
            if (this.data3d.Elements == 3) {
                this.data3d.ActiveElement = 2;
                this.data3d.MarkChannel(2);
            }
        }
        if (this.data3d.Elements > 1 && this.data3d.Elements < 5 || n5 >= 0) {
            this.data3d.ToggleColor(true);
        } else {
            this.data3d.ToggleColor(false);
        }
        this.data3d.AdjustThresh(true);
        if (this.data3d.HistoY < 0 && this.data3d.Elements > 1) {
            this.data3d.HistoY = 1;
        }
        if (!this.panels.isEmpty()) {
            this.CheckforLUT();
        }
        return true;
    }

    public void CheckforLUT() {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            return;
        }
        int n = this.imp.getType();
        LookUpTable lookUpTable = this.imp.createLut();
        if (n == 3 || n != 4 && !lookUpTable.isGrayscale() || this.imp.isInvertedLut()) {
            int n2 = this.data3d.AddLookUpTable(lookUpTable.getMapSize(), lookUpTable.getReds(), lookUpTable.getGreens(), lookUpTable.getBlues());
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            String string = "User defined " + numberFormat.format(n2 - 13 + 1);
            ((ImgPanel)this.panels.firstElement()).c1.label.PixDisplay.AddColorMenu(string, n2);
            this.data3d.SetColorModelNr(this.data3d.ActiveElement, n2);
            if (!this.data3d.SetThresh(0.0, lookUpTable.getMapSize() - 1)) {
                this.data3d.InvalidateSlices();
            }
        }
    }

    public View5D_() {
        super("5D Viewer");
        if (!this.LoadImg(0)) {
            IJ.showMessage("Error: View5D needs a loaded image in ImageJ, when starting!");
            return;
        }
        ImgPanel imgPanel = new ImgPanel(this, this.data3d);
        this.panels.addElement(imgPanel);
        this.CheckforLUT();
        this.setLayout(new BorderLayout());
        this.add("Center", imgPanel);
        this.myLabel = new TextArea("5D-viewer Java Applet by Rainer Heintzmann, [press '?' for help]", 1, 76, 3);
        this.add("North", this.myLabel);
        imgPanel.CheckScrollBar();
        this.setMenuBar(imgPanel.MyMenu);
        ((Component)this).setVisible(true);
        this.pack();
        GUI.center(this);
        this.show();
        imgPanel.InitScaling();
    }

    public ImagePlus GetImp() {
        return this.imp;
    }

    public ImageProcessor GetIp() {
        return this.ip;
    }

    void showAbout() {
        IJ.showMessage("About View5D, Version V1.0.17 beta", "5D-Viewer by Rainer Heintzmann\nKing's College London, London, U.K.\nrainer.heintzmann@kcl.ac.uk\nhttp://www.gwdg.de/~rheintz/View5D/\nuse mouse click for changing slices, \ndrag images, zoom by typing 'A' and 'a'\n'next page' and 'prev. page'  for changing perpendicular slice ,\n'<' and '>' for perpendicular magnificaltion\ntype 'i' for init, 'c' for change ColorMap, '1,2' and '3,4' for Threshold");
    }
}

