/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.PlotWindow;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Vector;

class ImageCanvas
extends Canvas
implements ImageObserver,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
AdjustmentListener {
    int xadd = 0;
    int yadd = 0;
    int dadd = 0;
    int xprev = 0;
    int yprev = 0;
    int ROIs;
    int ROIe;
    boolean LineROIStarted = false;
    int LROIs = -1;
    int LROIe = -1;
    boolean ROIMoveStarted = false;
    int ROIMoveStartX;
    int ROIMoveStartY;
    int ROIMoveDX = 0;
    int ROIMoveDY = 0;
    boolean ImgDragStarted = false;
    int ximgdrag = 0;
    int yimgdrag = 0;
    int imgw = -1;
    int imgh = -1;
    int xoff = 0;
    int yoff = 0;
    double scale = 1.0;
    double[] LineData;
    double[] AxisData;
    String XAxisTitle = "X";
    String YAxisTitle = "Y";
    CheckboxMenuItem AspectLocked;
    boolean focus = false;
    boolean DispPlot = false;
    Image curimage;
    Container applet;
    ImgPanel myPanel;
    ImageCanvas otherCanvas1;
    ImageCanvas otherCanvas2;
    My3DData my3ddata;
    Vector PlanesXs = new Vector();
    Vector PlanesYs = new Vector();
    Vector PlanesXe = new Vector();
    Vector PlanesYe = new Vector();
    boolean hastoinit = true;
    int DimNr = 0;
    String mytitle = "A Slice";
    PositionLabel label;
    PopupMenu MyPopupMenu;
    public double PositionValue = 1.0;
    private int MaxPos = 1;
    static final long updateRate = 100L;

    public ImageCanvas(Container container, ImgPanel imgPanel, My3DData my3DData, int n, String string) {
        this.MyPopupMenu = new PopupMenu(string);
        this.add(this.MyPopupMenu);
        Menu menu = new Menu("Navigation", false);
        this.MyPopupMenu.add(menu);
        MenuItem menuItem = new MenuItem("Next slice [page up, ) ]");
        menuItem.addActionListener(new MyMenuProcessor(this, ')'));
        menu.add(menuItem);
        menuItem = new MenuItem("Previous slice [page down, ( ]");
        menuItem.addActionListener(new MyMenuProcessor(this, '('));
        menu.add(menuItem);
        menuItem = new MenuItem("Next element (color) [e]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'e'));
        menu.add(menuItem);
        menuItem = new MenuItem("Previous element (color) [E]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'E'));
        menu.add(menuItem);
        menuItem = new MenuItem("Next time [shift-down, ',']");
        menuItem.addActionListener(new MyMenuProcessor(this, ','));
        menu.add(menuItem);
        menuItem = new MenuItem("Previous time [shift-up, '.']");
        menuItem.addActionListener(new MyMenuProcessor(this, '.'));
        menu.add(menuItem);
        menu = new Menu("Display", false);
        this.MyPopupMenu.add(menu);
        menuItem = new MenuItem("Initialize [i]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'i'));
        menu.add(menuItem);
        menuItem = new MenuItem("Initi Global Threshold [I]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'I'));
        menu.add(menuItem);
        menuItem = new MenuItem("Toggle Plot Display [q]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'q'));
        menu.add(menuItem);
        menuItem = new MenuItem("Zoom into square ROI [Z]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'Z'));
        menu.add(menuItem);
        this.AspectLocked = new CheckboxMenuItem("Aspect Locked", false);
        menu.add(this.AspectLocked);
        menuItem = new MenuItem("Zoom in [A]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'A'));
        menu.add(menuItem);
        menuItem = new MenuItem("Zoom out [a]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'a'));
        menu.add(menuItem);
        menuItem = new MenuItem("Zoom in perpend. [>]");
        menuItem.addActionListener(new MyMenuProcessor(this, '>'));
        menu.add(menuItem);
        menuItem = new MenuItem("Zoom in perpend. [<]");
        menuItem.addActionListener(new MyMenuProcessor(this, '<'));
        menu.add(menuItem);
        menu = new Menu("Projections", false);
        this.MyPopupMenu.add(menu);
        menuItem = new MenuItem("Toggle max intensity projection [p]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'p'));
        menu.add(menuItem);
        menuItem = new MenuItem("Toggle sum projection [P]");
        menuItem.addActionListener(new MyMenuProcessor(this, 'P'));
        menu.add(menuItem);
        this.applet = container;
        this.myPanel = imgPanel;
        this.my3ddata = my3DData;
        this.DimNr = n;
        this.mytitle = string;
        this.MaxPos = my3DData.sizes[n];
        this.PositionValue = this.MaxPos / 2;
        this.ROIs = 0;
        this.ROIe = this.MaxPos - 1;
        this.setBounds(0, 0, 100, 100);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    public void TakeOtherCanvas1(ImageCanvas imageCanvas) {
        this.otherCanvas1 = imageCanvas;
    }

    public void TakeOtherCanvas2(ImageCanvas imageCanvas) {
        this.otherCanvas2 = imageCanvas;
    }

    public void ConnectLabel(PositionLabel positionLabel) {
        this.label = positionLabel;
    }

    public boolean LimitPosition(int n) {
        if ((double)n > this.scale * (double)this.MaxPos) {
            if (this.dadd < 0) {
                this.dadd = 0;
                return false;
            }
            if ((double)(n - this.dadd) - this.scale * (double)this.MaxPos < 0.0) {
                this.dadd = n - (int)(this.scale * (double)this.MaxPos);
                return false;
            }
        } else {
            if (this.dadd > 0) {
                this.dadd = 0;
                return false;
            }
            if ((double)(n - this.dadd) - this.scale * (double)this.MaxPos > 0.0) {
                this.dadd = n - (int)(this.scale * (double)this.MaxPos);
                return false;
            }
        }
        return true;
    }

    public void InitScaling() {
        Rectangle rectangle = this.getBounds();
        double d = (double)rectangle.width / (double)this.otherCanvas1.MaxPos;
        double d2 = (double)rectangle.height / (double)this.otherCanvas2.MaxPos;
        double d3 = this.my3ddata.GetScale(0, this.otherCanvas1.DimNr) / this.my3ddata.GetScale(0, this.otherCanvas2.DimNr);
        if (this.AspectLocked.getState()) {
            if (d > d2) {
                d = d2;
            } else {
                d2 = d;
            }
            d2 = d / d3;
            this.otherCanvas1.scale = d;
            this.otherCanvas1.dadd = 0;
            this.otherCanvas2.scale = d2;
            this.otherCanvas2.dadd = 0;
        }
        if (!this.otherCanvas2.AspectLocked.getState()) {
            this.otherCanvas1.scale = d;
            this.otherCanvas1.dadd = 0;
        }
        if (!this.otherCanvas1.AspectLocked.getState()) {
            this.otherCanvas2.scale = d2;
            this.otherCanvas2.dadd = 0;
        }
        this.DispPlot = false;
        if (this.DimNr == 0 && this.my3ddata.GetSize(2) <= 1) {
            this.DispPlot = true;
        }
        if (this.DimNr == 1 && this.my3ddata.GetSize(2) <= 1) {
            this.DispPlot = true;
        }
        if (this.DimNr == 2 && this.my3ddata.GetSize(0) <= 1) {
            this.DispPlot = true;
        }
    }

    Color GetMarkerColor(int n) {
        return this.my3ddata.GetMarkerColor(n);
    }

    public void plot(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(Color.white);
        int n7 = 0;
        int n8 = 0;
        if (this.DimNr == 0) {
            n6 = this.my3ddata.SizeY;
            n5 = (int)this.PositionValue;
            n4 = (int)this.otherCanvas2.PositionValue;
            n3 = (int)this.otherCanvas1.PositionValue;
            graphics.drawLine(rectangle.width - 10, 10, rectangle.width - 10, rectangle.height - 10);
            graphics.setColor(Color.green);
            n7 = (int)this.otherCanvas2.PositionValue;
            graphics.drawLine(0, this.MouseFromY(n7), rectangle.width - 1, this.MouseFromY(n7));
            n8 = 1;
        } else if (this.DimNr == 1) {
            n6 = this.my3ddata.SizeX;
            n5 = (int)this.otherCanvas1.PositionValue;
            n4 = (int)this.PositionValue;
            n3 = (int)this.otherCanvas2.PositionValue;
            graphics.drawLine(10, rectangle.height - 10, rectangle.width - 10, rectangle.height - 10);
            graphics.setColor(Color.green);
            n7 = (int)this.otherCanvas1.PositionValue;
            graphics.drawLine(this.MouseFromX(n7), 0, this.MouseFromX(n7), rectangle.height - 1);
            n8 = 0;
        } else {
            n6 = this.my3ddata.SizeZ;
            n5 = (int)this.otherCanvas1.PositionValue;
            n4 = (int)this.otherCanvas2.PositionValue;
            n3 = (int)this.PositionValue;
            graphics.drawLine(10, rectangle.height - 10, rectangle.width - 10, rectangle.height - 10);
            graphics.setColor(Color.green);
            n7 = (int)this.PositionValue;
            int n9 = n7 * rectangle.width / this.MaxPos;
            graphics.drawLine(n9, 0, n9, rectangle.height - 1);
            n8 = 2;
        }
        String string = this.my3ddata.GetAxisNames()[n8];
        String string2 = this.my3ddata.GetAxisUnits()[n8];
        this.XAxisTitle = string + " [" + string2 + "]";
        String string3 = this.my3ddata.GetValueName(this.my3ddata.GetActiveElement());
        String string4 = this.my3ddata.GetValueUnit(this.my3ddata.GetActiveElement());
        if (this.my3ddata.GetProjectionMode(this.DimNr)) {
            String string5 = !this.my3ddata.GetMIPMode(this.DimNr) ? ", Avg. Proj." : ", Max. Proj.";
            graphics.drawString(string5, rectangle.width - string5.length() * 9, 12);
            this.YAxisTitle = string3 + " [" + string4 + "]" + string5;
        } else {
            this.YAxisTitle = string3 + " [" + string4 + "]";
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n2 = 0; n2 < this.my3ddata.Elements; ++n2) {
            if (!this.my3ddata.InOverlayDispl(n2) && this.my3ddata.ActiveElement != n2) continue;
            graphics.setColor(this.GetMarkerColor(n2));
            for (n = 0; n < n6; ++n) {
                double d = 0.0;
                double d2 = 0.0;
                if (!this.my3ddata.ProjMode[this.DimNr]) {
                    if (this.DimNr == 0) {
                        d = this.my3ddata.NormedValueAt(n5, n, n3, n2);
                        d2 = this.my3ddata.ValueAt(n5, n, n3, n2);
                        n12 = this.MouseFromY(n);
                        n10 = rectangle.width - 10 - (int)((double)(rectangle.width - 20) * d);
                    } else if (this.DimNr == 1) {
                        d = this.my3ddata.NormedValueAt(n, n4, n3, n2);
                        d2 = this.my3ddata.ValueAt(n, n4, n3, n2);
                        n10 = this.MouseFromX(n);
                        n12 = rectangle.height - 10 - (int)((double)(rectangle.height - 20) * d);
                    } else if (this.DimNr == 2) {
                        d = this.my3ddata.NormedValueAt(n5, n4, n, n2);
                        d2 = this.my3ddata.ValueAt(n5, n4, n, n2);
                        n10 = n * rectangle.width / n6;
                        n12 = rectangle.height - 10 - (int)((double)(rectangle.height - 20) * d);
                    }
                } else {
                    d = this.my3ddata.NormedProjValueAt(this.DimNr, n, n2);
                    d2 = this.my3ddata.ProjValueAt(this.DimNr, n, n2);
                    if (this.DimNr == 0) {
                        n12 = this.MouseFromY(n);
                        n10 = rectangle.width - 10 - (int)((double)(rectangle.width - 20) * d);
                    } else if (this.DimNr == 1) {
                        n10 = this.MouseFromX(n);
                        n12 = rectangle.height - 10 - (int)((double)(rectangle.height - 20) * d);
                    } else if (this.DimNr == 2) {
                        n10 = n * rectangle.width / n6;
                        n12 = rectangle.height - 10 - (int)((double)(rectangle.height - 20) * d);
                    }
                }
                if (n != 0) {
                    graphics.drawLine(n11, n13, n10, n12);
                }
                if (n2 == this.my3ddata.GetActiveElement()) {
                    if (this.LineData == null) {
                        this.LineData = new double[n6];
                    }
                    this.LineData[n] = d2;
                    if (this.AxisData == null) {
                        this.AxisData = new double[n6];
                    }
                    this.AxisData[n] = (double)n * this.my3ddata.GetScale(0, n8) + this.my3ddata.GetOffset(0, n8);
                    if (n == n7) {
                        graphics.fillOval(n10 - 5, n12 - 5, 10, 10);
                        if (this.my3ddata.ProjMode[this.DimNr]) {
                            double d3 = this.my3ddata.ProjValueAt(this.DimNr, n, n2);
                            graphics.drawString(this.label.CreateValueString(d3), 5, 12);
                        } else {
                            graphics.drawString(this.label.GetValueString(), 5, 12);
                            graphics.drawString(this.label.GetPositionString(), 5, 24);
                        }
                        if (this.my3ddata.GetLogMode()) {
                            String string6 = "Log. Mode";
                            graphics.drawString(string6, rectangle.width - string6.length() * 9, 24);
                        }
                    }
                }
                n11 = n10;
                n13 = n12;
            }
        }
        graphics.setColor(Color.white);
        if (this.my3ddata.SquareROIs() && (this.otherCanvas1.ROIs >= 0 || this.otherCanvas2.ROIs >= 0)) {
            if (this.DimNr == 1) {
                n2 = this.MouseFromX(this.otherCanvas1.ROIs);
                if (n2 > (n = this.MouseFromX(this.otherCanvas1.ROIe))) {
                    int n14 = n2;
                    n2 = n;
                    n = n14;
                }
                graphics.drawRect(n2, 0, n - n2, rectangle.height - 9);
            } else if (this.DimNr == 0) {
                n2 = this.MouseFromY(this.otherCanvas2.ROIs);
                if (n2 > (n = this.MouseFromY(this.otherCanvas2.ROIe))) {
                    int n15 = n2;
                    n2 = n;
                    n = n15;
                }
                graphics.drawRect(0, n2, rectangle.width - 9, n - n2);
            } else {
                graphics.drawRect(this.ROIs * rectangle.width / this.MaxPos, 0, (this.ROIe - this.ROIs) * rectangle.width / this.MaxPos, rectangle.height - 9);
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = this.getBounds();
        if (this.hastoinit) {
            this.hastoinit = false;
            this.InitScaling();
            this.CalcPrev();
            this.otherCanvas1.repaint();
            this.otherCanvas2.repaint();
        }
        if (this.DispPlot) {
            this.plot(graphics);
            return;
        }
        int n6 = (int)((double)this.otherCanvas1.MaxPos * this.otherCanvas1.scale);
        int n7 = (int)((double)this.otherCanvas2.MaxPos * this.otherCanvas2.scale);
        graphics.drawImage(this.curimage, this.otherCanvas1.dadd, this.otherCanvas2.dadd, n6, n7, this);
        Color color = this.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, rectangle.width - 1, this.otherCanvas2.dadd);
        graphics.fillRect(0, 0, this.otherCanvas1.dadd, rectangle.height - 1);
        graphics.fillRect(n6 + 1 + this.otherCanvas1.dadd, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.fillRect(0, n7 + 1 + this.otherCanvas2.dadd, rectangle.width - 1, rectangle.height - 1);
        if (this.focus) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(Color.white);
        if (this.ROIMoveStarted) {
            graphics.setColor(Color.gray);
        }
        if (this.my3ddata.SquareROIs()) {
            int n8;
            if (this.myPanel.ROIstarted) {
                n8 = this.MouseFromX(this.otherCanvas1.ROIs);
                n5 = this.MouseFromY(this.otherCanvas2.ROIs);
                n4 = this.MouseFromX(this.otherCanvas1.ROIe);
                n3 = this.MouseFromY(this.otherCanvas2.ROIe);
            } else {
                Rectangle rectangle2 = this.my3ddata.GetSqrROI(this.DimNr);
                n8 = this.MouseFromX(rectangle2.x + this.ROIMoveDX);
                n5 = this.MouseFromY(rectangle2.y + this.ROIMoveDY);
                n4 = this.MouseFromX(rectangle2.x + rectangle2.width + this.ROIMoveDX);
                n3 = this.MouseFromY(rectangle2.y + rectangle2.height + this.ROIMoveDY);
            }
            if (n8 > n4) {
                int n9 = n8;
                n8 = n4;
                n4 = n9;
            }
            if (n5 > n3) {
                int n10 = n5;
                n5 = n3;
                n3 = n10;
            }
            graphics.drawRect(n8, n5, n4 - n8, n3 - n5);
        } else {
            if (this.LineROIStarted) {
                int n11 = this.MouseFromX(this.otherCanvas1.LROIs);
                n5 = this.MouseFromY(this.otherCanvas2.LROIs);
                n4 = this.MouseFromX(this.otherCanvas1.LROIe);
                n3 = this.MouseFromY(this.otherCanvas2.LROIe);
                graphics.drawLine(n11, n5, n4, n3);
            }
            float[] fArray = new float[2];
            n5 = this.my3ddata.GetPolyROISize(this.DimNr);
            if (n5 > 0) {
                this.my3ddata.GetPolyROICoords(this.DimNr, 0, fArray);
                n4 = this.MouseFromX(fArray[0] + (float)this.ROIMoveDX);
                n3 = this.MouseFromY(fArray[1] + (float)this.ROIMoveDY);
                for (n2 = 1; n2 < n5; ++n2) {
                    this.my3ddata.GetPolyROICoords(this.DimNr, n2, fArray);
                    int n12 = this.MouseFromX(fArray[0] + (float)this.ROIMoveDX);
                    n = this.MouseFromY(fArray[1] + (float)this.ROIMoveDY);
                    graphics.drawLine(n4, n3, n12, n);
                    n4 = n12;
                    n3 = n;
                }
            }
        }
        n4 = 0;
        n3 = 0;
        int n13 = (int)this.myPanel.c2.PositionValue;
        n = (int)this.myPanel.c3.PositionValue;
        n2 = (int)this.myPanel.c1.PositionValue;
        int n14 = this.my3ddata.ActiveElement;
        int n15 = this.my3ddata.ActiveTime;
        for (int i = 0; i < this.my3ddata.NumMarkerLists(); ++i) {
            int n16 = this.my3ddata.ActiveMarkerListPos();
            if (!this.my3ddata.ShowAllLists && i != n16) continue;
            for (int j = 0; j < this.my3ddata.NumMarkers(i); ++j) {
                int n17;
                APoint aPoint = this.my3ddata.GetPoint(j, i);
                if (this.my3ddata.ShowSpectralTrack) {
                    graphics.setColor(Bundle.ColFromHue((float)aPoint.coord[this.my3ddata.TrackDirection] / (float)this.my3ddata.sizes[this.my3ddata.TrackDirection]));
                } else {
                    graphics.setColor(new Color(aPoint.mycolor));
                }
                double[] dArray = aPoint.coord;
                if (this.DimNr == 0) {
                    n17 = this.DMouseFromX(dArray[2]);
                    n5 = this.DMouseFromY(dArray[1]);
                } else if (this.DimNr == 1) {
                    n17 = this.DMouseFromX(dArray[0]);
                    n5 = this.DMouseFromY(dArray[2]);
                } else {
                    n17 = this.DMouseFromX(dArray[0]);
                    n5 = this.DMouseFromY(dArray[1]);
                }
                if (this.my3ddata.MarkerDisplayed(aPoint, n2, n15)) {
                    if (aPoint.tagged) {
                        graphics.fillOval(n17 - MarkerLists.dx, n5 - MarkerLists.dy, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                    } else {
                        graphics.drawRect(n17 - MarkerLists.dx, n5 - MarkerLists.dy, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                    }
                    if (this.myPanel.DraggedMarker == aPoint) {
                        if (aPoint.tagged) {
                            graphics.drawOval(n17 - MarkerLists.dx - 1, n5 - MarkerLists.dy - 1, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        } else {
                            graphics.fillRect(n17 - MarkerLists.dx, n5 - MarkerLists.dy, MarkerLists.dx * 2 + 1, MarkerLists.dx * 2 + 1);
                        }
                    }
                    this.my3ddata.CheckActiveMarker(i, j, n13, n, n2, n14, n15);
                    if (this.my3ddata.ActiveMarkerPos() == j && i == n16) {
                        graphics.setColor(Color.white);
                        if (aPoint.tagged) {
                            graphics.fillOval(n17 - MarkerLists.dx - 1, n5 - MarkerLists.dy - 1, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        } else {
                            graphics.drawRect(n17 - MarkerLists.dx - 1, n5 - MarkerLists.dy - 1, MarkerLists.dx * 2 + 3, MarkerLists.dx * 2 + 3);
                        }
                    }
                }
                if (this.my3ddata.ActiveMarkerPos() == j && i == n16) {
                    graphics.setColor(Color.white);
                }
                if (j != 0 && this.my3ddata.ConnectionShown && (this.my3ddata.ActiveMarkerPos() == j && i == n16 || this.my3ddata.ShowFullTrace)) {
                    graphics.drawLine(n4, n3, n17, n5);
                }
                n4 = n17;
                n3 = n5;
            }
        }
        int n18 = this.MouseFromX(this.otherCanvas1.PositionValue);
        n5 = this.MouseFromY(this.otherCanvas2.PositionValue);
        graphics.setColor(Color.green);
        if (this.otherCanvas1 != null) {
            graphics.drawLine(n18, 0, n18, n5 - 10);
            graphics.drawLine(n18, n5 + 10, n18, rectangle.height - 1);
        }
        if (this.otherCanvas2 != null) {
            graphics.drawLine(0, n5, n18 - 10, n5);
            graphics.drawLine(n18 + 10, n5, rectangle.width - 1, n5);
        }
        graphics.setColor(Color.white);
        if (this.my3ddata.GetProjectionMode(this.DimNr)) {
            String string = !this.my3ddata.GetMIPMode(this.DimNr) ? "Avg. Proj." : "Max. Proj.";
            graphics.drawString(string, rectangle.width - string.length() * 9, 12);
        }
        graphics.drawString(this.mytitle, 10, 15);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image != this.curimage) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        long l = 0L;
        if ((n & 1) != 0) {
            this.imgw = n4;
            bl2 = true;
        }
        if ((n & 2) != 0) {
            this.imgh = n5;
            bl2 = true;
        }
        if ((n & 0x30) != 0) {
            bl2 = true;
            bl = false;
        } else if ((n & 8) != 0) {
            bl2 = true;
            l = 100L;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if (bl2) {
            this.repaint(l);
        }
        return bl;
    }

    public synchronized Image pickImage() {
        if (!this.DispPlot) {
            this.curimage = this.my3ddata.GiveSection(this.DimNr, (int)this.PositionValue);
        }
        return this.curimage;
    }

    public int MouseFromX(double d) {
        int n = this.otherCanvas1.dadd + (int)(((double)((int)d) + 0.5) * this.otherCanvas1.scale);
        return n;
    }

    public int MouseFromY(double d) {
        int n = this.otherCanvas2.dadd + (int)(((double)((int)d) + 0.5) * this.otherCanvas2.scale);
        return n;
    }

    public int DMouseFromX(double d) {
        int n = this.otherCanvas1.dadd + (int)((d + 0.5) * this.otherCanvas1.scale);
        return n;
    }

    public int DMouseFromY(double d) {
        int n = this.otherCanvas2.dadd + (int)((d + 0.5) * this.otherCanvas2.scale);
        return n;
    }

    public double XFromMouse(int n) {
        double d = (double)(n - this.otherCanvas1.dadd) / this.otherCanvas1.scale;
        if (d < 0.0) {
            d = 0.0;
        }
        if (this.otherCanvas1 != null && d > (double)(this.otherCanvas1.MaxPos - 1)) {
            d = this.otherCanvas1.MaxPos - 1;
        }
        return d;
    }

    public double YFromMouse(int n) {
        double d = (double)(n - this.otherCanvas2.dadd) / this.otherCanvas2.scale;
        if (d < 0.0) {
            d = 0.0;
        }
        if (this.otherCanvas2 != null && d > (double)(this.otherCanvas2.MaxPos - 1)) {
            d = this.otherCanvas2.MaxPos - 1;
        }
        return d;
    }

    void updateothers(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        double d = this.XFromMouse(n);
        if (this.otherCanvas1 != null) {
            if (this.otherCanvas1.PositionValue != d) {
                this.otherCanvas1.PositionValue = d;
                this.otherCanvas1.pickImage();
            }
            this.otherCanvas1.repaint();
        }
        double d2 = this.YFromMouse(n2);
        if (this.otherCanvas2 != null) {
            if (this.otherCanvas2.PositionValue != d2) {
                this.otherCanvas2.PositionValue = d2;
                this.otherCanvas2.pickImage();
            }
            this.otherCanvas2.repaint();
        }
    }

    public void CalcPrev() {
        this.xprev = this.otherCanvas1.dadd + (int)(this.otherCanvas1.PositionValue * this.otherCanvas1.scale + 0.5);
        this.yprev = this.otherCanvas2.dadd + (int)(this.otherCanvas2.PositionValue * this.otherCanvas2.scale + 0.5);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        this.my3ddata.setTime(n);
        this.UpdateAll();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.CalcPrev();
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        APoint aPoint = this.my3ddata.MarkerFromPosition(this.XFromMouse(mouseEvent.getX()) - 0.5, this.YFromMouse(mouseEvent.getY()) - 0.5, this.DimNr, (double)(2 * MarkerLists.dx + 1) / this.otherCanvas1.scale, (double)(2 * MarkerLists.dy + 1) / this.otherCanvas2.scale);
        if (aPoint != null) {
            aPoint.Tag(-1);
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.myPanel.DraggedMarker != null) {
            this.myPanel.DraggedMarker.coord[0] = this.myPanel.SavedMarker.coord[0];
            this.myPanel.DraggedMarker.coord[1] = this.myPanel.SavedMarker.coord[1];
            this.myPanel.DraggedMarker.coord[2] = this.myPanel.SavedMarker.coord[2];
            this.myPanel.DraggedMarker = null;
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
            return;
        }
        if (this.LineROIStarted) {
            if (this.otherCanvas1.LROIs == (int)this.XFromMouse(mouseEvent.getX()) && this.otherCanvas2.LROIs == (int)this.YFromMouse(mouseEvent.getY())) {
                int n = this.my3ddata.GetPolyROISize(this.DimNr);
                if (n <= 2) {
                    this.my3ddata.ClearPolyROIs(this.DimNr);
                } else {
                    float[] fArray = new float[2];
                    this.my3ddata.GetPolyROICoords(this.DimNr, 0, fArray);
                    this.my3ddata.TakePolyROI((int)fArray[0], (int)fArray[1], this.DimNr);
                    this.my3ddata.InvalidateProjs(-1);
                }
                this.LineROIStarted = false;
                this.UpdateAll();
                return;
            }
            this.my3ddata.TakePolyROI((int)this.XFromMouse(mouseEvent.getX()), (int)this.YFromMouse(mouseEvent.getY()), this.DimNr);
            this.otherCanvas1.LROIs = (int)this.XFromMouse(mouseEvent.getX());
            this.otherCanvas2.LROIs = (int)this.YFromMouse(mouseEvent.getY());
            return;
        }
        if (mouseEvent.isControlDown()) {
            this.ROIMoveStarted = true;
            this.ROIMoveStartX = (int)(this.XFromMouse(mouseEvent.getX()) - 0.5);
            this.ROIMoveStartY = (int)(this.YFromMouse(mouseEvent.getY()) - 0.5);
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (this.my3ddata.SquareROIs()) {
                this.myPanel.ROIstarted = true;
                this.otherCanvas1.ROIs = (int)this.XFromMouse(mouseEvent.getX());
                this.otherCanvas2.ROIs = (int)this.YFromMouse(mouseEvent.getY());
                return;
            }
            if (!this.LineROIStarted) {
                this.LineROIStarted = true;
                this.my3ddata.ClearPolyROIs(this.DimNr);
                this.LROIs = -1;
                this.otherCanvas1.LROIs = (int)this.XFromMouse(mouseEvent.getX());
                this.otherCanvas2.LROIs = (int)this.YFromMouse(mouseEvent.getY());
                this.my3ddata.TakePolyROI((int)this.XFromMouse(mouseEvent.getX()), (int)this.YFromMouse(mouseEvent.getY()), this.DimNr);
                return;
            }
        } else {
            if (!this.DispPlot) {
                APoint aPoint = this.my3ddata.MarkerFromPosition(this.XFromMouse(mouseEvent.getX()) - 0.5, this.YFromMouse(mouseEvent.getY()) - 0.5, this.DimNr, (double)(2 * MarkerLists.dx + 1) / this.otherCanvas1.scale, (double)(2 * MarkerLists.dy + 1) / this.otherCanvas2.scale);
                if (aPoint != null) {
                    this.myPanel.DraggedMarker = aPoint;
                    this.myPanel.SavedMarker = (APoint)aPoint.clone();
                } else {
                    if (mouseEvent.isMetaDown() || mouseEvent.getClickCount() > 1 || (mouseEvent.getModifiers() & 8) != 0) {
                        this.ImgDragStarted = true;
                    }
                    if (this.ImgDragStarted) {
                        this.ximgdrag = mouseEvent.getX();
                        this.yimgdrag = mouseEvent.getY();
                        this.ImgDragStarted = true;
                        return;
                    }
                    this.xprev = mouseEvent.getX();
                    this.yprev = mouseEvent.getY();
                }
            } else if (this.DimNr == 0) {
                this.yprev = mouseEvent.getY();
            } else if (this.DimNr == 1) {
                this.xprev = mouseEvent.getX();
            } else if (this.DimNr == 2) {
                this.PositionValue = this.MaxPos * mouseEvent.getX() / this.getBounds().width;
            }
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.MyPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.ImgDragStarted) {
            this.ImgDragStarted = false;
        }
        if (this.myPanel.DraggedMarker != null) {
            this.my3ddata.UpdateMarker(this.myPanel.DraggedMarker);
            this.myPanel.DraggedMarker = null;
            this.repaint();
            this.updateothers(this.xprev, this.yprev);
            this.label.CoordsChanged();
            return;
        }
        if (!mouseEvent.isControlDown()) {
            this.ROIMoveStarted = false;
            this.ROIMoveDX = 0;
            this.ROIMoveDY = 0;
            this.repaint();
        }
        if (this.ROIMoveStarted & mouseEvent.isControlDown()) {
            this.my3ddata.MoveROI(this.ROIMoveDX, this.ROIMoveDY, this.DimNr);
            this.ROIMoveStarted = false;
            this.ROIMoveDX = 0;
            this.ROIMoveDY = 0;
            this.LROIs = -1;
            this.UpdateAll();
            return;
        }
        int n = this.otherCanvas1.MaxPos - 1;
        int n2 = this.otherCanvas2.MaxPos - 1;
        if (this.myPanel.ROIstarted) {
            this.otherCanvas1.ROIe = (int)this.XFromMouse(mouseEvent.getX());
            this.otherCanvas2.ROIe = (int)this.YFromMouse(mouseEvent.getY());
            if (this.otherCanvas1.ROIe == this.otherCanvas1.ROIs && this.otherCanvas2.ROIe == this.otherCanvas2.ROIs) {
                this.my3ddata.TakeROI(0, 0, n, n2, this.DimNr);
                this.otherCanvas1.ROIs = 0;
                this.otherCanvas1.ROIe = this.otherCanvas1.MaxPos - 1;
                this.otherCanvas2.ROIs = 0;
                this.otherCanvas2.ROIe = this.otherCanvas2.MaxPos - 1;
                this.ROIs = 0;
                this.ROIe = n;
                this.UpdateAll();
            } else {
                this.my3ddata.TakeROI(this.otherCanvas1.ROIs, this.otherCanvas2.ROIs, this.otherCanvas1.ROIe, this.otherCanvas2.ROIe, this.DimNr);
                this.UpdateAll();
            }
        }
        this.myPanel.ROIstarted = false;
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ROIMoveStarted) {
            if (!mouseEvent.isControlDown()) {
                this.ROIMoveStarted = false;
                this.ROIMoveDX = 0;
                this.ROIMoveDY = 0;
                this.repaint();
                return;
            }
            this.ROIMoveDX = (int)(this.XFromMouse(mouseEvent.getX()) - 0.5) - this.ROIMoveStartX;
            this.ROIMoveDY = (int)(this.YFromMouse(mouseEvent.getY()) - 0.5) - this.ROIMoveStartY;
            this.repaint();
            return;
        }
        if (this.myPanel.DraggedMarker != null) {
            this.myPanel.DraggedMarker.UpdatePosition(this.XFromMouse(mouseEvent.getX()) - 0.5, this.YFromMouse(mouseEvent.getY()) - 0.5, this.DimNr);
        } else if (!this.myPanel.ROIstarted && !this.LineROIStarted) {
            if (this.ImgDragStarted) {
                boolean bl = false;
                this.otherCanvas1.dadd += mouseEvent.getX() - this.ximgdrag;
                bl |= this.otherCanvas1.LimitPosition(this.getBounds().width);
                this.otherCanvas2.dadd += mouseEvent.getY() - this.yimgdrag;
                bl |= this.otherCanvas2.LimitPosition(this.getBounds().height);
                this.ximgdrag = mouseEvent.getX();
                this.yimgdrag = mouseEvent.getY();
                this.repaint();
                return;
            }
            this.xprev = mouseEvent.getX();
            this.yprev = mouseEvent.getY();
        } else {
            if (this.myPanel.ROIstarted) {
                this.otherCanvas1.ROIe = (int)this.XFromMouse(mouseEvent.getX());
                this.otherCanvas2.ROIe = (int)this.YFromMouse(mouseEvent.getY());
            }
            if (this.LineROIStarted) {
                this.otherCanvas1.LROIe = (int)this.XFromMouse(mouseEvent.getX());
                this.otherCanvas2.LROIe = (int)this.YFromMouse(mouseEvent.getY());
            }
        }
        this.repaint();
        this.updateothers(this.xprev, this.yprev);
        this.label.CoordsChanged();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.LineROIStarted) {
            this.otherCanvas1.LROIe = (int)this.XFromMouse(mouseEvent.getX());
            this.otherCanvas2.LROIe = (int)this.YFromMouse(mouseEvent.getY());
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void RedrawAll() {
        this.repaint();
        this.otherCanvas1.repaint();
        this.otherCanvas2.repaint();
    }

    public void UpdateAllNoCoord() {
        this.pickImage();
        this.repaint();
        this.otherCanvas1.pickImage();
        this.otherCanvas1.repaint();
        this.otherCanvas2.pickImage();
        this.otherCanvas2.repaint();
    }

    public void UpdateAll() {
        this.UpdateAllNoCoord();
        this.label.CoordsChanged();
    }

    public void UpdateAllPanels() {
        if (this.applet instanceof View5D_) {
            ((View5D_)this.applet).UpdatePanels();
        } else {
            ((View5D)this.applet).UpdatePanels();
        }
        this.label.CoordsChanged();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        if (40 == keyEvent.getKeyCode()) {
            if (this.otherCanvas2.PositionValue < (double)(this.otherCanvas2.MaxPos - 1)) {
                this.otherCanvas2.PositionValue += 1.0;
            }
            this.UpdateAll();
            return;
        }
        if (38 == keyEvent.getKeyCode()) {
            if (this.otherCanvas2.PositionValue > 0.0) {
                this.otherCanvas2.PositionValue -= 1.0;
            }
            this.UpdateAll();
            return;
        }
        if (39 == keyEvent.getKeyCode()) {
            if (this.otherCanvas1.PositionValue < (double)(this.otherCanvas1.MaxPos - 1)) {
                this.otherCanvas1.PositionValue += 1.0;
            }
            this.UpdateAll();
            return;
        }
        if (37 == keyEvent.getKeyCode()) {
            if (this.otherCanvas1.PositionValue > 0.0) {
                this.otherCanvas1.PositionValue -= 1.0;
            }
            this.UpdateAll();
            return;
        }
        if (33 == keyEvent.getKeyCode()) {
            n = keyEvent.isShiftDown() ? 44 : 40;
        }
        if (34 == keyEvent.getKeyCode()) {
            n = keyEvent.isShiftDown() ? 46 : 41;
        }
        this.ProcessKey((char)n);
    }

    void SpawnHistogram(boolean bl) {
        if (this.my3ddata.DataToHistogram != null) {
            this.my3ddata.ApplyHistSelection();
            if (this.myPanel.DataPanel != null) {
                this.myPanel.DataPanel.c1.UpdateAll();
            }
        } else if (this.my3ddata.MyHistogram == null || bl) {
            int n = 128;
            double d = this.my3ddata.GetScaledRange(this.my3ddata.HistoX);
            if (d <= 0.0) {
                System.out.println("No coordinate selected as X histogram coordinate");
                return;
            }
            int n2 = n;
            double[] dArray = new double[5];
            for (int i = 0; i < 5; ++i) {
                dArray[i] = 1.0;
            }
            double[] dArray2 = new double[5];
            for (int i = 0; i < 5; ++i) {
                dArray2[i] = 0.0;
            }
            double d2 = 1.0;
            double d3 = 0.0;
            dArray[0] = d / ((double)n2 - 1.0);
            if (d > 50.0) {
                dArray[0] = (int)((d - 1.0) / (double)n) + 1;
                n2 = (int)(d / dArray[0]);
                System.out.println("X Histscale : " + n2 + ", " + dArray[0] + "\n");
            }
            double d4 = 1.0;
            double d5 = 1.0;
            int n3 = 1;
            int n4 = 1;
            dArray2[0] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoX);
            if (this.my3ddata.HistoY >= 0) {
                d4 = this.my3ddata.GetScaledRange(this.my3ddata.HistoY);
                if (d4 <= 0.0) {
                    System.out.println("No coordinate selected as Y histogram coordinate");
                    return;
                }
                if (d4 > 50.0) {
                    dArray[1] = (int)((d4 - 1.0) / (double)n) + 1;
                    n3 = (int)(d4 / dArray[1]);
                    System.out.println("Y Histscale : " + n3 + ", " + dArray[1] + "\n");
                } else {
                    n3 = n;
                    dArray[1] = d4 / ((double)n3 - 1.0);
                    System.out.println("::: Y Histscale : " + n3 + ", " + d4 + ", " + dArray[1] + "\n");
                }
                dArray2[1] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoY);
            }
            if (this.my3ddata.HistoZ >= 0) {
                d5 = this.my3ddata.GetScaledRange(this.my3ddata.HistoZ);
                if (d5 <= 0.0) {
                    System.out.println("No coordinate selected as Z histogram coordinate");
                    return;
                }
                if (d5 > 50.0) {
                    dArray[2] = (int)((d5 - 1.0) / (double)n) + 1;
                    n4 = (int)(d5 / dArray[2]);
                } else {
                    n4 = n;
                    dArray[2] = d5 / ((double)n4 - 1.0);
                }
                dArray2[2] = this.my3ddata.GetScaledMincs(this.my3ddata.HistoZ);
            }
            My3DData my3DData = new My3DData(this.applet, n2, n3, n4, 1, 1, -1, -1, -1, 0, -1, -1, AnElement.IntegerType, 4, 31, dArray, dArray2, 1.0, 0.0, this.my3ddata.GetAxisNames(), this.my3ddata.GetAxisUnits());
            my3DData.TakeDataToHistogram(this.my3ddata);
            my3DData.ComputeHistogram();
            my3DData.ToggleModel(5);
            my3DData.ToggleOverlayDispl(1);
            AlternateViewer alternateViewer = new AlternateViewer(this.applet);
            alternateViewer.Assign3DData(this.applet, this.myPanel, my3DData);
            if (this.my3ddata.MyHistogram == null) {
                this.my3ddata.MyHistogram = my3DData;
            }
            this.my3ddata.DataToHistogram = null;
        } else {
            if (this.my3ddata.MyHistogram.Elements == 1) {
                this.my3ddata.MyHistogram.colormode = true;
            }
            this.my3ddata.MyHistogram.CloneLastElements();
            this.my3ddata.MyHistogram.TakeDataToHistogram(this.my3ddata);
            this.my3ddata.MyHistogram.ComputeHistogram();
        }
    }

    public PlotWindow ExportValues() {
        PlotWindow plotWindow = new PlotWindow("View5D Plot", this.XAxisTitle, this.YAxisTitle, this.AxisData, this.LineData);
        plotWindow.draw();
        return plotWindow;
    }

    public void ProcessKey(char c) {
        switch (c) {
            case ' ': {
                this.ImgDragStarted = true;
                return;
            }
            case 'D': {
                this.my3ddata.DeleteActElement();
                this.UpdateAllPanels();
                return;
            }
            case 'f': {
                this.my3ddata.CloneFloat();
                this.UpdateAllPanels();
                return;
            }
            case 'F': {
                this.my3ddata.CloneShort();
                this.UpdateAllPanels();
                return;
            }
            case '+': {
                this.my3ddata.AddMarkedElement();
                this.UpdateAllPanels();
                return;
            }
            case '_': {
                this.my3ddata.AdjustOffsetToROIMean();
                this.UpdateAllPanels();
                return;
            }
            case '-': {
                this.my3ddata.SubMarkedElement();
                this.UpdateAllPanels();
                return;
            }
            case '*': {
                this.my3ddata.MulMarkedElement();
                this.UpdateAllPanels();
                return;
            }
            case '/': {
                this.my3ddata.DivMarkedElement();
                this.UpdateAllPanels();
                return;
            }
            case 'e': {
                this.my3ddata.advanceElement(1);
                this.UpdateAll();
                return;
            }
            case 'E': {
                this.my3ddata.advanceElement(-1);
                this.UpdateAll();
                return;
            }
            case 't': {
                this.my3ddata.AdjustThresh(false);
                this.UpdateAll();
                return;
            }
            case 'T': {
                this.my3ddata.AdjustThresh(true);
                this.UpdateAll();
                return;
            }
            case 'n': {
                this.my3ddata.MarkerDialog();
                this.UpdateAll();
                return;
            }
            case 'N': {
                this.my3ddata.AxesUnitsDialog();
                this.my3ddata.InvalidateProjs(-1);
                this.label.CoordsChanged();
                break;
            }
            case 'r': {
                this.my3ddata.ToggleModel(1);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'R': {
                this.my3ddata.ToggleModel(5);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'g': {
                this.my3ddata.ToggleModel(2);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'G': {
                this.my3ddata.ToggleModel(0);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'b': {
                this.my3ddata.ToggleModel(3);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'B': {
                this.my3ddata.ToggleModel(10);
                this.my3ddata.ToggleOverlayDispl(1);
                this.UpdateAll();
                return;
            }
            case 'v': {
                this.my3ddata.ToggleOverlayDispl(-1);
                this.UpdateAll();
                return;
            }
            case 'V': {
                this.my3ddata.ToggleMulDispl(-1);
                this.UpdateAll();
                return;
            }
            case 'k': {
                this.my3ddata.NewMarkerList();
                this.my3ddata.SetMarker(this.label.px, this.label.py, this.label.pz);
                this.UpdateAll();
                return;
            }
            case 'K': {
                this.my3ddata.RemoveMarkerList();
                this.UpdateAll();
                return;
            }
            case '&': {
                this.my3ddata.TagMarker();
                System.out.println("Error Tagged Component setValue called\n");
                this.UpdateAll();
                return;
            }
            case 'm': {
                this.my3ddata.SetMarker(this.label.px, this.label.py, this.label.pz);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case 'M': {
                this.my3ddata.RemovePoint();
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case '$': {
                this.my3ddata.cleanup();
                this.applet.removeAll();
                this.otherCanvas1.removeNotify();
                this.otherCanvas2.removeNotify();
                this.removeNotify();
                if (this.applet instanceof View5D_) {
                    ((View5D_)this.applet).dispose();
                } else {
                    ((View5D)this.applet).stop();
                    ((View5D)this.applet).destroy();
                }
                return;
            }
            case 'Q': {
                this.my3ddata.RemoveTrailingPoints();
                this.UpdateAll();
                return;
            }
            case '0': {
                this.my3ddata.AdvancePoint(1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case '9': {
                this.my3ddata.AdvancePoint(-1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case 'j': {
                this.my3ddata.AdvanceMarkerList(1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case 'J': {
                this.my3ddata.AdvanceMarkerList(-1);
                if (this.my3ddata.FocusDispToMarker) {
                    this.myPanel.setPositions(this.my3ddata.GetActiveMarker());
                }
                this.UpdateAll();
                return;
            }
            case 'w': {
                this.my3ddata.ToggleMarkerListColor(1);
                this.UpdateAll();
                return;
            }
            case 'W': {
                this.my3ddata.AutoTrack();
                this.UpdateAll();
                return;
            }
            case '#': {
                this.my3ddata.SubtractTrackedSpot();
                this.my3ddata.InvalidateProjs(-1);
                this.my3ddata.InvalidateSlices();
                this.UpdateAll();
                return;
            }
            case 's': {
                AlternateViewer alternateViewer = new AlternateViewer(this.applet);
                My3DData my3DData = new My3DData(this.my3ddata);
                alternateViewer.Assign3DData(this.applet, null, my3DData);
                this.UpdateAll();
                return;
            }
            case 'P': {
                this.my3ddata.ToggleProj(this.DimNr, false);
                this.label.CoordsChanged();
                this.UpdateAll();
                return;
            }
            case 'p': {
                this.my3ddata.ToggleProj(this.DimNr, true);
                this.UpdateAll();
                return;
            }
            case '^': {
                this.my3ddata.ActElement().AdvanceReadMode();
                this.my3ddata.InvalidateSlices();
                this.my3ddata.InvalidateProjs(-1);
                this.UpdateAll();
                return;
            }
            case 'S': {
                if (!this.myPanel.ROIstarted && !this.LineROIStarted) {
                    this.my3ddata.ToggleSquareROIs();
                    this.my3ddata.InvalidateProjs(-1);
                    this.UpdateAll();
                }
                return;
            }
            case 'x': {
                this.my3ddata.MarkAsHistoDim(0);
                this.label.CoordsChanged();
                return;
            }
            case 'y': {
                this.my3ddata.MarkAsHistoDim(1);
                this.label.CoordsChanged();
                return;
            }
            case 'z': {
                this.my3ddata.MarkAsHistoDim(2);
                this.label.CoordsChanged();
                return;
            }
            case 'Z': {
                double d = (double)this.getBounds().width / (1.5 + (double)this.otherCanvas1.ROIe - (double)this.otherCanvas1.ROIs);
                double d2 = (double)this.getBounds().height / (1.5 + (double)this.otherCanvas2.ROIe - (double)this.otherCanvas2.ROIs);
                if (this.AspectLocked.getState()) {
                    if (d > d2) {
                        d = d2;
                    } else {
                        d2 = d;
                    }
                }
                this.otherCanvas1.scale = d;
                this.otherCanvas2.scale = d2;
                this.otherCanvas1.dadd -= this.MouseFromX((double)this.otherCanvas1.ROIs - 0.5);
                this.otherCanvas2.dadd -= this.MouseFromY((double)this.otherCanvas2.ROIs - 0.5);
                this.UpdateAll();
                return;
            }
            case 'U': {
                this.my3ddata.toggleGate(-1);
                this.UpdateAll();
                return;
            }
            case 'u': {
                this.my3ddata.setGate();
                this.UpdateAll();
                return;
            }
            case 'H': 
            case 'h': {
                this.SpawnHistogram(c == 'H');
                this.UpdateAllPanels();
                return;
            }
            case 'C': {
                this.my3ddata.ToggleColor();
                this.UpdateAll();
                return;
            }
            case 'c': {
                this.my3ddata.ToggleModel(-1);
                this.UpdateAll();
                return;
            }
            case 'd': {
                this.my3ddata.InvertCMap();
                this.my3ddata.ToggleModel(-1);
                this.my3ddata.InvertCMap();
                this.UpdateAll();
                return;
            }
            case 'o': {
                this.my3ddata.ToggleOvUn(-1);
                this.UpdateAll();
                return;
            }
            case 'O': {
                this.my3ddata.ToggleLog(-1);
                this.UpdateAll();
                return;
            }
            case ',': {
                this.my3ddata.nextTime(1);
                this.UpdateAll();
                return;
            }
            case '.': {
                this.my3ddata.nextTime(-1);
                this.UpdateAll();
                return;
            }
            case '(': {
                if (this.PositionValue < (double)(this.MaxPos - 1)) {
                    this.PositionValue += 1.0;
                }
                this.UpdateAll();
                return;
            }
            case ')': {
                if (this.PositionValue > 0.0) {
                    this.PositionValue -= 1.0;
                }
                this.UpdateAll();
                return;
            }
            case 'A': {
                this.otherCanvas1.dadd = (int)((double)this.otherCanvas1.dadd - 0.125 * this.otherCanvas1.scale * this.otherCanvas1.PositionValue);
                this.otherCanvas1.scale *= 1.125;
                this.otherCanvas1.LimitPosition(this.getBounds().width);
                this.otherCanvas2.dadd = (int)((double)this.otherCanvas2.dadd - 0.125 * this.otherCanvas2.scale * this.otherCanvas2.PositionValue);
                this.otherCanvas2.scale *= 1.125;
                this.otherCanvas2.LimitPosition(this.getBounds().height);
                if (this.otherCanvas2.AspectLocked.getState() || this.otherCanvas1.AspectLocked.getState()) {
                    this.dadd = (int)((double)this.dadd - 0.125 * this.scale * this.PositionValue);
                    this.scale *= 1.125;
                    this.LimitPosition(this.getBounds().height);
                }
                this.RedrawAll();
                this.label.CoordsChanged();
                return;
            }
            case 'a': {
                if (this.otherCanvas1.scale > 0.5 && this.otherCanvas2.scale > 0.5) {
                    this.otherCanvas1.scale /= 1.125;
                    this.otherCanvas1.dadd = (int)((double)this.otherCanvas1.dadd + 0.125 * this.otherCanvas1.scale * this.otherCanvas1.PositionValue);
                    this.otherCanvas1.LimitPosition(this.getBounds().width);
                    this.otherCanvas2.scale /= 1.125;
                    this.otherCanvas2.dadd = (int)((double)this.otherCanvas2.dadd + 0.125 * this.otherCanvas2.scale * this.otherCanvas2.PositionValue);
                    this.otherCanvas2.LimitPosition(this.getBounds().height);
                    if (this.otherCanvas2.AspectLocked.getState() || this.otherCanvas1.AspectLocked.getState()) {
                        this.scale /= 1.125;
                        this.dadd = (int)((double)this.dadd + 0.125 * this.scale * this.PositionValue);
                        this.LimitPosition(this.getBounds().height);
                    }
                }
                this.RedrawAll();
                this.label.CoordsChanged();
                return;
            }
            case '>': {
                if (!this.otherCanvas1.AspectLocked.getState() && !this.otherCanvas2.AspectLocked.getState()) {
                    this.dadd = (int)((double)this.dadd - 0.125 * this.scale * this.PositionValue);
                    this.scale *= 1.25;
                    this.RedrawAll();
                }
                return;
            }
            case '<': {
                if (!this.otherCanvas1.AspectLocked.getState() && !this.otherCanvas2.AspectLocked.getState() && this.scale > 1.0) {
                    this.scale /= 1.125;
                    this.dadd = (int)((double)this.dadd + 0.125 * this.scale * this.PositionValue);
                    this.RedrawAll();
                }
                return;
            }
            case 'q': {
                this.DispPlot = !this.DispPlot;
                this.repaint();
                return;
            }
            case ':': {
                this.xadd += 5;
                this.repaint();
                return;
            }
            case ';': {
                this.xadd -= 5;
                this.repaint();
                return;
            }
            case '!': {
                this.my3ddata.CThreshToValThresh(-1, 0.0, 1.0);
                this.UpdateAll();
                return;
            }
            case '1': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(0.02);
                } else {
                    this.my3ddata.adjustColorMapLThresh(0.02);
                }
                this.UpdateAll();
                return;
            }
            case '2': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(-0.02);
                } else {
                    this.my3ddata.adjustColorMapLThresh(-0.02);
                }
                this.UpdateAll();
                return;
            }
            case '3': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(0.02);
                } else {
                    this.my3ddata.adjustColorMapUThresh(0.02);
                }
                this.UpdateAll();
                return;
            }
            case '4': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(-0.02);
                } else {
                    this.my3ddata.adjustColorMapUThresh(-0.02);
                }
                this.UpdateAll();
                return;
            }
            case '5': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(0.002);
                } else {
                    this.my3ddata.adjustColorMapLThresh(0.002);
                }
                this.UpdateAll();
                return;
            }
            case '6': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addLThresh(-0.002);
                } else {
                    this.my3ddata.adjustColorMapLThresh(-0.002);
                }
                this.UpdateAll();
                return;
            }
            case '7': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(0.002);
                } else {
                    this.my3ddata.adjustColorMapUThresh(0.002);
                }
                this.UpdateAll();
                return;
            }
            case '8': {
                if (this.my3ddata.GateActive && this.my3ddata.GateElem == this.my3ddata.GateElem) {
                    this.my3ddata.addUThresh(-0.002);
                } else {
                    this.my3ddata.adjustColorMapUThresh(-0.002);
                }
                this.UpdateAll();
                return;
            }
            case 'i': {
                this.InitScaling();
                this.CalcPrev();
                this.UpdateAll();
                return;
            }
            case 'I': {
                this.my3ddata.initGlobalThresh();
                this.InitScaling();
                this.CalcPrev();
                this.UpdateAll();
                return;
            }
            case 'X': {
                if (this.applet instanceof View5D_) {
                    if (this.DispPlot) {
                        this.ExportValues();
                    } else {
                        this.my3ddata.Export(this.DimNr, (int)this.PositionValue);
                    }
                }
                return;
            }
            case 'Y': {
                this.my3ddata.GenerateMask(this.DimNr);
                this.UpdateAll();
                return;
            }
            case 'l': {
                if (this.applet instanceof View5D_) {
                    ((View5D_)this.applet).LoadImg(0);
                } else {
                    this.my3ddata.Load(this.my3ddata.PrevType, this.my3ddata.PrevBytes, this.my3ddata.PrevBits, ((View5D)this.applet).filename, (View5D)this.applet);
                }
                this.UpdateAllPanels();
                this.UpdateAll();
                return;
            }
            case 'L': {
                this.my3ddata.LoadMarkers();
                this.UpdateAllPanels();
                return;
            }
            case '?': {
                this.label.Help();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

