#ifndef DIP_THREADS_H
#define DIP_THREADS_H
#ifdef __cplusplus
extern "C" {
#endif

dip_Error dip_ThreadsInitialise( void );

/************************** POSIX Threads ****************************/
#if defined(DIP_PORT_HAS_POSIX_THREADS)

/* link with -lpthread */

#include <pthread.h>

typedef pthread_t dip_ThreadID;
typedef void *(*dip_ThreadFunction)( void *);

#define dip_ThreadCreate( id, func, data ) \
		pthread_create( id, 0, (dip_ThreadFunction) func, data )
#define dip_ThreadJoin( id )	pthread_join( id, 0 )

/************************** "sequencial" Threads *********************/

#else /* default */

/*#define DIP_THREADS_NONE*/ /* not used (CL) */

typedef dip_int dip_ThreadID;
typedef void (*dip_ThreadFunction)( void *);

#define dip_ThreadCreate( id, func, data )	func( (void *) data )
#define dip_ThreadJoin( id )	id = 0

#endif

/*********************************************************************/

#ifdef __cplusplus
}
#endif
#endif
