/*
 * Filename: dip_limits.h
 *
 * (C) Copyright 1995-1997               Pattern Recognition Group
 *     All rights reserved               Faculty of Applied Physics
 *                                       Delft University of Technology
 *                                       Lorentzweg 1
 *                                       2628 CJ Delft
 *                                       The Netherlands
 *
 * Contact: Dr. ir. Lucas J. van Vliet
 * email : lucas@ph.tn.tudelft.nl
 *
 *
 * Definition of the limits on the DIPlib types.
 *
 */

#ifndef DIP_LIMITS_H
#define DIP_LIMITS_H
#ifdef __cplusplus
extern "C" {
#endif

#define DIP_MAX_UINT8     0xFF
#define DIP_MIN_UINT8     0x00
#define DIP_MAX_UINT16    0xFFFF
#define DIP_MIN_UINT16    0x0000
#define DIP_MAX_UINT32    0xFFFFFFFF
#define DIP_MIN_UINT32    0x00000000
#ifdef DIP_64BITS
#define DIP_MAX_UINT64    0xFFFFFFFFFFFFFFFF
#define DIP_MIN_UINT64    0x0000000000000000
#endif

#define DIP_MAX_SINT8     0x7F
#define DIP_MIN_SINT8    -0x80
#define DIP_MAX_SINT16    0x7FFF
#define DIP_MIN_SINT16   -0x8000
#define DIP_MAX_SINT32    0x7FFFFFFF
#define DIP_MIN_SINT32   -0x80000000
#ifdef DIP_64BITS
#define DIP_MAX_SINT64    0x7FFFFFFFFFFFFFFF
#define DIP_MIN_SINT64   -0x8000000000000000
#endif

#define DIP_MAX_FLOAT32   3.40282346638528860E+38
#define DIP_MIN_FLOAT32   -DIP_MAX_FLOAT32
#define DIP_UND_FLOAT32   1.17549435E-38
#define DIP_MAX_FLOAT64   1.7976931348623157E+308
#define DIP_MIN_FLOAT64   -DIP_MAX_FLOAT64
#define DIP_UND_FLOAT64   2.2250738585072014E-308
#define DIP_MAX_SFLOAT    3.40282346638528860E+38
#define DIP_MIN_SFLOAT    -DIP_MAX_SFLOAT
#define DIP_UND_SFLOAT    1.17549435E-38
#define DIP_MAX_DFLOAT    1.7976931348623157E+308
#define DIP_MIN_DFLOAT    -DIP_MAX_DFLOAT
#define DIP_UND_DFLOAT    2.2250738585072014E-308

/* Effing pollution of the name space! (CL, 02-10-2006)
#define DIP_MAX_uint8     DIP_MAX_UINT8
#define DIP_MIN_uint8     DIP_MIN_UINT8
#define DIP_MAX_uint16    DIP_MAX_UINT16
#define DIP_MIN_uint16    DIP_MIN_UINT16
#define DIP_MAX_uint32    DIP_MAX_UINT32
#define DIP_MIN_uint32    DIP_MIN_UINT32

#define DIP_MAX_sint8     DIP_MAX_SINT8
#define DIP_MIN_sint8     DIP_MIN_SINT8
#define DIP_MAX_sint16    DIP_MAX_SINT16
#define DIP_MIN_sint16    DIP_MIN_SINT16
#define DIP_MAX_sint32    DIP_MAX_SINT32
#define DIP_MIN_sint32    DIP_MIN_SINT32

#define DIP_MAX_float32   DIP_MAX_FLOAT32
#define DIP_MIN_float32   DIP_MIN_FLOAT32
#define DIP_UND_float32   DIP_UND_FLOAT32
#define DIP_MAX_float64   DIP_MAX_FLOAT64
#define DIP_MIN_float64   DIP_MIN_FLOAT64
#define DIP_UND_float64   DIP_UND_FLOAT64
*/

#ifdef DIP_64BITS
#define DIP_MIN_INT       DIP_MIN_SINT64
#define DIP_MAX_INT       DIP_MAX_SINT64
#define DIP_MIN_UINT      DIP_MIN_UINT64
#define DIP_MAX_UINT      DIP_MAX_UINT64
#else
#define DIP_MIN_INT       DIP_MIN_SINT32
#define DIP_MAX_INT       DIP_MAX_SINT32
#define DIP_MIN_UINT      DIP_MIN_UINT32
#define DIP_MAX_UINT      DIP_MAX_UINT32
#endif
#define DIP_MIN_FLOAT     DIP_MIN_FLOAT64
#define DIP_MAX_FLOAT     DIP_MAX_FLOAT64

#ifdef __cplusplus
}
#endif
#endif
