%PARAMTYPE_IMAGE   Called by PARAMTYPE.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, 16, 18 September 2007.
% Built with code extracted from DIPIMAGE.M and GETPARAMS.M

function varargout = paramtype_image(command,param,varargin)

switch command
   case 'control_create'
      fig = varargin{1};   % figure handle
      index = varargin{2}; % item number in the dialog box (1 is topmost control, 0 is topmost label)
      h = uicontrol(fig,...
                    'Style','edit',...
                    'String',param.default,...
                    'Visible','off',...
                    'Tag',['control',num2str(index)],...
                    'HorizontalAlignment','left',...
                    'BackgroundColor',[1,1,1],...
                    'ButtonDownFcn','dipimage do_contextmenu dip_image');
      cm = uicontextmenu('Parent',fig,'UserData',h);
      set(h,'UserData',struct('contextmenu',cm));
      varargout{1} = h;
   case 'control_value'
      varargout{2} = get(varargin{1},'String');
      if isempty(varargout{2})
         varargout{2} = '[]';
      end
      varargout{1} = evalin('base',varargout{2});
      varargout{1} = dip_image(varargout{1});
   case 'default_value'
      try
         varargout{1} = dip_image(evalin('base',param.default));
      catch
         error('Default image evaluation failed.')
      end
   case 'definition_test'
      varargout{1} = '';
      if ~param.required
         if ~ischar(param.default)
            varargout{1} = 'DEFAULT image must be a string';
            return
         end
      end
   case 'value_test'
      varargout{1} = '';
      value = varargin{1};
      %#function isa
      if ~builtin('isa',value,'dip_image') & ~isnumeric(value) & ~islogical(value)
         varargout{1} = 'image expected';
      elseif nargout>1
         value = dip_image(value); % Don't do this if it's not necessary.
      end
      varargout{2} = value;
end
