%DIPMENUS   Not a user function
%   DIPMENUS is used by DIPIMAGE to determine the location of the toolbox
%   functions in the menu system.
%
%   To give your own functions a place in the menus system, create a
%   function called LOCALDIPMENUS, and put it somewhere in the MATLAB
%   path. This function should accept one parameter, the MENULIST,
%   and return a modified MENULIST as well as an EXCLUDELIST:
%      [MENULIST,EXCLUDELIST] = LOCALDIPMENUS(MENULIST)
%   The EXCLUDELIST is a cell array with the function names that should
%   not be put into the menus. The MENULIST is a cell array with two
%   columns, the first one containing the names of the sub-menus, the
%   second one containing a cell array with the function names on that
%   menu. Function names that start with '#' are menu names, and put
%   the corresponding menu as a sub-menu at that point. A '-' instead
%   of a function name inserts a menu separator at that point.
%
%   Look into this function to see how the MENULIST is defined.
%
% NOTE:
%   There is currently no checking for recursive menu definitions: menu
%   A including menu B as a sub-menu, and menu B including menu A. Do no
%   define your menus that way, it will crash MATLAB.

% (C) Copyright 1999-2009               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo & Lucas van Vliet, April 2000.
% 8 August 2001:    Added exclude list (finally).
% 16 July 2002:     Added a few comments to the documentation inside the function.
% 6 October 2003:   Added support for LOCALDIPMENUS.
% 9 September 2008: New!!! Improved!!! Now with Submenus!!!

function [menulist,excludelist] = dipmenus(s)

if nargin ~= 1 | ~strcmp(s,'DIP_GetMenus')
   error('This function does not perform any image processing.')
end

%#function readim readroiim readtimeseries writeim readavi writeavi writedisplayavi
filemenu = {'readim','readroiim','readtimeseries','writeim','-',...
            'readavi','writeavi','writedisplayavi'};
if exist('twain')==3
  %#function twain acquireim
   filemenu = [filemenu,{'-','twainselect','acquireim'}];  % optional features
end
try
   if strcmp(dipgetpref('DebugMode'),'on')
      filemenu = [filemenu,{'-','reload'}];  % special (internal) command
   end
catch
   % skip it!
end
filemenu = [filemenu,{'-','exit'}];       % special (internal) command: not exiting MATLAB

% The MENU list contains a list of function names for each menu name.
% The string '-' inserts a separator between commands.
% The location given here for each function overrides the setting in the
%   function itself (except if it specifies 'none').
menulist = {...
   'File I/O',filemenu;...
   'Display',{'overlay','overlay_label','overlay_confidence','overlay_vector','-',...
      'orientationplot','-',...
      'dipgetimage','dipprofile','dipstackinspect','dipcrop','dipgetcoords','diproi','-',...
      'diptruesize','dipclf',};...
   'Generation',{'newim','-','deltaim','ramp','xx','yy','zz','rr','phiphi','-',...
      'testobject','-','noise','drawline','drawpolygon','gaussianblob'};...
   'Manipulation',{'shift','correctshift','localshift','rotation','rotation3d','mirror','-',...
      'resample','subsample','rebin','split','-','extend','cut'};...
   'Point',{'clip','erfclip','gaussianedgeclip','gaussianlineclip','-',...
      'diphist','diphist2d','mdhistogram','-','stretch','hist_equalize','-','lut','get_subpixel'};...
   'Filters',{'convolve','-','smooth','gaussf','unif','-',...
      'maxf','minf','medif','percf','-','varif','-',...
      '#Differential Filters','#Adaptive Filters','#Morphology','#Binary Filters',...
      '#Diffusion','#Restoration','-','gabor','gabor_click'};...
   'Differential Filters',{'derivative','-',...
      'dx','dy','dz','-','gradientvector','gradmag','-',...
      'dxx','dyy','dzz','dxy','dxz','dyz','dgg','dcc','-',...
      'laplace','laplace_plus_dgg','laplace_min_dgg','-','hessian','dethessian',...
      'prewittf','sobelf'};...
   'Adaptive Filters',{'kuwahara','selectionf','-',...
      'dgg','dcc','tframehessian','-','bilateralf','-',...
      'gaussf_adap','percf_adap','gaussf_adap_banana','percf_adap_banana'};...
   'Binary Filters',{'bdilation','berosion','bopening','bclosing','hitmiss','-',...
      'bskeleton','bpropagation','brmedgeobjs','fillholes','hull','-',...
      'countneighbours','bmajority',...
      'getsinglepixel','getendpixel','getlinkpixel','getbranchpixel'};...
   'Morphology',{'dilation','erosion','closing','opening','tophat','-',...
      'dilation_se','erosion_se','closing_se','opening_se','-',...
      'rankmin_closing','rankmax_opening','rankmin_closing_se','rankmax_opening_se','-',....
      'reconstruction'};...
   'Diffusion',{'gaussf','pmd','aniso','mcd','cpf','ced'};...
   'Restoration',{'wiener','mappg','tikhonovmiller','-','backgroundoffset','afm_flatten'};...
   'Segmentation',{'threshold','hist2image','-','minima','maxima','-',...
      'watershed','waterseed','splitandmerge','canny','-',...
      'label','relabel'};...
   'Transforms',{'ft','ift','-','ht','-','dt','vdt','gdt','-','radoncircle',...
      '-','watershed','waterseed'};...
   'Analysis',{'measure','msr2obj','msr2ds','measurehelp','-',...
      'scalespace','morphscales','scale2rgb','-',...
      'structuretensor','structuretensor3d','curvature','pst','quadraturetensor','-',...
      'granulometry','-','opticflow','findshift','findlocalshift','findlocmax'};...
   'Statistics',{'diphist','diphist2d','mdhistogram','-',...
      'chordlength','paircorrelation','autocorrelation','crosscorrelation','-',...
      'radialsum','radialmean','radialmin','radialmax','-',...
      'entropy','mutualinformation','mre','mae','mse','lfmse','-','cal_readnoise'}...
};

% The EXCLUDE list overrides the MENU list.
% These commands won't appear in the menu, and won't be probed with the 'DIP_GetParamList'
% parameter.
excludelist = {...
   'dip_initialise',...
   'getparams',...
   'dipmex',...
   'dipfig',...
   'dipgetpref',...
   'dipisosurface',...
   'diplink',...
   'dipmapping',...
   'dipmaxaspect',...
   'diporien',...
   'dipsetpref',...
   'dipshow',...
   'dipstep',...
   'diptest',...
   'dipzoom',...
   'array2im',...
   'curvature_thirion',...
   'fast_str2double',...
   'fixlsmfile',...
   'im2array',...
   'isophote_curvature'...
   'jacobi',...
   'orientation4d',...
   'view5d',...
   'Contents'};

if exist('localdipmenus')
   try
      [menulist,excludelist2] = localdipmenus(menulist);
      excludelist2 = reshape(excludelist2,1,prod(size(excludelist2)));
      excludelist = [excludelist,excludelist2];
   catch
      warning('Evaluation of LOCALDIPMENUS failed:')
      disp(lasterr)
   end
end

% This is also testing the menus defined by DIPMENUS, just so we
% ourselves don't make any silly mistakes!
if isempty(menulist)
   error('LOCALDIPMENUS returned an empty menu list.');
end
menus = menulist(:,1);
if length(menus) ~= length(unique(menus))
   error('All menus defined by LOCALDIPMENUS must be unique.')
end
