% GRAY   Linear gray-scale color map
%    GRAY(M) returns an M-by-3 matrix containing a gray-scale colormap.
%    GRAY, by itself, is the same length as the current figure's
%    colormap. If no figure exists, MATLAB creates one.
%            
%    For example, to reset the colormap of the current figure:
%                
%    colormap(gray)
%                       
%    See also HSV, HOT, COOL, BONE, COPPER, PINK, FLAG,
%    COLORMAP, RGBPLOT.

function varargout = grey(varargin)
varargout = cell(1,max(nargout,1));
[varargout{:}] = gray(varargin{:});

