%UMINUS   Overloaded operator for -a.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 30 June 2000: On binary images, we now do not(a)
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
% 10 March 2008: Fixed bug. COMPUTE1 has a new PHYSDIMS input parameter.

function out = uminus(in)
if ~isscalar(in), error('Parameter 1 is an array of images.'); end
try
   if strcmp(in.dip_type,'bin')
      [in,dims,out_type,out_phys] = do1input(in);
      %#function not
      out = compute1('not',in,dims,'bin',out_phys);
   else
      out = compute1('uminus',in);
   end
catch
   error(di_firsterr)
end
