%PROD Product of elements.
%  PROD(IN,M,DIM) computes the product over the dimensions specified
%    in DIM in the mask M.
%
%   If B is a tensor image, PROD(B) is the image with the product over all the
%   tensor components.

% (C) Copyright 1999-2005               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, March 2005.

function value = prod(in,mask,d)
try
   [in,arrayop] = do1arrayinput(in);
catch
   error(di_firsterr)
end

if arrayop
   if nargin > 1
      error('MASK and DIM parameter not supported for tensor images.')
   end
   try
      value = compute0array('times',in);
   catch
      error(di_firsterr)
   end
else
   nd = ndims(in);
   if nd == 0
      value = double(in);
   else
      if nargin < 2
         mask = [];
      end
      try
         if nargin < 3
            process = di_processarray(nd);
            value = double(dip_prod(in,mask,process));
         else
            process = di_processarray(nd,d);
            value = dip_prod(in,mask,process);
         end
      catch
         error(di_firsterr)
      end
   end
end
