%[IN,DIMS,OUT_TYPE,OUT_PHYS] = DO1INPUT(IN)
%    Checks the input image image.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 18 January 2001:  Added DIMS parameter. Changed all calls to this
%                   function accordingly.
% 22 June 2001:     Dimensionality of input determined through DI_NDIMS if
%                   it is a MATLAB array. Correct for 0D and 1D arrays now.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
%                   Calling dip_image on non-object inputs to make this simpler.
% February 2008:    Adding pixel dimensions and units to dip_image. (BR)

function [in,dims,out_type,out_phys] = do1input(in)
if nargin ~= 1, error('Erroneus input.'); end
if nargout == 0
   error('Erroneus output.')
end
if ~di_isdipimobj(in)
   in = dip_image(in);
end
if ~isscalar(in), error('Parameter 1 is an array of images.'); end
dims = in.dims;
if nargout > 2
   out_type = di_findtype(in.dip_type,'sfloat');
end
if nargout > 3
   out_phys = in.physDims;
end
in = in.data;
