%OUT = COMPUTE2ARRAY(OPERATION,IN1,IN2)
%    This applies COMPUTE2 on each pair of images IN1{ii},IN2{ii}.
%    If either IN1 or IN2 is not an array, each image in the other input
%    is operated on with the same image: IN1{ii},IN2 or vice-versa. If
%    the array dimensionalities do not match, it produces an error.
%
%    This function should be called after DOARRAYINPUTS if the ARRAYOP
%    flag returned was non-zero (true).

% (C) Copyright 1999-2003               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, July 2000.
% 18 December 2001: Color information is not as volitile anymore.

function out = compute2array(operation,in1,in2)
if nargin ~= 3
   error('Erroneus input.')
end
isscalar = 0;
s1 = imarsize(in1); if prod(s1) == 1, isscalar = 1; end % empty arrays are not scalar
s2 = imarsize(in2); if prod(s2) == 1, isscalar = 2; end
if isscalar==1 % the first is scalar, but the second not.
   s = s2;
else % isscalar==2 or 0
   s = s1;
end
out = dip_image('array',s);
if isscalar==1
   col = in2(1).color;
   for ii=1:prod(s)
      out(ii) = compute2(operation,in1,in2(ii));
      out(ii).color = col;
   end
elseif isscalar==2
   col = in1(1).color;
   for ii=1:prod(s)
      out(ii) = compute2(operation,in1(ii),in2);
      out(ii).color = col;
   end
else
   % both are arrays. Check sizes
   if length(s1) ~= length(s2) | s1 ~= s2
      error('Tensor sizes do not match.')
   end

   col1 = in1(1).color;
   col2 = in2(1).color;
   if isempty(col1)
      col = col2;
   elseif ~isempty(col2) & ~strcmp(col1.space,col2.space)
      warning('Color spaces do not match: removing color space information.')
      col = '';
   else
      col = col1;
   end
   for ii=1:prod(s1)
      out(ii) = compute2(operation,in1(ii),in2(ii));
      out(ii).color = col;
   end
end
