%NORM   Computes the (Eucledian) norm of a tensor image.
%   NORM(V,P) = sum(abs(a).^p)^(1/p)
%   NORM(V)   = norm(v,2) default P=2 eucledian

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Bernd Rieger, November 2000.
% Nov 2002, added norm for tensor images, being the Froebius norm
% 6 March 2008: Huh? Did this code ever work??? Added IMARFUN calls.

function out = norm(a,p)
if nargin == 1
   p = 2;
elseif ~isnumeric(p) | prod(size(p))~=1
   error('Exponent must be a scalar.');
end
if ~istensor(a)
   error('Input image not dip_image tensor.')
end
nd = sum(imarsize(a)>1);

if nd==0; %vector dimension
  out = abs(a);
else
   if isinf(p)
      if p>0 % p==Inf
         out = imarfun('immax',abs(a));
      else   % p==-Inf
         out = imarfun('immin',abs(a));
      end
   elseif p==1
      out = imarfun('imsum',abs(a));
   else
      out = imarfun('imsum',abs(a).^p).^(1/p);
   end
end
