%ISA   True if object is of given class.
%   ISA(B,'dip_image') returns true if the object is a scalar image.
%
%   ISA(B,'dip_image_array') returns true if the object is an image array.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, June 1999.
% 25 July 2002: Test for type of TYPE to avoid weird error messages if
%               this function is called wrongly.

function out = isa(in,type)
if ~ischar(type)
   error('Unknown command option.')
end
if isscalar(in)
   out = strcmp('dip_image',type);
else
   out = strcmp('dip_image_array',type);
end
