%FLOOR   Round towards minus infinity.
%   FLOOR(B) rounds the pixel values of B towards the nearest integers
%   towards minus infinity.
%   The returned image is of type 'sint32' if B is any float type. The
%   function fails on complex types and does nothing on integer types.
%   Note that clipping occurs if the result doesn't fit in a value of
%   type 'sint32'.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, June 2000.
% 10 March 2008: Fixed bug. COMPUTE1 has a new PHYSDIMS input parameter.

function out = floor(in)
if ~isscalar(in), error('Parameter 1 is an array of images.'); end
if strcmp(in.dip_type(2:end),'complex')
   error('Cannot di_create an integer value from a complex value.')
elseif strcmp(in.dip_type(2:end),'float')
   out = compute1('floor',in.data,in.dims,'sint32',in.physDims);
else % do nothing!
   out = in;
end
