%EXP   Exponential.
%  EXP(B) is the exponential of the pixels of B, e to the B.
%  For complex Z=A+i*B, EXP(Z) = EXP(A)*(COS(B)+i*SIN(B)).

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% September 2000: Added complex output.
% February 2008: Adding pixel dimensions and units to dip_image. (BR)
% 11 March 2008: Forcing double output again.

function out = exp(in)
try
   [in,dims,out_type,out_phys] = do1input(in);
   if isreal(in)
      out_type = 'dfloat';
   else
      out_type = 'dcomplex';
   end
   out = compute1('exp',in,dims,out_type,out_phys);
catch
   error(di_firsterr)
end
