%ASIN   Inverse sine.
%  ASIN(B) is the arcsine of the pixels of B.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, December 2001.
% July 2006, copy acos: complex output (BR,FF)
% 10 March 2008: Fixed bug. COMPUTE1 has a new PHYSDIMS input parameter.

function out = asin(in)
try
   [in,dims,out_type,out_phys]=do1input(in);
   if any(in(:)>1) | any(in(:)<-1)
      out_type = 'dcomplex';
   end
   out = compute1('asin',in,dims,out_type,out_phys);
catch
   error(di_firsterr)
end

