%ABS   The absolute of the pixel values.
%   ABS(B) computes the magnitude of each pixel in B.

% (C) Copyright 1999-2009               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
% February 2008:    Adding pixel dimensions and units to dip_image. (BR)
% 7 April 2009:     abs(sint) = uint, not single!

function out = abs(in)
try
   [in,arrayop] = do1arrayinput(in);
catch
   error(di_firsterr)
end
if arrayop
   try
      out = compute1array('abs',in);
   catch
      error(di_firsterr)
   end
else
   if ~isscalar(in), error('Parameter 1 is an array of images.'); end
      % That is because ARRAYOP is only true if IN is a tensor image.
   if strcmp(in.dip_type,'bin') | strncmp(in.dip_type,'uint',4)
      % Do nothing for binary or unsigned images.
      out = in;
   else
      try
         [out,dims,out_type,out_phys] = do1input(in);
         out_type = in.dip_type;
         if strcmp(out_type,'scomplex'), out_type = 'sfloat'; end
         if strcmp(out_type,'dcomplex'), out_type = 'dfloat'; end
         if strncmp(in.dip_type,'sint',4), out_type(1) = 'u'; end
         out = compute1('abs',out,dims,out_type,out_phys);
      catch
         error(di_firsterr)
      end
   end
end
