/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ColorProcessor
extends ImageProcessor {
    protected int[] pixels;
    protected int[] snapshotPixels = null;
    private int bgColor = -1;
    private int min = 0;
    private int max = 255;
    public final int RGB_NOISE = 0;
    public final int RGB_MEDIAN = 1;
    public final int RGB_FIND_EDGES = 2;
    public final int RGB_ERODE = 3;
    public final int RGB_DILATE = 4;
    public final int RGB_THRESHOLD = 5;

    public ColorProcessor(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
    }

    public ColorProcessor(int n, int n2) {
        this(n, n2, new int[n * n2]);
    }

    public ColorProcessor(int n, int n2, int[] nArray) {
        if (nArray != null && n * n2 != nArray.length) {
            throw new IllegalArgumentException("(width*height) != pixels.length");
        }
        this.width = n;
        this.height = n2;
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
        this.pixels = nArray;
    }

    void createColorModel() {
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public Image createImage() {
        if (this.source == null || IJ.isMacintosh() && !IJ.isJava2()) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    public ImageProcessor createProcessor(int n, int n2) {
        int[] nArray = new int[n * n2];
        int n3 = 0;
        while (n3 < n * n2) {
            nArray[n3] = -1;
            ++n3;
        }
        return new ColorProcessor(n, n2, nArray);
    }

    public Color getColor(int n, int n2) {
        int n3 = this.pixels[n2 * this.width + n];
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        return new Color(n4, n5, n6);
    }

    public void setColor(Color color) {
        this.fgColor = color.getRGB();
        this.drawingColor = color;
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        this.setMinAndMax(d, d2, 7);
    }

    public void setMinAndMax(double d, double d2, int n) {
        if (d2 < d) {
            return;
        }
        this.min = (int)d;
        this.max = (int)d2;
        int[] nArray = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3 = n2 - this.min;
            if ((n3 = (int)(256.0 * (double)n3 / (d2 - d))) < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            nArray[n2] = n3;
            ++n2;
        }
        this.reset();
        if (n == 7) {
            this.applyTable(nArray);
        } else {
            this.applyTable(nArray, n);
        }
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new int[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        this.newSnapshot = true;
    }

    public void reset(int[] nArray) {
        if (nArray == null || this.snapshotPixels == null || nArray.length != this.roiWidth * this.roiHeight) {
            return;
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] != -16777216) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void fill(int[] nArray) {
        if (nArray == null) {
            this.fill();
            return;
        }
        if (nArray.length < this.roiWidth * this.roiHeight) {
            throw new IllegalArgumentException();
        }
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    this.pixels[n3] = this.fgColor;
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot) {
            return this.snapshotPixels;
        }
        int[] nArray = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, nArray, 0, this.width * this.height);
        return nArray;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n];
        }
        return 0;
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[3];
        }
        int n3 = this.getPixel(n, n2);
        nArray[0] = (n3 & 0xFF0000) >> 16;
        nArray[1] = (n3 & 0xFF00) >> 8;
        nArray[2] = n3 & 0xFF;
        return nArray;
    }

    public void putPixel(int n, int n2, int[] nArray) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        this.putPixel(n, n2, -16777216 + (n3 << 16) + (n4 << 8) + n5);
    }

    public double getInterpolatedPixel(double d, double d2) {
        int n = (int)(d + 0.5);
        int n2 = (int)(d2 + 0.5);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        return this.getPixelValue(n, n2);
    }

    public void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = n3 | 0xFF000000;
        }
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (d > 255.0) {
                d = 255.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            int n3 = (int)(d + 0.5);
            this.pixels[n2 * this.width + n] = -16777216 + (n3 << 16) + (n3 << 8) + n3;
        }
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = this.pixels[n2 * this.width + n];
            int n4 = (n3 & 0xFF0000) >> 16;
            int n5 = (n3 & 0xFF00) >> 8;
            int n6 = n3 & 0xFF;
            return (float)((double)n4 * 0.299 + (double)n5 * 0.587 + (double)n6 * 0.114);
        }
        return 0.0f;
    }

    public void drawPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public void setPixels(Object object) {
        this.pixels = (int[])object;
        this.resetPixels(object);
        this.snapshotPixels = null;
    }

    public void getHSB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        float[] fArray = new float[3];
        int n = 0;
        while (n < this.width * this.height) {
            int n2 = this.pixels[n];
            int n3 = (n2 & 0xFF0000) >> 16;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = n2 & 0xFF;
            fArray = Color.RGBtoHSB(n3, n4, n5, fArray);
            byArray[n] = (byte)((double)fArray[0] * 255.0);
            byArray2[n] = (byte)((double)fArray[1] * 255.0);
            byArray3[n] = (byte)((double)fArray[2] * 255.0);
            ++n;
        }
    }

    public void getRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < this.width * this.height) {
            int n2 = this.pixels[n];
            int n3 = (n2 & 0xFF0000) >> 16;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = n2 & 0xFF;
            byArray[n] = (byte)n3;
            byArray2[n] = (byte)n4;
            byArray3[n] = (byte)n5;
            ++n;
        }
    }

    public void setRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < this.width * this.height) {
            this.pixels[n] = 0xFF000000 | (byArray[n] & 0xFF) << 16 | (byArray2[n] & 0xFF) << 8 | byArray3[n] & 0xFF;
            ++n;
        }
    }

    public void setHSB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        while (n < this.width * this.height) {
            float f = (float)((double)(byArray[n] & 0xFF) / 255.0);
            float f2 = (float)((double)(byArray2[n] & 0xFF) / 255.0);
            float f3 = (float)((double)(byArray3[n] & 0xFF) / 255.0);
            this.pixels[n] = Color.HSBtoRGB(f, f2, f3);
            ++n;
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        if (!(imageProcessor instanceof ColorProcessor | imageProcessor instanceof ByteProcessor)) {
            throw new IllegalArgumentException("8-bit or RGB image required");
        }
        new ColorBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                int n4 = this.pixels[n2];
                int n5 = nArray[(n4 & 0xFF0000) >> 16];
                int n6 = nArray[(n4 & 0xFF00) >> 8];
                int n7 = nArray[n4 & 0xFF];
                this.pixels[n2] = -16777216 + (n5 << 16) + (n6 << 8) + n7;
                ++n2;
                ++n3;
            }
            ++n;
        }
        this.hideProgress();
    }

    public void applyTable(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.roiY;
        while (n5 < this.roiY + this.roiHeight) {
            int n6 = n5 * this.width + this.roiX;
            int n7 = this.roiX;
            while (n7 < this.roiX + this.roiWidth) {
                int n8 = this.pixels[n6];
                if (n == 4) {
                    n2 = nArray[(n8 & 0xFF0000) >> 16];
                    n3 = (n8 & 0xFF00) >> 8;
                    n4 = n8 & 0xFF;
                } else if (n == 2) {
                    n2 = (n8 & 0xFF0000) >> 16;
                    n3 = nArray[(n8 & 0xFF00) >> 8];
                    n4 = n8 & 0xFF;
                } else if (n == 1) {
                    n2 = (n8 & 0xFF0000) >> 16;
                    n3 = (n8 & 0xFF00) >> 8;
                    n4 = nArray[n8 & 0xFF];
                } else if ((n & 6) == 6) {
                    n2 = nArray[(n8 & 0xFF0000) >> 16];
                    n3 = nArray[(n8 & 0xFF00) >> 8];
                    n4 = n8 & 0xFF;
                } else if ((n & 5) == 5) {
                    n2 = nArray[(n8 & 0xFF0000) >> 16];
                    n3 = (n8 & 0xFF00) >> 8;
                    n4 = nArray[n8 & 0xFF];
                } else if ((n & 3) == 3) {
                    n2 = (n8 & 0xFF0000) >> 16;
                    n3 = nArray[(n8 & 0xFF00) >> 8];
                    n4 = nArray[n8 & 0xFF];
                }
                this.pixels[n6] = -16777216 + (n2 << 16) + (n3 << 8) + n4;
                ++n6;
                ++n7;
            }
            ++n5;
        }
        this.hideProgress();
    }

    public void fill() {
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                this.pixels[n2++] = this.fgColor;
                ++n3;
            }
            if (n % 20 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
        }
        this.hideProgress();
    }

    public void filterRGB(int n, double d) {
        this.showProgress(0.01);
        byte[] byArray = new byte[this.width * this.height];
        byte[] byArray2 = new byte[this.width * this.height];
        byte[] byArray3 = new byte[this.width * this.height];
        this.getRGB(byArray, byArray2, byArray3);
        Rectangle rectangle = new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
        byteProcessor.setRoi(rectangle);
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height, byArray2, null);
        byteProcessor2.setRoi(rectangle);
        ByteProcessor byteProcessor3 = new ByteProcessor(this.width, this.height, byArray3, null);
        byteProcessor3.setRoi(rectangle);
        this.showProgress(0.15);
        switch (n) {
            case 0: {
                byteProcessor.noise(d);
                this.showProgress(0.4);
                byteProcessor2.noise(d);
                this.showProgress(0.65);
                byteProcessor3.noise(d);
                this.showProgress(0.9);
                break;
            }
            case 1: {
                byteProcessor.medianFilter();
                this.showProgress(0.4);
                byteProcessor2.medianFilter();
                this.showProgress(0.65);
                byteProcessor3.medianFilter();
                this.showProgress(0.9);
                break;
            }
            case 2: {
                byteProcessor.findEdges();
                this.showProgress(0.4);
                byteProcessor2.findEdges();
                this.showProgress(0.65);
                byteProcessor3.findEdges();
                this.showProgress(0.9);
                break;
            }
            case 3: {
                byteProcessor.erode();
                this.showProgress(0.4);
                byteProcessor2.erode();
                this.showProgress(0.65);
                byteProcessor3.erode();
                this.showProgress(0.9);
                break;
            }
            case 4: {
                byteProcessor.dilate();
                this.showProgress(0.4);
                byteProcessor2.dilate();
                this.showProgress(0.65);
                byteProcessor3.dilate();
                this.showProgress(0.9);
                break;
            }
            case 5: {
                byteProcessor.autoThreshold();
                this.showProgress(0.4);
                byteProcessor2.autoThreshold();
                this.showProgress(0.65);
                byteProcessor3.autoThreshold();
                this.showProgress(0.9);
            }
        }
        byArray = (byte[])byteProcessor.getPixels();
        byArray2 = (byte[])byteProcessor2.getPixels();
        byArray3 = (byte[])byteProcessor3.getPixels();
        this.setRGB(byArray, byArray2, byArray3);
        this.hideProgress();
    }

    public void noise(double d) {
        this.filterRGB(0, d);
    }

    public void medianFilter() {
        this.filterRGB(1, 0.0);
    }

    public void findEdges() {
        this.filterRGB(2, 0.0);
    }

    public void erode() {
        this.filterRGB(3, 0.0);
    }

    public void dilate() {
        this.filterRGB(4, 0.0);
    }

    public void autoThreshold() {
        this.filterRGB(5, 0.0);
    }

    public void scale(double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        boolean bl = d < 1.0 || d2 < 1.0;
        double d5 = (double)this.width - 1.0;
        double d6 = (double)this.width - 1.001;
        double d7 = (double)this.height - 1.0;
        double d8 = (double)this.height - 1.001;
        int n5 = n2;
        while (n5 <= n) {
            double d9 = ((double)n5 - d4) / d2 + d4;
            int n6 = (int)d9;
            if (d9 < 0.0) {
                d9 = 0.0;
            }
            if (d9 >= d7) {
                d9 = d8;
            }
            int n7 = n5 * this.width + n4;
            int n8 = this.width * (int)d9;
            int n9 = n4;
            while (n9 <= n3) {
                double d10 = ((double)n9 - d3) / d + d3;
                int n10 = (int)d10;
                if (bl && (n10 < n4 || n10 > n3 || n6 < n2 || n6 > n)) {
                    this.pixels[n7++] = (byte)this.bgColor;
                } else if (this.interpolate) {
                    if (d10 < 0.0) {
                        d10 = 0.0;
                    }
                    if (d10 >= d5) {
                        d10 = d6;
                    }
                    this.pixels[n7++] = this.getInterpolatedPixel(d10, d9, nArray);
                } else {
                    this.pixels[n7++] = nArray[n8 + n10];
                }
                ++n9;
            }
            if (n5 % 20 == 0) {
                this.showProgress((double)(n5 - n2) / (double)this.height);
            }
            ++n5;
        }
        this.hideProgress();
    }

    public ImageProcessor crop() {
        int[] nArray = new int[this.roiWidth * this.roiHeight];
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = (n - this.roiY) * this.roiWidth;
            int n3 = n * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                nArray[n2++] = this.pixels[n3++];
                ++n4;
            }
            ++n;
        }
        return new ColorProcessor(this.roiWidth, this.roiHeight, nArray);
    }

    private final int getInterpolatedPixel(double d, double d2, int[] nArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = nArray[n3];
        int n5 = (n4 & 0xFF0000) >> 16;
        int n6 = (n4 & 0xFF00) >> 8;
        int n7 = n4 & 0xFF;
        int n8 = nArray[n3 + 1];
        int n9 = (n8 & 0xFF0000) >> 16;
        int n10 = (n8 & 0xFF00) >> 8;
        int n11 = n8 & 0xFF;
        int n12 = nArray[n3 + this.width + 1];
        int n13 = (n12 & 0xFF0000) >> 16;
        int n14 = (n12 & 0xFF00) >> 8;
        int n15 = n12 & 0xFF;
        int n16 = nArray[n3 + this.width];
        int n17 = (n16 & 0xFF0000) >> 16;
        int n18 = (n16 & 0xFF00) >> 8;
        int n19 = n16 & 0xFF;
        double d5 = (double)n17 + d3 * (double)(n13 - n17);
        double d6 = (double)n5 + d3 * (double)(n9 - n5);
        int n20 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        d5 = (double)n18 + d3 * (double)(n14 - n18);
        d6 = (double)n6 + d3 * (double)(n10 - n6);
        int n21 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        d5 = (double)n19 + d3 * (double)(n15 - n19);
        d6 = (double)n7 + d3 * (double)(n11 - n7);
        int n22 = (int)(d6 + d4 * (d5 - d6) + 0.5);
        return 0xFF000000 | (n20 & 0xFF) << 16 | (n21 & 0xFF) << 8 | n22 & 0xFF;
    }

    public ImageProcessor resize(int n, int n2) {
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        double d7 = (double)this.width - 1.0;
        double d8 = (double)this.width - 1.001;
        double d9 = (double)this.height - 1.0;
        double d10 = (double)this.height - 1.001;
        if (this.interpolate) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = (int[])imageProcessor.getPixels();
        int n3 = 0;
        while (n3 <= n2 - 1) {
            double d11 = ((double)n3 - d4) / d6 + d2;
            if (this.interpolate) {
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
            }
            int n4 = this.width * (int)d11;
            int n5 = n3 * n;
            int n6 = 0;
            while (n6 <= n - 1) {
                double d12 = ((double)n6 - d3) / d5 + d;
                if (this.interpolate) {
                    if (d12 < 0.0) {
                        d12 = 0.0;
                    }
                    if (d12 >= d7) {
                        d12 = d8;
                    }
                    nArray[n5++] = this.getInterpolatedPixel(d12, d11, this.pixels);
                } else {
                    nArray[n5++] = this.pixels[n4 + (int)d12];
                }
                ++n6;
            }
            if (n3 % 20 == 0) {
                this.showProgress((double)n3 / (double)n2);
            }
            ++n3;
        }
        this.hideProgress();
        return imageProcessor;
    }

    public void rotate(double d) {
        if (d % 360.0 == 0.0) {
            return;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        double d9 = this.width;
        double d10 = this.height;
        double d11 = (double)this.width - 1.0;
        double d12 = (double)this.width - 1.001;
        double d13 = (double)this.height - 1.0;
        double d14 = (double)this.height - 1.001;
        int n2 = this.roiY;
        while (n2 < this.roiY + this.roiHeight) {
            int n3 = n2 * this.width + this.roiX;
            double d15 = d7 - (double)n2 * d6 + d2;
            double d16 = d8 + (double)n2 * d5 + d3;
            int n4 = this.roiX;
            while (n4 <= n) {
                double d17 = (double)n4 * d5 + d15;
                double d18 = (double)n4 * d6 + d16;
                if (d17 >= -0.01 && d17 < d9 && d18 >= -0.01 && d18 < d10) {
                    if (this.interpolate) {
                        if (d17 < 0.0) {
                            d17 = 0.0;
                        }
                        if (d17 >= d11) {
                            d17 = d12;
                        }
                        if (d18 < 0.0) {
                            d18 = 0.0;
                        }
                        if (d18 >= d13) {
                            d18 = d14;
                        }
                        this.pixels[n3++] = this.getInterpolatedPixel(d17, d18, nArray);
                    } else {
                        int n5 = (int)(d17 + 0.5);
                        int n6 = (int)(d18 + 0.5);
                        if (n5 >= this.width) {
                            n5 = this.width - 1;
                        }
                        if (n6 >= this.height) {
                            n6 = this.height - 1;
                        }
                        this.pixels[n3++] = nArray[this.width * n6 + n5];
                    }
                } else {
                    this.pixels[n3++] = this.bgColor;
                }
                ++n4;
            }
            if (n2 % 30 == 0) {
                this.showProgress((double)(n2 - this.roiY) / (double)this.roiHeight);
            }
            ++n2;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int n = 0;
        while (n < this.roiHeight / 2) {
            int n2 = (this.roiY + n) * this.width + this.roiX;
            int n3 = (this.roiY + this.roiHeight - 1 - n) * this.width + this.roiX;
            int n4 = 0;
            while (n4 < this.roiWidth) {
                int n5 = this.pixels[n2];
                this.pixels[n2++] = this.pixels[n3];
                this.pixels[n3++] = n5;
                ++n4;
            }
            ++n;
        }
        this.newSnapshot = false;
    }

    public void convolve3x3(int[] nArray) {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = nArray[5];
        int n8 = nArray[6];
        int n9 = nArray[7];
        int n10 = nArray[8];
        int n11 = 0;
        int n12 = 0;
        while (n12 < nArray.length) {
            n11 += nArray[n12];
            ++n12;
        }
        if (n11 == 0) {
            n11 = 1;
        }
        if ((n = this.roiHeight / 25) < 1) {
            n = 1;
        }
        int[] nArray2 = (int[])this.getPixelsCopy();
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = this.width;
        int n17 = this.yMin;
        while (n17 <= this.yMax) {
            int n18 = this.xMin + n17 * this.width;
            int n19 = 0;
            int n20 = nArray2[n18 - n16 - 1];
            int n21 = nArray2[n18 - n16];
            int n22 = 0;
            int n23 = nArray2[n18 - 1];
            int n24 = nArray2[n18];
            int n25 = 0;
            int n26 = nArray2[n18 + n16 - 1];
            int n27 = nArray2[n18 + n16];
            int n28 = this.xMin;
            while (n28 <= this.xMax) {
                n19 = n20;
                n20 = n21;
                n21 = nArray2[n18 - n16 + 1];
                n22 = n23;
                n23 = n24;
                n24 = nArray2[n18 + 1];
                n25 = n26;
                n26 = n27;
                n27 = nArray2[n18 + n16 + 1];
                n13 = n2 * ((n19 & 0xFF0000) >> 16) + n3 * ((n20 & 0xFF0000) >> 16) + n4 * ((n21 & 0xFF0000) >> 16) + n5 * ((n22 & 0xFF0000) >> 16) + n6 * ((n23 & 0xFF0000) >> 16) + n7 * ((n24 & 0xFF0000) >> 16) + n8 * ((n25 & 0xFF0000) >> 16) + n9 * ((n26 & 0xFF0000) >> 16) + n10 * ((n27 & 0xFF0000) >> 16);
                if ((n13 /= n11) > 255) {
                    n13 = 255;
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                n14 = n2 * ((n19 & 0xFF00) >> 8) + n3 * ((n20 & 0xFF00) >> 8) + n4 * ((n21 & 0xFF00) >> 8) + n5 * ((n22 & 0xFF00) >> 8) + n6 * ((n23 & 0xFF00) >> 8) + n7 * ((n24 & 0xFF00) >> 8) + n8 * ((n25 & 0xFF00) >> 8) + n9 * ((n26 & 0xFF00) >> 8) + n10 * ((n27 & 0xFF00) >> 8);
                if ((n14 /= n11) > 255) {
                    n14 = 255;
                } else if (n14 < 0) {
                    n14 = 0;
                }
                n15 = n2 * (n19 & 0xFF) + n3 * (n20 & 0xFF) + n4 * (n21 & 0xFF) + n5 * (n22 & 0xFF) + n6 * (n23 & 0xFF) + n7 * (n24 & 0xFF) + n8 * (n25 & 0xFF) + n9 * (n26 & 0xFF) + n10 * (n27 & 0xFF);
                if ((n15 /= n11) > 255) {
                    n15 = 255;
                }
                if (n15 < 0) {
                    n15 = 0;
                }
                this.pixels[n18++] = 0xFF000000 | n13 << 16 & 0xFF0000 | n14 << 8 & 0xFF00 | n15 & 0xFF;
                ++n28;
            }
            if (n17 % n == 0) {
                this.showProgress((double)(n17 - this.roiY) / (double)this.roiHeight);
            }
            ++n17;
        }
        this.hideProgress();
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        int[] nArray = (int[])this.getPixelsCopy();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.width;
        int n7 = this.yMin;
        while (n7 <= this.yMax) {
            int n8 = this.xMin + n7 * this.width;
            int n9 = 0;
            int n10 = nArray[n8 - n6 - 1];
            int n11 = nArray[n8 - n6];
            int n12 = 0;
            int n13 = nArray[n8 - 1];
            int n14 = nArray[n8];
            int n15 = 0;
            int n16 = nArray[n8 + n6 - 1];
            int n17 = nArray[n8 + n6];
            int n18 = this.xMin;
            while (n18 <= this.xMax) {
                n9 = n10;
                n10 = n11;
                n11 = nArray[n8 - n6 + 1];
                n12 = n13;
                n13 = n14;
                n14 = nArray[n8 + 1];
                n15 = n16;
                n16 = n17;
                n17 = nArray[n8 + n6 + 1];
                n3 = (n9 & 0xFF0000) + (n10 & 0xFF0000) + (n11 & 0xFF0000) + (n12 & 0xFF0000) + (n13 & 0xFF0000) + (n14 & 0xFF0000) + (n15 & 0xFF0000) + (n16 & 0xFF0000) + (n17 & 0xFF0000);
                n4 = (n9 & 0xFF00) + (n10 & 0xFF00) + (n11 & 0xFF00) + (n12 & 0xFF00) + (n13 & 0xFF00) + (n14 & 0xFF00) + (n15 & 0xFF00) + (n16 & 0xFF00) + (n17 & 0xFF00);
                n5 = (n9 & 0xFF) + (n10 & 0xFF) + (n11 & 0xFF) + (n12 & 0xFF) + (n13 & 0xFF) + (n14 & 0xFF) + (n15 & 0xFF) + (n16 & 0xFF) + (n17 & 0xFF);
                this.pixels[n8++] = 0xFF000000 | n3 / 9 & 0xFF0000 | n4 / 9 & 0xFF00 | n5 / 9;
                ++n18;
            }
            if (n7 % n2 == 0) {
                this.showProgress((double)(n7 - this.roiY) / (double)this.roiHeight);
            }
            ++n7;
        }
        this.hideProgress();
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[256];
        int n = this.roiY;
        while (n < this.roiY + this.roiHeight) {
            int n2 = n * this.width + this.roiX;
            int n3 = this.roiX;
            while (n3 < this.roiX + this.roiWidth) {
                int n4;
                int n5 = this.pixels[n2++];
                int n6 = (n5 & 0xFF0000) >> 16;
                int n7 = (n5 & 0xFF00) >> 8;
                int n8 = n5 & 0xFF;
                int n9 = n4 = (int)((double)n6 * 0.299 + (double)n7 * 0.587 + (double)n8 * 0.114 + 0.5);
                nArray[n9] = nArray[n9] + 1;
                ++n3;
            }
            if (n % 20 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
        }
        this.hideProgress();
        return nArray;
    }

    public int[] getHistogram(int[] nArray) {
        int[] nArray2 = new int[256];
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            int n5 = this.roiX;
            while (n5 < this.roiX + this.roiWidth) {
                if (nArray[n4++] == -16777216) {
                    int n6;
                    int n7 = this.pixels[n3];
                    int n8 = (n7 & 0xFF0000) >> 16;
                    int n9 = (n7 & 0xFF00) >> 8;
                    int n10 = n7 & 0xFF;
                    int n11 = n6 = (int)((double)n8 * 0.299 + (double)n9 * 0.587 + (double)n10 * 0.114 + 0.5);
                    nArray2[n11] = nArray2[n11] + 1;
                }
                ++n3;
                ++n5;
            }
            if (n % 20 == 0) {
                this.showProgress((double)(n - this.roiY) / (double)this.roiHeight);
            }
            ++n;
            ++n2;
        }
        this.hideProgress();
        return nArray2;
    }

    public void convolve(float[] fArray, int n, int n2) {
        int n3 = this.width * this.height;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        this.getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(this.width, this.height, byArray3, null);
        ImageProcessor imageProcessor = byteProcessor.convertToFloat();
        Rectangle rectangle = this.getRoi();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor2 = imageProcessor.convertToByte(false);
        imageProcessor = byteProcessor2.convertToFloat();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor3 = imageProcessor.convertToByte(false);
        imageProcessor = byteProcessor3.convertToFloat();
        imageProcessor.setRoi(rectangle);
        imageProcessor.convolve(fArray, n, n2);
        ImageProcessor imageProcessor4 = imageProcessor.convertToByte(false);
        this.setRGB((byte[])imageProcessor2.getPixels(), (byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels());
    }

    public boolean isInvertedLut() {
        return false;
    }

    public int getBestIndex(Color color) {
        return 0;
    }

    public void invertLut() {
    }

    public void threshold(int n) {
    }
}

