/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter,
Measurements {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_SIZE_DISTRIBUTION = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    public static final int RECORD_STARTS = 128;
    public static final int DISPLAY_SUMMARY = 256;
    static final String OPTIONS = "ap.options";
    static final String BINS = "ap.bins";
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    private static int staticMinSize = 1;
    private static int staticMaxSize = 999999;
    private static int staticOptions = Prefs.getInt("ap.options", 64);
    private static int staticBins = Prefs.getInt("ap.bins", 20);
    private static String[] showStrings = new String[]{"Nothing", "Outlines", "Filled", "Ellipses"};
    protected static final int NOTHING = 0;
    protected static final int OUTLINES = 1;
    protected static final int FILLED = 2;
    protected static final int ELLIPSES = 3;
    protected static int showChoice;
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    protected int slice;
    protected boolean processStack;
    protected boolean showResults;
    protected boolean excludeEdgeParticles;
    protected boolean showSizeDistribution;
    protected boolean resetCounter;
    protected boolean showProgress;
    protected boolean recordStarts;
    protected boolean displaySummary;
    private double level1;
    private double level2;
    private int minSize;
    private int maxSize;
    private int sizeBins;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private double fillColor;
    private boolean thresholdingLUT;
    private ImageProcessor ip2;
    private int width;
    private int height;
    private boolean canceled;
    private ImageStack outlines;
    private IndexColorModel customLut;
    private int particleCount;
    private int totalCount;
    private TextWindow tw;
    private Wand wand;
    private int imageType;
    private int xStartC;
    private int yStartC;
    private boolean roiNeedsImage;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    static /* synthetic */ Class class$ij$plugin$filter$ParticleAnalyzer;

    public ParticleAnalyzer(int n, int n2, ResultsTable resultsTable, double d, double d2) {
        this.options = n;
        this.measurements = n2;
        this.rt = resultsTable;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = (int)d;
        this.maxSize = (int)d2;
        this.sizeBins = staticBins;
        this.slice = 1;
    }

    public ParticleAnalyzer() {
        this.slice = 1;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$ParticleAnalyzer == null ? (class$ij$plugin$filter$ParticleAnalyzer = ParticleAnalyzer.class$("ij.plugin.filter.ParticleAnalyzer")) : class$ij$plugin$filter$ParticleAnalyzer);
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        if (!this.showDialog()) {
            return 4096;
        }
        int n = IJ.setupDialog(imagePlus, 397);
        this.processStack = (n & 0x20) != 0;
        this.slice = 0;
        imagePlus.startTiming();
        return n;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.imp.getStackSize() > 1 && this.processStack) {
            this.imp.setSlice(this.slice);
        }
        this.analyze(this.imp, imageProcessor);
        if (this.slice == this.imp.getStackSize()) {
            this.imp.updateAndDraw();
        }
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Analyze Particles");
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        this.sizeBins = staticBins;
        this.options = staticOptions;
        genericDialog.addNumericField("Minimum Size (pixels):", this.minSize, 0);
        genericDialog.addNumericField("Maximum Size (pixels):", this.maxSize, 0);
        genericDialog.addNumericField("Bins (2-256):", this.sizeBins, 0);
        genericDialog.addChoice("Show:", showStrings, showStrings[showChoice]);
        genericDialog.addCheckbox("Display Results", (this.options & 1) != 0);
        genericDialog.addCheckbox("Exclude Edge Particles", (this.options & 8) != 0);
        genericDialog.addCheckbox("Size Distribution", (this.options & 0x10) != 0);
        genericDialog.addCheckbox("Clear Results Table", (this.options & 0x40) != 0);
        genericDialog.addCheckbox("Record Starts", (this.options & 0x80) != 0);
        genericDialog.addCheckbox("Summarize", (this.options & 0x100) != 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.minSize = (int)genericDialog.getNextNumber();
        this.maxSize = (int)genericDialog.getNextNumber();
        this.sizeBins = (int)genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            IJ.error("Minimum Size, Maximum Size or Bins invalid.");
            this.canceled = true;
            return false;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        staticBins = this.sizeBins;
        showChoice = genericDialog.getNextChoiceIndex();
        this.options = genericDialog.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x80) : (this.options &= 0xFFFFFF7F);
        this.options = genericDialog.getNextBoolean() ? (this.options |= 0x100) : (this.options &= 0xFFFFFEFF);
        staticOptions = this.options;
        this.options |= 0x20;
        return true;
    }

    public boolean analyze(ImagePlus imagePlus) {
        return this.analyze(imagePlus, imagePlus.getProcessor());
    }

    public boolean analyze(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        ImageWindow imageWindow;
        this.showResults = (this.options & 1) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.showSizeDistribution = (this.options & 0x10) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        this.recordStarts = (this.options & 0x80) != 0;
        boolean bl = this.displaySummary = (this.options & 0x100) != 0;
        if ((this.options & 4) != 0) {
            showChoice = 1;
        }
        imageProcessor.snapshot();
        imageProcessor.setProgressBar(null);
        if (!this.setThresholdLevels(imagePlus, imageProcessor)) {
            return false;
        }
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        if (showChoice != 0) {
            if (this.slice == 1) {
                this.outlines = new ImageStack(this.width, this.height);
            }
            this.ip2 = new ByteProcessor(this.width, this.height);
            if (showChoice == 1) {
                if (this.customLut == null) {
                    this.makeCustomLut();
                }
                this.ip2.setColorModel(this.customLut);
                this.ip2.setFont(new Font("SansSerif", 0, 9));
            }
            this.outlines.addSlice(null, this.ip2);
            this.ip2.setColor(Color.white);
            this.ip2.fill();
            this.ip2.setColor(Color.black);
        }
        this.calibration = imagePlus.getCalibration();
        byte[] byArray = null;
        if (imageProcessor instanceof ByteProcessor) {
            byArray = (byte[])imageProcessor.getPixels();
        }
        Rectangle rectangle = imageProcessor.getRoi();
        int[] nArray = imageProcessor.getMask();
        if (rectangle.width < this.width || rectangle.height < this.height || nArray != null) {
            this.eraseOutsideRoi(imageProcessor, rectangle, nArray);
        }
        this.minX = rectangle.x;
        this.maxX = rectangle.x + rectangle.width;
        this.minY = rectangle.y;
        this.maxY = rectangle.y + rectangle.height;
        int n = rectangle.height / 20;
        if (n < 1) {
            n = 1;
        }
        boolean bl2 = false;
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imagePlus);
        } else {
            this.analyzer = new Analyzer(imagePlus, this.measurements, this.rt);
        }
        if (this.resetCounter && this.slice == 1 && !Analyzer.resetCounter()) {
            return false;
        }
        if (this.recordStarts) {
            this.xStartC = this.getColumnID("XStart");
            this.yStartC = this.getColumnID("YStart");
        }
        if ((imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = true;
        }
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        if (showChoice == 3) {
            this.measurements |= 0x800;
        }
        this.roiNeedsImage = (this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0 || (this.measurements & 0x4000) != 0;
        this.particleCount = 0;
        this.wand = new Wand(imageProcessor);
        int n2 = rectangle.y;
        while (n2 < rectangle.y + rectangle.height) {
            int n3 = n2 * this.width;
            int n4 = rectangle.x;
            while (n4 < rectangle.x + rectangle.width) {
                double d = byArray != null ? (double)(byArray[n3 + n4] & 0xFF) : (double)imageProcessor.getPixelValue(n4, n2);
                if (d >= this.level1 && d <= this.level2) {
                    this.analyzeParticle(n4, n2, imagePlus, imageProcessor);
                }
                ++n4;
            }
            if (this.showProgress && n2 % n == 0) {
                IJ.showProgress((double)(n2 - rectangle.y) / (double)rectangle.height);
            }
            if (imageWindow != null) {
                boolean bl3 = this.canceled = !imageWindow.running;
            }
            if (this.canceled) {
                Macro.abort();
                break;
            }
            ++n2;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        imagePlus.killRoi();
        imageProcessor.resetRoi();
        imageProcessor.reset();
        if (this.processStack && IJ.getInstance() != null) {
            String string = this.slice + "\t" + this.particleCount;
            if (this.tw == null) {
                String string2 = "Counts of " + imagePlus.getShortTitle();
                String string3 = "Slice\tCount";
                this.tw = new TextWindow(string2, string3, string, 180, 360);
            } else {
                this.tw.append(string);
            }
        }
        this.totalCount += this.particleCount;
        if (!this.canceled) {
            this.showResults();
        }
        return true;
    }

    void eraseOutsideRoi(ImageProcessor imageProcessor, Rectangle rectangle, int[] nArray) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        imageProcessor.setValue(this.fillColor);
        if (nArray != null) {
            int[] nArray2 = new int[nArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray2[n3] = nArray[n3] == -16777216 ? -1 : -16777216;
                ++n3;
            }
            imageProcessor.setMask(nArray2);
            imageProcessor.fill();
            imageProcessor.reset(nArray2);
        }
        imageProcessor.setRoi(0, 0, rectangle.x, n2);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, 0, rectangle.width, rectangle.y);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n2 - (rectangle.y + rectangle.height));
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x + rectangle.width, 0, n - (rectangle.x + rectangle.width), n2);
        imageProcessor.fill();
        imageProcessor.resetRoi();
    }

    boolean setThresholdLevels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        boolean bl = imagePlus.isInvertedLut();
        boolean bl2 = imageProcessor instanceof ByteProcessor;
        this.imageType = imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 0);
        if (d == -808080.0) {
            ImageStatistics imageStatistics = imagePlus.getStatistics();
            if (this.imageType != 0 || imageStatistics.histogram[0] + imageStatistics.histogram[255] != imageStatistics.pixelCount) {
                IJ.showMessage("Particle Analyzer", "A thresholded image or an 8-bit binary image is\nrequired. Refer to Image->Adjust->Threshold\nor to Process->Binary->Threshold.");
                this.canceled = true;
                return false;
            }
            if (bl) {
                this.level1 = 255.0;
                this.level2 = 255.0;
                this.fillColor = 64.0;
            } else {
                this.level1 = 0.0;
                this.level2 = 0.0;
                this.fillColor = 192.0;
            }
        } else {
            this.level1 = d;
            this.level2 = d2;
            if (this.imageType == 0) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 255.0) {
                    this.fillColor = 255.0;
                }
            } else if (this.imageType == 1) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 65535.0) {
                    this.fillColor = 65535.0;
                }
            } else if (this.imageType == 2) {
                this.fillColor = -3.4028234663852886E38;
            } else {
                return false;
            }
        }
        return true;
    }

    void analyzeParticle(int n, int n2, ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.wand.autoOutline(n, n2, this.level1, this.level2);
        if (this.wand.npoints == 0) {
            IJ.log("wand error: " + n + " " + n2);
            return;
        }
        PolygonRoi polygonRoi = new PolygonRoi(this.wand.xpoints, this.wand.ypoints, this.wand.npoints, 4);
        Rectangle rectangle = polygonRoi.getBoundingRect();
        if (rectangle.width > 1 && rectangle.height > 1) {
            imageProcessor.setMask(((Roi)polygonRoi).getMask());
        }
        imageProcessor.setRoi(rectangle);
        imageProcessor.setValue(this.fillColor);
        ImageStatistics imageStatistics = this.getStatistics(imageProcessor, this.measurements, this.calibration);
        boolean bl = true;
        if (this.excludeEdgeParticles && (rectangle.x == this.minX || rectangle.y == this.minY || rectangle.x + rectangle.width == this.maxX || rectangle.y + rectangle.height == this.maxY)) {
            bl = false;
        }
        int[] nArray = imageProcessor.getMask();
        if (imageStatistics.pixelCount >= this.minSize && imageStatistics.pixelCount <= this.maxSize && bl) {
            ++this.particleCount;
            if (this.roiNeedsImage) {
                polygonRoi.setImage(imagePlus);
            }
            this.saveResults(imageStatistics, polygonRoi);
            if (showChoice != 0) {
                this.drawParticle(this.ip2, polygonRoi, imageStatistics, nArray);
            }
        }
        imageProcessor.fill(nArray);
    }

    ImageStatistics getStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        switch (this.imageType) {
            case 0: {
                return new ByteStatistics(imageProcessor, n, calibration);
            }
            case 1: {
                return new ShortStatistics(imageProcessor, n, calibration);
            }
            case 2: {
                return new FloatStatistics(imageProcessor, n, calibration);
            }
        }
        return null;
    }

    protected void saveResults(ImageStatistics imageStatistics, Roi roi) {
        this.analyzer.saveResults(imageStatistics, roi);
        if (this.recordStarts) {
            int n = ((PolygonRoi)roi).getNCoordinates();
            Rectangle rectangle = roi.getBoundingRect();
            int n2 = rectangle.x + ((PolygonRoi)roi).getXCoordinates()[n - 1];
            int n3 = rectangle.y + ((PolygonRoi)roi).getYCoordinates()[n - 1];
            this.rt.addValue(this.xStartC, (double)n2);
            this.rt.addValue(this.yStartC, (double)n3);
        }
        if (this.showResults) {
            this.analyzer.displayResults();
        }
    }

    protected void drawParticle(ImageProcessor imageProcessor, Roi roi, ImageStatistics imageStatistics, int[] nArray) {
        switch (showChoice) {
            case 2: {
                this.drawFilledParticle(imageProcessor, roi, nArray);
                break;
            }
            case 1: {
                this.drawOutline(imageProcessor, roi, this.rt.getCounter());
                break;
            }
            case 3: {
                this.drawEllipse(imageProcessor, imageStatistics, this.rt.getCounter());
                break;
            }
        }
    }

    void drawFilledParticle(ImageProcessor imageProcessor, Roi roi, int[] nArray) {
        imageProcessor.setRoi(roi.getBoundingRect());
        imageProcessor.fill(nArray);
    }

    void drawOutline(ImageProcessor imageProcessor, Roi roi, int n) {
        Rectangle rectangle = roi.getBoundingRect();
        int n2 = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        imageProcessor.setValue(0.0);
        imageProcessor.moveTo(n3 + nArray[0], n4 + nArray2[0]);
        int n5 = 1;
        while (n5 < n2) {
            imageProcessor.lineTo(n3 + nArray[n5], n4 + nArray2[n5]);
            ++n5;
        }
        imageProcessor.lineTo(n3 + nArray[0], n4 + nArray2[0]);
        String string = IJ.d2s(n, 0);
        imageProcessor.moveTo(rectangle.x + rectangle.width / 2 - imageProcessor.getStringWidth(string) / 2, rectangle.y + rectangle.height / 2 + 4);
        imageProcessor.setValue(1.0);
        imageProcessor.drawString(string);
    }

    void drawEllipse(ImageProcessor imageProcessor, ImageStatistics imageStatistics, int n) {
        imageStatistics.drawEllipse(imageProcessor);
    }

    void showResults() {
        Object object;
        boolean bl;
        int n = this.rt.getCounter();
        if (n == 0) {
            return;
        }
        boolean bl2 = bl = !this.processStack || this.slice == this.imp.getStackSize();
        if (this.displaySummary && bl && this.rt == Analyzer.getResultsTable() && this.imp != null) {
            this.showSummary();
        }
        if (this.showSizeDistribution && bl && (object = this.rt.getColumn(0)) != null) {
            FloatProcessor floatProcessor = new FloatProcessor(n, 1, (float[])object, null);
            new HistogramWindow("Particle Size Distribution", new ImagePlus("", floatProcessor), this.sizeBins);
        }
        if (this.outlines != null && bl) {
            object = this.imp != null ? this.imp.getShortTitle() : "Outlines";
            new ImagePlus("Drawing of " + (String)object, this.outlines).show();
        }
    }

    void showSummary() {
        String string = "";
        string = string + "Threshold: ";
        string = (double)((int)this.level1) == this.level1 && (double)((int)this.level2) == this.level2 ? string + (int)this.level1 + "-" + (int)this.level2 + "\n" : string + IJ.d2s(this.level1, 2) + "-" + IJ.d2s(this.level2, 2) + "\n";
        string = string + "Count: " + this.totalCount + "\n";
        float[] fArray = this.rt.getColumn(0);
        if (fArray != null) {
            if (fArray.length != this.totalCount) {
                return;
            }
            double d = 0.0;
            int n = 0;
            while (n < this.totalCount) {
                d += (double)fArray[n];
                ++n;
            }
            int n2 = Analyzer.getPrecision();
            Calibration calibration = this.imp.getCalibration();
            String string2 = calibration.getUnit();
            string = string + "Total Area: " + IJ.d2s(d, n2) + " " + string2 + "^2\n";
            string = string + "Average Size: " + IJ.d2s(d / (double)this.totalCount, n2) + " " + string2 + "^2\n";
            double d2 = (double)this.imp.getWidth() * calibration.pixelWidth * (double)this.imp.getHeight() * calibration.pixelHeight * (double)this.imp.getStackSize();
            string = string + "Area Fraction: " + IJ.d2s(d * 100.0 / d2, 1) + "%";
        }
        new TextWindow("Summary of " + this.imp.getTitle(), string, 300, 200);
    }

    int getColumnID(String string) {
        int n = this.rt.getFreeColumn(string);
        if (n == -2) {
            n = this.rt.getColumnIndex(string);
        }
        return n;
    }

    void makeCustomLut() {
        IndexColorModel indexColorModel = (IndexColorModel)LookUpTable.createGrayscaleColorModel(false);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        byArray[1] = -1;
        byArray2[1] = 0;
        byArray3[1] = 0;
        this.customLut = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public static void savePreferences(Properties properties) {
        ((Hashtable)properties).put(OPTIONS, Integer.toString(staticOptions));
        ((Hashtable)properties).put(BINS, Integer.toString(staticBins));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

