/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        String string = this.getImageInfo(this.imp, imageProcessor);
        if (string.indexOf("----") > 0) {
            this.showInfo(string, 400, 500);
        } else {
            this.showInfo(string, 300, 300);
        }
    }

    public String getImageInfo(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Object object;
        String string;
        String string2 = null;
        if (imagePlus.getStackSize() > 1 && (string = ((ImageStack)(object = imagePlus.getStack())).getSliceLabel(imagePlus.getCurrentSlice())) != null && string.indexOf(10) > 0) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = (String)imagePlus.getProperty("Info");
        }
        object = this.getInfo(imagePlus, imageProcessor);
        if (string2 != null) {
            return string2 + "\n------------------------\n" + (String)object;
        }
        return object;
    }

    String getInfo(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Object object;
        double d;
        Object object2;
        String string;
        int n;
        String string2 = new String("\n");
        string2 = string2 + "Title: " + imagePlus.getTitle() + "\n";
        Calibration calibration = imagePlus.getCalibration();
        int n2 = imagePlus.getStackSize();
        int n3 = n = imagePlus.getBitDepth() == 32 ? 4 : 0;
        if (calibration.scaled()) {
            String string3 = calibration.getUnit();
            string = calibration.getUnits();
            string2 = string2 + "Width:  " + IJ.d2s((double)imagePlus.getWidth() * calibration.pixelWidth, 2) + " " + string + " (" + imagePlus.getWidth() + ")\n";
            string2 = string2 + "Height:  " + IJ.d2s((double)imagePlus.getHeight() * calibration.pixelHeight, 2) + " " + string + " (" + imagePlus.getHeight() + ")\n";
            if (n2 > 1) {
                string2 = string2 + "Depth:  " + IJ.d2s((double)n2 * calibration.pixelDepth, 2) + " " + string + " (" + n2 + ")\n";
            }
            if (n2 > 1) {
                string2 = string2 + "Voxel size: " + IJ.d2s(calibration.pixelWidth, 2) + "x" + IJ.d2s(calibration.pixelHeight, 2) + "x" + IJ.d2s(calibration.pixelDepth, 2) + "\n";
            }
            if (calibration.pixelWidth == calibration.pixelHeight) {
                string2 = string2 + "Resolution:  " + IJ.d2s(1.0 / calibration.pixelWidth, 1) + " pixels per " + string3 + "\n";
            } else {
                string2 = string2 + "X Resolution:  " + IJ.d2s(1.0 / calibration.pixelWidth, 1) + " pixels per " + string3 + "\n";
                string2 = string2 + "Y Resolution:  " + IJ.d2s(1.0 / calibration.pixelHeight, 1) + " pixels per " + string3 + "\n";
            }
        } else {
            string2 = string2 + "Width:  " + imagePlus.getWidth() + " pixels\n";
            string2 = string2 + "Height:  " + imagePlus.getHeight() + " pixels\n";
            if (n2 > 1) {
                string2 = string2 + "Depth:  " + n2 + " pixels\n";
            }
        }
        int n4 = imagePlus.getType();
        switch (n4) {
            case 0: {
                string2 = string2 + "Bits per pixel: 8 ";
                string = "LUT";
                string = imagePlus.getProcessor().isColorLut() ? "color " + string : "grayscale " + string;
                if (imagePlus.isInvertedLut()) {
                    string = "inverted " + string;
                }
                string2 = string2 + "(" + string + ")\n";
                break;
            }
            case 1: 
            case 2: {
                if (n4 == 1) {
                    ShortProcessor shortProcessor = (ShortProcessor)imagePlus.getProcessor();
                    string2 = string2 + "Bits per pixel: 16 (unsigned short)\n";
                } else {
                    string2 = string2 + "Bits per pixel: 32 (float)\n";
                }
                string2 = string2 + "Display range: ";
                double d2 = imageProcessor.getMin();
                double d3 = imageProcessor.getMax();
                if (calibration.calibrated()) {
                    d2 = calibration.getCValue((int)d2);
                    d3 = calibration.getCValue((int)d3);
                }
                string2 = string2 + IJ.d2s(d2, n) + " - " + IJ.d2s(d3, n) + "\n";
                break;
            }
            case 3: {
                string2 = string2 + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                string2 = string2 + "Bits per pixel: 32 (RGB)\n";
            }
        }
        double d4 = calibration.frameInterval;
        if (n2 > 1 && d4 != 0.0) {
            object2 = d4 > 0.0 ? "Frames: " : "Slices: ";
            string2 = string2 + (String)object2 + n2 + " (" + imagePlus.getCurrentSlice() + ")\n";
            if (d4 > 0.0) {
                if (d4 < 1.0) {
                    d = 1.0 / d4;
                    String string4 = Math.abs(d - (double)Math.round(d)) < 1.0E-5 ? IJ.d2s(d, 0) : IJ.d2s(d, 5);
                    string2 = string2 + "Frame rate: " + string4 + " fps\n";
                } else {
                    string2 = string2 + "Frame interval: " + IJ.d2s(d4, 5) + " seconds\n";
                }
            }
        }
        string2 = imageProcessor.getMinThreshold() == -808080.0 ? string2 + "No Threshold\n" : string2 + "Threshold: " + IJ.d2s(imageProcessor.getMinThreshold(), n) + "-" + IJ.d2s(imageProcessor.getMaxThreshold(), n) + "\n";
        object2 = imagePlus.getWindow().getCanvas();
        d = ((ImageCanvas)object2).getMagnification();
        if (d != 1.0) {
            string2 = string2 + "Magnification: " + d + "\n";
        }
        if (calibration.calibrated()) {
            string2 = string2 + " \n";
            int n5 = calibration.getFunction();
            string2 = string2 + "Calibration Function: ";
            string2 = n5 == 21 ? string2 + "Uncalibrated OD\n" : string2 + CurveFitter.fList[n5] + "\n";
            object = calibration.getCoefficients();
            if (object != null) {
                string2 = string2 + "  a: " + IJ.d2s((double)object[0], 6) + "\n";
                string2 = string2 + "  b: " + IJ.d2s((double)object[1], 6) + "\n";
                if (((Object)object).length >= 3) {
                    string2 = string2 + "  c: " + IJ.d2s((double)object[2], 6) + "\n";
                }
                if (((Object)object).length >= 4) {
                    string2 = string2 + "  c: " + IJ.d2s((double)object[3], 6) + "\n";
                }
                if (((Object)object).length >= 5) {
                    string2 = string2 + "  c: " + IJ.d2s((double)object[4], 6) + "\n";
                }
            }
            string2 = string2 + "  Unit: \"" + calibration.getValueUnit() + "\"\n";
        } else {
            string2 = string2 + "Uncalibrated\n";
        }
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo != null) {
            if (fileInfo.directory != null && fileInfo.fileName != null) {
                string2 = string2 + "Path: " + fileInfo.directory + fileInfo.fileName + "\n";
            }
            if (fileInfo.url != null && !fileInfo.url.equals("")) {
                string2 = string2 + "URL: " + fileInfo.url + "\n";
            }
        }
        if ((object = imagePlus.getRoi()) == null) {
            if (calibration.calibrated()) {
                string2 = string2 + " \n";
            }
            string2 = string2 + "No ROI\n";
        } else {
            string2 = string2 + " \n";
            switch (((Roi)object).getType()) {
                case 0: {
                    string2 = string2 + "Rectangular ROI\n";
                    break;
                }
                case 1: {
                    string2 = string2 + "Oval ROI\n";
                    break;
                }
                case 2: {
                    string2 = string2 + "Polygon ROI\n";
                    break;
                }
                case 3: {
                    string2 = string2 + "Freehand ROI\n";
                    break;
                }
                case 4: {
                    string2 = string2 + "Traced ROI\n";
                    break;
                }
                case 5: {
                    string2 = string2 + "Line Selection\n";
                    break;
                }
                case 6: {
                    string2 = string2 + "Polyline Selection\n";
                    break;
                }
                case 7: {
                    string2 = string2 + "Freehand line Selection\n";
                }
            }
            Rectangle rectangle = ((Roi)object).getBoundingRect();
            if (object instanceof Line) {
                Line line = (Line)object;
                string2 = string2 + "  X1: " + IJ.d2s((double)line.x1 * calibration.pixelWidth) + "\n";
                string2 = string2 + "  Y1: " + IJ.d2s((double)this.yy(line.y1) * calibration.pixelHeight) + "\n";
                string2 = string2 + "  X2: " + IJ.d2s((double)line.x2 * calibration.pixelWidth) + "\n";
                string2 = string2 + "  Y2: " + IJ.d2s((double)this.yy(line.y2) * calibration.pixelHeight) + "\n";
            } else if (calibration.scaled()) {
                string2 = string2 + "  X: " + IJ.d2s((double)rectangle.x * calibration.pixelWidth) + " (" + rectangle.x + ")\n";
                string2 = string2 + "  Y: " + IJ.d2s((double)this.yy(rectangle.y) * calibration.pixelHeight) + " (" + rectangle.y + ")\n";
                string2 = string2 + "  Width: " + IJ.d2s((double)rectangle.width * calibration.pixelWidth) + " (" + rectangle.width + ")\n";
                string2 = string2 + "  Height: " + IJ.d2s((double)rectangle.height * calibration.pixelHeight) + " (" + rectangle.height + ")\n";
            } else {
                string2 = string2 + "  X: " + rectangle.x + "\n";
                string2 = string2 + "  Y: " + this.yy(rectangle.y) + "\n";
                string2 = string2 + "  Width: " + rectangle.width + "\n";
                string2 = string2 + "  Height: " + rectangle.height + "\n";
            }
        }
        return string2;
    }

    int yy(int n) {
        return Analyzer.updateY(n, this.imp.getHeight());
    }

    void showInfo(String string, int n, int n2) {
        new TextWindow("Info for " + this.imp.getTitle(), string, n, n2);
    }
}

