/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.GUI;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class MacroInstaller
implements PlugIn,
MacroConstants,
ActionListener {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 50;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final char commandPrefix = '^';
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private String text;
    private String anonymousName;
    private Menu macrosMenu;
    private static String defaultDir;
    private static String fileName;
    private static MacroInstaller instance;
    private static MacroInstaller listener;

    public void run(String string) {
        if (string == null || string.equals("")) {
            string = this.showDialog();
        }
        if (string == null) {
            return;
        }
        String string2 = this.open(string);
        if (string2 != null) {
            this.install(string2);
        }
    }

    void install() {
        Object object;
        int n;
        Object object2;
        if (this.text != null) {
            object2 = new Tokenizer();
            this.pgm = ((Tokenizer)object2).tokenize(this.text);
        }
        IJ.showStatus("");
        object2 = this.pgm.getCode();
        Symbol[] symbolArray = this.pgm.getSymbolTable();
        int n2 = 0;
        this.shortcutsInUse = null;
        this.inUseCount = 0;
        this.nShortcuts = 0;
        this.macroStarts = new int[50];
        this.macroNames = new String[50];
        int n3 = 0;
        int n4 = this.macrosMenu.getItemCount();
        int n5 = n = this.macrosMenu == Menus.getMacrosMenu() ? 3 : 2;
        if (n4 > n) {
            int n6 = n4 - 1;
            while (n6 >= n) {
                this.macrosMenu.remove(n6);
                --n6;
            }
        }
        int n7 = 0;
        while (n7 < ((Object)object2).length) {
            int n8 = object2[n7] & 0xFFFF;
            if (n8 == 200) {
                int n9 = object2[n7 + 1] & 0xFFFF;
                if (n9 == 133) {
                    reference var6_11 = object2[n7 + 1] >> 16;
                    Symbol symbol = symbolArray[var6_11];
                    String string = symbol.str;
                    this.macroStarts[n2] = n7 + 2;
                    this.macroNames[n2] = string;
                    if (string.indexOf(45) != -1 && (string.indexOf("Tool") != -1 || string.indexOf("tool") != -1)) {
                        Toolbar.getInstance().addMacroTool(string, this, n3);
                        ++n3;
                    } else {
                        this.addShortcut(string);
                        this.macrosMenu.add(new MenuItem(string));
                    }
                    if (++n2 == 50) {
                        break;
                    }
                }
            } else if (n8 == 128) break;
            ++n7;
        }
        this.nMacros = n2;
        if (n3 > 0) {
            object = Toolbar.getInstance();
            if (Toolbar.getToolId() >= 15) {
                ((Toolbar)object).setTool(0);
            }
            ((Component)object).repaint();
        }
        if (this.pgm.hasVars() && this.pgm.getGlobals() == null) {
            new Interpreter().saveGlobals(this.pgm);
        }
        MacroInstaller macroInstaller = instance = this.nShortcuts > 0 ? this : null;
        if (this.shortcutsInUse != null && this.text != null) {
            IJ.showMessage("Install Macros", (this.inUseCount == 1 ? "This keyboard shortcut is" : "These keyboard shortcuts are") + " already in use:" + this.shortcutsInUse);
        }
        if (this.nMacros == 0 && fileName != null) {
            int n10 = fileName.lastIndexOf(46);
            this.anonymousName = n10 > 0 ? fileName.substring(0, n10) : fileName;
            this.macrosMenu.add(new MenuItem(this.anonymousName));
            this.nMacros = 1;
        }
        object = this.nMacros == 1 ? " macro" : " macros";
        IJ.showStatus(this.nMacros + (String)object + " installed");
    }

    public int install(String string) {
        if (string == null && this.pgm == null) {
            return 0;
        }
        this.text = string;
        this.macrosMenu = Menus.getMacrosMenu();
        if (listener != null) {
            this.macrosMenu.removeActionListener(listener);
        }
        this.macrosMenu.addActionListener(this);
        listener = this;
        this.install();
        return this.nShortcuts;
    }

    public int install(String string, Menu menu) {
        this.text = string;
        this.macrosMenu = menu;
        this.install();
        return this.nShortcuts;
    }

    void removeShortcuts() {
        Hashtable hashtable = Menus.getShortcuts();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string = (String)hashtable.get(n);
            if (string.charAt(0) != '^') continue;
            hashtable.remove(n);
        }
    }

    void addShortcut(String string) {
        Hashtable hashtable;
        int n = string.indexOf(91);
        if (n == -1) {
            return;
        }
        int n2 = string.lastIndexOf(93);
        if (n2 <= n + 1) {
            return;
        }
        String string2 = string.substring(n + 1, n2);
        int n3 = (string2 = string2.replace('f', 'F')).length();
        if (n3 > 3 || n3 > 1 && string2.charAt(0) != 'F') {
            return;
        }
        int n4 = Menus.convertShortcutToCode(string2);
        if (n4 == 0) {
            return;
        }
        if (this.nShortcuts == 0) {
            this.removeShortcuts();
        }
        if ((hashtable = Menus.getShortcuts()).get(new Integer(n4)) != null) {
            if (this.shortcutsInUse == null) {
                this.shortcutsInUse = "\n \n";
            }
            this.shortcutsInUse = this.shortcutsInUse + "    " + string + "\n";
            ++this.inUseCount;
            return;
        }
        hashtable.put(new Integer(n4), '^' + string);
        ++this.nShortcuts;
    }

    String showDialog() {
        FileDialog fileDialog = new FileDialog((Frame)IJ.getInstance(), "Install Macros...");
        if (defaultDir != null) {
            fileDialog.setDirectory(defaultDir);
        } else {
            String string = Menus.getMacrosPath();
            if (string != null) {
                fileDialog.setDirectory(string);
            }
        }
        if (fileName != null) {
            fileDialog.setFile(fileName);
        }
        GUI.center(fileDialog);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null) {
            return null;
        }
        String string2 = fileDialog.getDirectory();
        fileDialog.dispose();
        if (!string.endsWith(".txt")) {
            IJ.showMessage("Macro Installer", "File name must end with \".txt\".");
            return null;
        }
        fileName = string;
        defaultDir = string2;
        return string2 + string;
    }

    String open(String string) {
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            return new String(stringBuffer);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return null;
        }
    }

    public void runMacroTool(String string) {
        int n = 0;
        while (n < this.nMacros) {
            if (this.macroNames[n].startsWith(string)) {
                new MacroRunner(this.pgm, this.macroStarts[n], string);
                return;
            }
            ++n;
        }
    }

    public static void doShortcut(String string) {
        if (instance == null) {
            return;
        }
        int n = 0;
        while (n < MacroInstaller.instance.nMacros) {
            if (string.endsWith(MacroInstaller.instance.macroNames[n])) {
                new MacroRunner(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[n], string);
                return;
            }
            ++n;
        }
    }

    public void runMacro(String string) {
        if (this.anonymousName != null && string.equals(this.anonymousName)) {
            new MacroRunner(this.pgm, 0, this.anonymousName);
            return;
        }
        int n = 0;
        while (n < this.nMacros) {
            if (string.equals(this.macroNames[n])) {
                new MacroRunner(this.pgm, this.macroStarts[n], string);
                return;
            }
            ++n;
        }
    }

    public int getMacroCount() {
        return this.nMacros;
    }

    public void setFileName(String string) {
        fileName = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.runMacro(actionEvent.getActionCommand());
    }
}

