/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.macro.MacroConstants;

class Variable
implements MacroConstants {
    static final int VALUE = 0;
    static final int ARRAY = 1;
    static final int STRING = 2;
    static boolean doHash;
    int symTabIndex;
    private double value;
    private String str;
    private Variable[] array;

    Variable() {
    }

    Variable(double d) {
        this.value = d;
    }

    Variable(int n, double d, String string) {
        this.symTabIndex = n;
        this.value = d;
        this.str = string;
    }

    Variable(int n, double d, String string, Variable[] variableArray) {
        this.symTabIndex = n;
        this.value = d;
        this.str = string;
        this.array = variableArray;
    }

    Variable(byte[] byArray) {
        this.array = new Variable[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.array[n] = new Variable(byArray[n] & 0xFF);
            ++n;
        }
    }

    Variable(int[] nArray) {
        this.array = new Variable[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.array[n] = new Variable(nArray[n]);
            ++n;
        }
    }

    Variable(double[] dArray) {
        this.array = new Variable[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.array[n] = new Variable(dArray[n]);
            ++n;
        }
    }

    double getValue() {
        if (this.str != null) {
            if (doHash) {
                return this.getHashCode();
            }
            return this.convertToDouble();
        }
        return this.value;
    }

    double convertToDouble() {
        try {
            Double d = new Double(this.str);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    void setValue(double d) {
        this.value = d;
        this.str = null;
        this.array = null;
    }

    String getString() {
        return this.str;
    }

    void setString(String string) {
        this.str = string;
        this.value = 0.0;
        this.array = null;
    }

    Variable[] getArray() {
        return this.array;
    }

    void setArray(Variable[] variableArray) {
        this.array = variableArray;
        this.value = 0.0;
        this.str = null;
    }

    int getType() {
        if (this.array != null) {
            return 1;
        }
        if (this.str != null) {
            return 2;
        }
        return 0;
    }

    double getHashCode() {
        int n = 102;
        double d = 1.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.str.length()) {
            double d3 = this.str.charAt(n2);
            if (d3 >= 65.0 && d3 <= 90.0) {
                d3 += 32.0;
            }
            if (d3 >= 91.0) {
                d3 -= 26.0;
            }
            d2 += d3 * d;
            d *= (double)n;
            ++n2;
        }
        return d2;
    }

    public String toString() {
        String string = "";
        string = this.array != null ? string + "array[" + this.array.length + "]" : (this.str != null ? string + this.str : string + "" + this.value);
        return string + " " + this.symTabIndex;
    }
}

