/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class Tokenizer
implements MacroConstants {
    private StreamTokenizer st;
    private int token;
    private String tokenString;
    private double tokenValue;
    private Program pgm;
    private boolean hasUserFunctions;

    public Program tokenize(String string) {
        IJ.showStatus("tokenizing");
        this.st = new StreamTokenizer(new StringReader(string));
        this.st.eolIsSignificant(true);
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(47);
        this.st.ordinaryChar(46);
        this.st.wordChars(95, 95);
        this.st.slashStarComments(true);
        this.st.slashSlashComments(true);
        this.pgm = new Program();
        do {
            this.getToken();
            this.addToken();
        } while (this.token != 128);
        if (this.hasUserFunctions) {
            this.addUserFunctions();
        }
        if (IJ.debugMode) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
        }
        return this.pgm;
    }

    final void getToken() {
        try {
            this.token = this.st.nextToken();
            String string = null;
            switch (this.st.ttype) {
                case -1: {
                    string = "EOF";
                    this.token = 128;
                    break;
                }
                case 10: {
                    string = "EOL";
                    this.token = 132;
                    break;
                }
                case -3: {
                    string = this.st.sval;
                    this.token = 129;
                    break;
                }
                case -2: {
                    string = "" + this.st.nval;
                    this.tokenValue = this.st.nval;
                    if (this.tokenValue == 0.0) {
                        this.tokenValue = this.getHexConstant();
                    }
                    this.token = 130;
                    break;
                }
                case 34: 
                case 39: {
                    string = "" + this.st.sval;
                    this.token = 133;
                    break;
                }
                case 43: {
                    int n = this.st.nextToken();
                    if (n == 43) {
                        this.token = 1;
                        break;
                    }
                    if (n == 61) {
                        this.token = 9;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 45: {
                    int n = this.st.nextToken();
                    if (n == 45) {
                        this.token = 2;
                        break;
                    }
                    if (n == 61) {
                        this.token = 10;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 42: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 11;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 47: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 12;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 61: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 3;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 33: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 4;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 62: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 6;
                        break;
                    }
                    if (n == 62) {
                        this.token = 15;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 5;
                    break;
                }
                case 60: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 8;
                        break;
                    }
                    if (n == 60) {
                        this.token = 16;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 7;
                    break;
                }
                case 38: {
                    int n = this.st.nextToken();
                    if (n == 38) {
                        this.token = 13;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 124: {
                    int n = this.st.nextToken();
                    if (n == 124) {
                        this.token = 14;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
            }
            this.tokenString = string;
        }
        catch (Exception exception) {
            return;
        }
    }

    final void addToken() {
        int n = this.token;
        switch (this.token) {
            case 129: {
                Symbol symbol = this.pgm.lookupWord(this.tokenString);
                if (symbol != null) {
                    int n2 = symbol.getFunctionType();
                    if (n2 == 0) {
                        n = symbol.type;
                        if (n == 207) {
                            this.hasUserFunctions = true;
                        }
                        if (n == 201) {
                            this.pgm.hasVars = true;
                        }
                    } else {
                        n = n2;
                    }
                    n += this.pgm.symTabLoc << 16;
                    break;
                }
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                n += this.pgm.stLoc << 16;
                break;
            }
            case 133: {
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                n += this.pgm.stLoc << 16;
                break;
            }
            case 130: {
                this.pgm.addSymbol(new Symbol(this.tokenValue));
                n += this.pgm.stLoc << 16;
                break;
            }
        }
        this.pgm.addToken(n);
    }

    double getHexConstant() {
        try {
            this.token = this.st.nextToken();
        }
        catch (Exception exception) {
            return 0.0;
        }
        if (this.st.ttype != -3) {
            this.st.pushBack();
            return 0.0;
        }
        if (!this.st.sval.startsWith("x")) {
            this.st.pushBack();
            return 0.0;
        }
        String string = this.st.sval.substring(1, this.st.sval.length());
        double d = 0.0;
        try {
            d = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.st.pushBack();
            d = 0.0;
        }
        return d;
    }

    void addUserFunctions() {
        int[] nArray = this.pgm.getCode();
        Symbol[] symbolArray = this.pgm.getSymbolTable();
        int n = 0;
        while (n < nArray.length) {
            this.token = nArray[n] & 0xFFFF;
            if (this.token == 207) {
                int n2 = nArray[n + 1] & 0xFFFF;
                if (n2 == 129) {
                    int n3 = nArray[n + 1] >> 16;
                    Symbol symbol = symbolArray[n3];
                    symbol.type = 138;
                    symbol.value = n + 1;
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        this.token = nArray[n4] & 0xFFFF;
                        if (this.token == 129 && nArray[n4] >> 16 == n3 && n4 > 0 && (nArray[n4 - 1] & 0xFFF) != 207) {
                            nArray[n4] = 138;
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + (n3 << 16);
                        } else if (this.token == 128) break;
                        ++n4;
                    }
                }
            } else if (this.token == 128) break;
            ++n;
        }
    }
}

