/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public final class RandomAccessStream
extends InputStream {
    private static final int BLOCK_SIZE = 512;
    private static final int BLOCK_MASK = 511;
    private static final int BLOCK_SHIFT = 9;
    private InputStream src;
    private RandomAccessFile ras;
    private int pointer;
    private Vector data;
    private int length;
    private boolean foundEOS;

    public RandomAccessStream(InputStream inputStream) {
        this.pointer = 0;
        this.data = new Vector();
        this.length = 0;
        this.foundEOS = false;
        this.src = inputStream;
    }

    public RandomAccessStream(RandomAccessFile randomAccessFile) {
        this.ras = randomAccessFile;
    }

    public int getFilePointer() throws IOException {
        if (this.ras != null) {
            return (int)this.ras.getFilePointer();
        }
        return this.pointer;
    }

    public int read() throws IOException {
        if (this.ras != null) {
            return this.ras.read();
        }
        int n = this.pointer + 1;
        int n2 = this.readUntil(n);
        if (n2 >= n) {
            byte[] byArray = (byte[])this.data.elementAt(this.pointer >> 9);
            return byArray[this.pointer++ & 0x1FF] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.ras != null) {
            return this.ras.read(byArray, n, n2);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.readUntil(this.pointer + n2);
        if (n3 <= this.pointer) {
            return -1;
        }
        byte[] byArray2 = (byte[])this.data.elementAt(this.pointer >> 9);
        int n4 = Math.min(n2, 512 - (this.pointer & 0x1FF));
        System.arraycopy(byArray2, this.pointer & 0x1FF, byArray, n, n4);
        this.pointer += n4;
        return n4;
    }

    public final void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        do {
            if ((n = this.read(byArray, n2, n3 - n2)) >= 0) continue;
            throw new EOFException();
        } while ((n2 += n) < n3);
    }

    private int readUntil(int n) throws IOException {
        int n2;
        if (n < this.length) {
            return n;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int n3 = n >> 9;
        int n4 = n2 = this.length >> 9;
        while (n4 <= n3) {
            byte[] byArray = new byte[512];
            this.data.addElement(byArray);
            int n5 = 512;
            int n6 = 0;
            while (n5 > 0) {
                int n7 = this.src.read(byArray, n6, n5);
                if (n7 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                n6 += n7;
                n5 -= n7;
                this.length += n7;
            }
            ++n4;
        }
        return this.length;
    }

    public void seek(int n) throws IOException {
        if (this.ras != null) {
            this.ras.seek(n);
            return;
        }
        this.pointer = n < 0 ? 0 : n;
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void close() throws IOException {
        if (this.ras != null) {
            this.ras.close();
        } else {
            this.data.removeAllElements();
            this.src.close();
        }
    }
}

