/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;

public class ImportDialog {
    private String fileName;
    private String directory;
    static final String TYPE = "raw.type";
    static final String WIDTH = "raw.width";
    static final String HEIGHT = "raw.height";
    static final String OFFSET = "raw.offset";
    static final String N = "raw.n";
    static final String GAP = "raw.gap";
    static final String OPTIONS = "raw.options";
    static final int WHITE_IS_ZERO = 1;
    static final int INTEL_BYTE_ORDER = 2;
    static final int OPEN_ALL = 4;
    private static int choiceSelection = Prefs.getInt("raw.type", 0);
    private static int width = Prefs.getInt("raw.width", 512);
    private static int height = Prefs.getInt("raw.height", 512);
    private static long offset = Prefs.getInt("raw.offset", 0);
    private static int nImages = Prefs.getInt("raw.n", 1);
    private static int gapBetweenImages = Prefs.getInt("raw.gap", 0);
    private static int options;
    private static boolean whiteIsZero;
    private static boolean intelByteOrder;
    private boolean openAll;
    private static String[] types;
    static /* synthetic */ Class class$ij$io$ImportDialog;

    public ImportDialog(String string, String string2) {
        this.fileName = string;
        this.directory = string2;
        IJ.showStatus("Importing: " + string);
    }

    public ImportDialog() {
    }

    boolean showDialog() {
        if (choiceSelection >= types.length) {
            choiceSelection = 0;
        }
        GenericDialog genericDialog = new GenericDialog("Import...", IJ.getInstance());
        genericDialog.addChoice("Image Type:", types, types[choiceSelection]);
        genericDialog.addNumericField("Width:", width, 0, 6, "pixels");
        genericDialog.addNumericField("Height:", height, 0, 6, "pixels");
        genericDialog.addNumericField("Offset to First Image:", offset, 0, 6, "bytes");
        genericDialog.addNumericField("Number of Images:", nImages, 0, 6, null);
        genericDialog.addNumericField("Gap Between Images:", gapBetweenImages, 0, 6, "bytes");
        genericDialog.addCheckbox("White is Zero", whiteIsZero);
        genericDialog.addCheckbox("Little-Endian Byte Order", intelByteOrder);
        genericDialog.addCheckbox("Open All Files in Folder", this.openAll);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        choiceSelection = genericDialog.getNextChoiceIndex();
        width = (int)genericDialog.getNextNumber();
        height = (int)genericDialog.getNextNumber();
        offset = (long)genericDialog.getNextNumber();
        nImages = (int)genericDialog.getNextNumber();
        gapBetweenImages = (int)genericDialog.getNextNumber();
        whiteIsZero = genericDialog.getNextBoolean();
        intelByteOrder = genericDialog.getNextBoolean();
        this.openAll = genericDialog.getNextBoolean();
        IJ.register(class$ij$io$ImportDialog == null ? (class$ij$io$ImportDialog = ImportDialog.class$("ij.io.ImportDialog")) : class$ij$io$ImportDialog);
        return true;
    }

    void openAll(String[] stringArray, FileInfo fileInfo) {
        StringSorter.sort(stringArray);
        ImageStack imageStack = null;
        ImagePlus imagePlus = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith(".")) {
                fileInfo.fileName = stringArray[n];
                imagePlus = new FileOpener(fileInfo).open(false);
                if (imagePlus == null) {
                    IJ.log(stringArray[n] + ": unable to open");
                } else {
                    if (imageStack == null) {
                        imageStack = imagePlus.createEmptyStack();
                    }
                    try {
                        ImageProcessor imageProcessor = imagePlus.getProcessor();
                        if (imageProcessor.getMin() < d) {
                            d = imageProcessor.getMin();
                        }
                        if (imageProcessor.getMax() > d2) {
                            d2 = imageProcessor.getMax();
                        }
                        imageStack.addSlice(stringArray[n], imageProcessor);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        IJ.outOfMemory("OpenAll");
                        imageStack.trim();
                        break;
                    }
                    IJ.showStatus(imageStack.getSize() + 1 + ": " + stringArray[n]);
                }
            }
            ++n;
        }
        if (imageStack != null) {
            imagePlus = new ImagePlus("Imported Stack", imageStack);
            if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
                imagePlus.getProcessor().setMinAndMax(d, d2);
            }
            imagePlus.show();
        }
    }

    public void openImage() {
        FileInfo fileInfo = this.getFileInfo();
        if (fileInfo == null) {
            return;
        }
        if (this.openAll) {
            String[] stringArray = new File(this.directory).list();
            if (stringArray == null) {
                return;
            }
            this.openAll(stringArray, fileInfo);
        } else {
            FileOpener fileOpener = new FileOpener(fileInfo);
            fileOpener.open();
        }
    }

    public FileInfo getFileInfo() {
        if (!this.showDialog()) {
            return null;
        }
        String string = types[choiceSelection];
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 1;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = width;
        fileInfo.height = height;
        if (offset > Integer.MAX_VALUE) {
            fileInfo.longOffset = offset;
        } else {
            fileInfo.offset = (int)offset;
        }
        fileInfo.nImages = nImages;
        fileInfo.gapBetweenImages = gapBetweenImages;
        fileInfo.intelByteOrder = intelByteOrder;
        fileInfo.whiteIsZero = whiteIsZero;
        fileInfo.fileType = string.equals("8-bit") ? 0 : (string.equals("16-bit Signed") ? 1 : (string.equals("16-bit Unsigned") ? 2 : (string.equals("32-bit Signed") ? 3 : (string.equals("32-bit Unsigned") ? 11 : (string.equals("32-bit Real") ? 4 : (string.equals("24-bit RGB") ? 6 : (string.equals("24-bit RGB Planar") ? 7 : (string.equals("24-bit BGR") ? 10 : (string.equals("32-bit ARGB") ? 9 : (string.equals("1-bit Bitmap") ? 8 : 0))))))))));
        if (IJ.debugMode) {
            IJ.log("ImportDialog: " + fileInfo);
        }
        return fileInfo;
    }

    public static void savePreferences(Properties properties) {
        ((Hashtable)properties).put(TYPE, Integer.toString(choiceSelection));
        ((Hashtable)properties).put(WIDTH, Integer.toString(width));
        ((Hashtable)properties).put(HEIGHT, Integer.toString(height));
        ((Hashtable)properties).put(OFFSET, Integer.toString(offset > Integer.MAX_VALUE ? 0 : (int)offset));
        ((Hashtable)properties).put(N, Integer.toString(nImages));
        ((Hashtable)properties).put(GAP, Integer.toString(gapBetweenImages));
        int n = 0;
        if (whiteIsZero) {
            n |= 1;
        }
        if (intelByteOrder) {
            n |= 2;
        }
        ((Hashtable)properties).put(OPTIONS, Integer.toString(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        types = new String[]{"8-bit", "16-bit Signed", "16-bit Unsigned", "32-bit Signed", "32-bit Unsigned", "32-bit Real", "24-bit RGB", "24-bit RGB Planar", "24-bit BGR", "32-bit ARGB", "1-bit Bitmap"};
        options = Prefs.getInt(OPTIONS, 0);
        whiteIsZero = (options & 1) != 0;
        intelByteOrder = (options & 2) != 0;
    }
}

