/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    private static double fixedMin = Prefs.getDouble("pp.min", 0.0);
    private static double fixedMax = Prefs.getDouble("pp.max", 0.0);
    protected ImagePlus imp;
    protected double[] profile;
    protected double magnification;
    protected double pixelSize;
    protected String units;
    protected String yLabel;
    static /* synthetic */ Class class$ij$gui$ProfilePlot;

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imagePlus) {
        this(imagePlus, false);
    }

    public ProfilePlot(ImagePlus imagePlus, boolean bl) {
        this.imp = imagePlus;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Selection required.");
            return;
        }
        int n = roi.getType();
        if (n != 5 && n != 6 && n != 7 && n != 0) {
            IJ.error("Line or rectangular selection required.");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        this.pixelSize = calibration.pixelWidth;
        this.units = calibration.getUnits();
        this.yLabel = calibration.getValueUnit();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.setCalibrationTable(calibration.getCTable());
        if (n == 5) {
            imageProcessor.setInterpolate(true);
            this.profile = ((Line)roi).getPixels();
        } else {
            this.profile = n == 6 || n == 7 ? this.getIrregularProfile(roi, imageProcessor) : (bl ? this.getRowAverageProfile(roi.getBoundingRect(), calibration, imageProcessor) : this.getColumnAverageProfile(roi.getBoundingRect(), imageProcessor));
        }
        imageProcessor.setCalibrationTable(null);
        ImageWindow imageWindow = imagePlus.getWindow();
        this.magnification = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
    }

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int n = (int)((double)this.profile.length * this.magnification);
        int n2 = (int)((double)n * 0.5);
        if (n < 350) {
            n = 350;
            n2 = (int)((double)n * 0.5);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = Math.min(dimension.width - 200, 1000);
        if (n > n3) {
            n = n3;
            n2 = (int)((double)n * 0.5);
        }
        return new Dimension(n, n2);
    }

    public void createWindow() {
        if (this.profile == null) {
            return;
        }
        Dimension dimension = this.getPlotSize();
        String string = "Distance (" + this.units + ")";
        int n = this.profile.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)((double)n2 * this.pixelSize);
            ++n2;
        }
        float[] fArray2 = new float[n];
        int n3 = 0;
        while (n3 < n) {
            fArray2[n3] = (float)this.profile[n3];
            ++n3;
        }
        boolean bl = fixedMin != 0.0 || fixedMax != 0.0;
        PlotWindow plotWindow = new PlotWindow("Plot of " + this.imp.getShortTitle(), string, this.yLabel, fArray, fArray2);
        if (bl) {
            double[] dArray = Tools.getMinMax(fArray);
            plotWindow.setLimits(dArray[0], dArray[1], fixedMin, fixedMax);
        }
        plotWindow.draw();
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static void setMinAndMax(double d, double d2) {
        fixedMin = d;
        fixedMax = d2;
        IJ.register(class$ij$gui$ProfilePlot == null ? (class$ij$gui$ProfilePlot = ProfilePlot.class$("ij.gui.ProfilePlot")) : class$ij$gui$ProfilePlot);
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getRowAverageProfile(Rectangle rectangle, Calibration calibration, ImageProcessor imageProcessor) {
        int n;
        double[] dArray = new double[rectangle.height];
        imageProcessor.setInterpolate(false);
        int n2 = rectangle.x;
        while (n2 < rectangle.x + rectangle.width) {
            double[] dArray2 = imageProcessor.getLine(n2, rectangle.y, n2, rectangle.y + rectangle.height - 1);
            n = 0;
            while (n < rectangle.height) {
                int n3 = n;
                dArray[n3] = dArray[n3] + dArray2[n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < rectangle.height) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)rectangle.width;
        }
        if (calibration != null) {
            this.pixelSize = calibration.pixelHeight;
        }
        return dArray;
    }

    double[] getColumnAverageProfile(Rectangle rectangle, ImageProcessor imageProcessor) {
        int n;
        double[] dArray = new double[rectangle.width];
        imageProcessor.setInterpolate(false);
        int n2 = rectangle.y;
        while (n2 < rectangle.y + rectangle.height) {
            double[] dArray2 = imageProcessor.getLine(rectangle.x, n2, rectangle.x + rectangle.width - 1, n2);
            n = 0;
            while (n < rectangle.width) {
                int n3 = n;
                dArray[n3] = dArray[n3] + dArray2[n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < rectangle.width) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)rectangle.height;
        }
        return dArray;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor imageProcessor) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        Rectangle rectangle = roi.getBoundingRect();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        double d = 0.0;
        double[] dArray = new double[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = nArray[n4 + 1] - nArray[n4];
            int n6 = nArray2[n4 + 1] - nArray2[n4];
            double d2 = Math.sqrt(n5 * n5 + n6 * n6);
            d += d2;
            dArray[n4] = d2;
            nArray3[n4] = n5;
            nArray4[n4] = n6;
            ++n4;
        }
        double[] dArray2 = new double[(int)d];
        double d3 = 1.0;
        double d4 = 0.0;
        int n7 = 0;
        while (n7 < n) {
            double d5 = dArray[n7];
            if (d5 != 0.0) {
                double d6 = (double)nArray3[n7] / d5;
                double d7 = (double)nArray4[n7] / d5;
                double d8 = 1.0 - d3;
                double d9 = (double)(n2 + nArray[n7]) + d8 * d6;
                double d10 = (double)(n3 + nArray2[n7]) + d8 * d7;
                double d11 = d5 - d8;
                int n8 = (int)d11;
                int n9 = 0;
                while (n9 <= n8) {
                    int n10 = (int)d4 + n9;
                    if (n10 < dArray2.length) {
                        dArray2[n10] = imageProcessor.getInterpolatedValue(d9, d10);
                    }
                    d9 += d6;
                    d10 += d7;
                    ++n9;
                }
                d4 += d5;
                d3 = d11 - (double)n8;
            }
            ++n7;
        }
        return dArray2;
    }

    private double[] getLineSegment(ImageProcessor imageProcessor, double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = (int)Math.round(Math.sqrt(d5 * d5 + d6 * d6));
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n;
        double[] dArray = new double[++n];
        double d9 = d;
        double d10 = d2;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = imageProcessor.getInterpolatedValue(d9, d10);
            d9 += d7;
            d10 += d8;
            ++n2;
        }
        return dArray;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = 0;
        while (n < this.profile.length) {
            double d3 = this.profile[n];
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            ++n;
        }
        this.min = d;
        this.max = d2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

