/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.ImageCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.io.Serializable;

public class ImageLayout
implements LayoutManager {
    int hgap;
    int vgap;
    ImageCanvas ic;

    public ImageLayout(ImageCanvas imageCanvas) {
        this.ic = imageCanvas;
        this.hgap = 5;
        this.vgap = 5;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            Dimension dimension2 = ((Component)serializable).getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (n2 > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
            ++n2;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        n2 += n4 / 2;
        int n7 = 0;
        while (n7 < n5) {
            Component component = container.getComponent(n7);
            Dimension dimension = component.getSize();
            if (n7 == 0) {
                n6 = n + (n3 - dimension.width) / 2;
            }
            component.setLocation(n6, n2);
            n2 += this.vgap + dimension.height;
            ++n7;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.width - (insets.left + insets.right + this.hgap * 2);
        int n2 = dimension.height - (insets.top + insets.bottom + this.vgap * 2);
        this.ic.resizeCanvas(n, n2);
        int n3 = dimension.width - (insets.left + insets.right + this.hgap * 2);
        int n4 = dimension.height - (insets.top + insets.bottom + this.vgap * 2);
        int n5 = container.getComponentCount();
        Dimension dimension2 = this.preferredLayoutSize(container);
        int n6 = insets.left + this.hgap + (dimension.width - dimension2.width) / 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            Component component = container.getComponent(n9);
            dimension = component.getPreferredSize();
            if (component instanceof Scrollbar) {
                int n10 = container.getComponent((int)0).getPreferredSize().width;
                Dimension dimension3 = component.getMinimumSize();
                if (n10 < dimension3.width) {
                    n10 = dimension3.width;
                }
                component.setSize(n10, dimension.height);
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (n7 > 0) {
                n7 += this.vgap;
            }
            n7 += dimension.height;
            n8 = Math.max(n8, dimension.width);
            ++n9;
        }
        this.moveComponents(container, n6, insets.top + this.vgap, n8, n4 - n7, n5);
    }
}

