/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener {
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Component theLabel;
    protected TextArea textArea1;
    protected TextArea textArea2;
    private Button cancel;
    private Button okay;
    private boolean wasCanceled;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean firstNumericField = true;
    private boolean invalidNumber;
    private boolean firstPaint = true;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;

    public GenericDialog(String string) {
        this(string, WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : (IJ.getInstance() != null ? IJ.getInstance() : new Frame()));
    }

    public GenericDialog(String string, Frame frame) {
        super(frame == null ? new Frame() : frame, string, true);
        this.setLayout(this.grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
    }

    public void addNumericField(String string, double d, int n) {
        this.addNumericField(string, d, n, 6, null);
    }

    public void addNumericField(String string, double d, int n, int n2, String string2) {
        String string3 = string;
        if (string3.indexOf(95) != -1) {
            string3 = string3.replace('_', ' ');
        }
        Label label = this.makeLabel(string3);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? new Insets(5, 0, 3, 0) : new Insets(0, 0, 3, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            n2 -= 2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        TextField textField = new TextField(IJ.d2s(d, n), n2);
        textField.addActionListener(this);
        textField.addTextListener(this);
        textField.addFocusListener(this);
        textField.addKeyListener(this);
        this.numberField.addElement(textField);
        this.defaultValues.addElement(new Double(d));
        this.defaultText.addElement(textField.getText());
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        textField.setEditable(true);
        if (this.firstNumericField) {
            textField.selectAll();
        }
        this.firstNumericField = false;
        if (string2 == null || string2.equals("")) {
            this.grid.setConstraints(textField, this.c);
            this.add(textField);
        } else {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(textField);
            panel.add(new Label(" " + string2));
            this.grid.setConstraints(panel, this.c);
            this.add(panel);
        }
        if (Recorder.record || this.macro) {
            this.saveLabel(textField, string);
        }
        ++this.y;
    }

    private Label makeLabel(String string) {
        if (IJ.isMacintosh()) {
            string = string + " ";
        }
        return new Label(string);
    }

    private void saveLabel(Component component, String string) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        this.labels.put(component, string);
    }

    public void addStringField(String string, String string2) {
        this.addStringField(string, string2, 8);
    }

    public void addStringField(String string, String string2, int n) {
        Label label = this.makeLabel(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.c.insets = new Insets(5, 0, 5, 0);
        } else {
            this.c.insets = new Insets(0, 0, 5, 0);
        }
        this.grid.setConstraints(label, this.c);
        this.add(label);
        TextField textField = new TextField(string2, n);
        textField.addActionListener(this);
        textField.addTextListener(this);
        textField.addFocusListener(this);
        textField.addKeyListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(textField, this.c);
        textField.setEditable(true);
        this.add(textField);
        this.stringField.addElement(textField);
        if (Recorder.record || this.macro) {
            this.saveLabel(textField, string);
        }
        ++this.y;
    }

    public void addCheckbox(String string, boolean bl) {
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
            this.c.insets = new Insets(15, 20, 0, 0);
        } else {
            this.c.insets = new Insets(0, 20, 0, 0);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        Checkbox checkbox = new Checkbox(string);
        this.grid.setConstraints(checkbox, this.c);
        checkbox.setState(bl);
        checkbox.addItemListener(this);
        checkbox.addKeyListener(this);
        this.add(checkbox);
        this.checkbox.addElement(checkbox);
        if (Recorder.record || this.macro) {
            this.saveLabel(checkbox, string);
        }
        ++this.y;
    }

    public void addCheckboxGroup(int n, int n2, String[] stringArray, boolean[] blArray) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(n, n2, 10, 0));
        int n3 = this.cbIndex;
        int n4 = 0;
        int[] nArray = new int[stringArray.length];
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        boolean bl = stringArray.length <= 4;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n6 * n + n5;
                if (n7 >= stringArray.length) break;
                nArray[n4] = n7;
                Checkbox checkbox = new Checkbox(stringArray[n4]);
                this.checkbox.addElement(checkbox);
                checkbox.setState(blArray[n4]);
                if (bl) {
                    checkbox.addItemListener(this);
                }
                if (Recorder.record || this.macro) {
                    this.saveLabel(checkbox, stringArray[n4]);
                }
                panel.add(checkbox);
                ++n4;
                ++n6;
            }
            ++n5;
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String string, String[] stringArray, String string2) {
        Label label = this.makeLabel(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.c.insets = new Insets(5, 0, 5, 0);
        } else {
            this.c.insets = new Insets(0, 0, 5, 0);
        }
        this.grid.setConstraints(label, this.c);
        this.add(label);
        Choice choice = new Choice();
        choice.addKeyListener(this);
        choice.addItemListener(this);
        int n = 0;
        while (n < stringArray.length) {
            choice.addItem(stringArray[n]);
            ++n;
        }
        choice.select(string2);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(choice, this.c);
        this.add(choice);
        this.choice.addElement(choice);
        if (Recorder.record || this.macro) {
            this.saveLabel(choice, string);
        }
        ++this.y;
    }

    public void addMessage(String string) {
        this.theLabel = string.indexOf(10) >= 0 ? new MultiLineLabel(string) : new Label(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(string.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(this.theLabel, this.c);
        this.add(this.theLabel);
        ++this.y;
    }

    public void addTextAreas(String string, String string2, int n, int n2) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(string, n, n2, 3);
        panel.add(this.textArea1);
        if (string2 != null) {
            this.textArea2 = new TextArea(string2, n, n2, 3);
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public boolean wasCanceled() {
        if (this.wasCanceled) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public double getNextNumber() {
        double d;
        String string;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField textField = (TextField)this.numberField.elementAt(this.nfIndex);
        String string2 = textField.getText();
        if (this.macro) {
            string = (String)this.labels.get(textField);
            string2 = Macro.getValue(this.macroOptions, string, string2);
        }
        string = (String)this.defaultText.elementAt(this.nfIndex);
        double d2 = (Double)this.defaultValues.elementAt(this.nfIndex);
        if (string2.equals(string)) {
            d = d2;
        } else {
            Double d3 = this.getValue(string2);
            if (d3 != null) {
                d = d3;
            } else {
                this.invalidNumber = true;
                d = 0.0;
            }
        }
        if (Recorder.record) {
            this.recordOption(textField, this.trim(string2));
        }
        ++this.nfIndex;
        return d;
    }

    private String trim(String string) {
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.endsWith(".00")) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }

    private void recordOption(Component component, String string) {
        String string2 = (String)this.labels.get(component);
        Recorder.recordOption(string2, string);
    }

    private void recordCheckboxOption(Checkbox checkbox) {
        String string = (String)this.labels.get(checkbox);
        if (checkbox.getState() && string != null) {
            Recorder.recordOption(string);
        }
    }

    protected Double getValue(String string) {
        Double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        return d;
    }

    public boolean invalidNumber() {
        boolean bl = this.invalidNumber;
        this.invalidNumber = false;
        return bl;
    }

    public String getNextString() {
        if (this.stringField == null) {
            return "";
        }
        TextField textField = (TextField)this.stringField.elementAt(this.sfIndex);
        String string = textField.getText();
        if (this.macro) {
            String string2 = (String)this.labels.get(textField);
            string = Macro.getValue(this.macroOptions, string2, string);
        }
        if (Recorder.record) {
            this.recordOption(textField, string);
        }
        ++this.sfIndex;
        return string;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox checkbox = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (Recorder.record) {
            this.recordCheckboxOption(checkbox);
        }
        boolean bl = checkbox.getState();
        if (this.macro) {
            String string = (String)this.labels.get(checkbox);
            String string2 = Macro.trimKey(string);
            bl = this.macroOptions.indexOf(string2 + " ") >= 0;
        }
        ++this.cbIndex;
        return bl;
    }

    public String getNextChoice() {
        if (this.choice == null) {
            return "";
        }
        Choice choice = (Choice)this.choice.elementAt(this.choiceIndex);
        String string = choice.getSelectedItem();
        if (this.macro) {
            String string2 = (String)this.labels.get(choice);
            string = Macro.getValue(this.macroOptions, string2, string);
        }
        if (Recorder.record) {
            this.recordOption(choice, string);
        }
        ++this.choiceIndex;
        return string;
    }

    public int getNextChoiceIndex() {
        if (this.choice == null) {
            return -1;
        }
        Choice choice = (Choice)this.choice.elementAt(this.choiceIndex);
        int n = choice.getSelectedIndex();
        if (this.macro) {
            String string = (String)this.labels.get(choice);
            String string2 = choice.getSelectedItem();
            int n2 = choice.getSelectedIndex();
            String string3 = Macro.getValue(this.macroOptions, string, string2);
            choice.select(string3);
            n = choice.getSelectedIndex();
            if (n == n2 && !string3.equals(string2)) {
                IJ.showMessage(this.getTitle(), "\"" + string3 + "\" is not a valid choice for \"" + string + "\"");
                Macro.abort();
            }
        }
        if (Recorder.record) {
            this.recordOption(choice, choice.getSelectedItem());
        }
        ++this.choiceIndex;
        return n;
    }

    public String getNextText() {
        String string;
        if (this.textArea1 != null) {
            this.textArea1.selectAll();
            string = this.textArea1.getText();
            this.textArea1 = null;
            if (this.macro) {
                string = Macro.getValue(this.macroOptions, "text1", string);
            }
            if (Recorder.record) {
                Recorder.recordOption("text1", string.replace('\n', ' '));
            }
        } else if (this.textArea2 != null) {
            this.textArea2.selectAll();
            string = this.textArea2.getText();
            this.textArea2 = null;
            if (this.macro) {
                string = Macro.getValue(this.macroOptions, "text2", string);
            }
            if (Recorder.record) {
                Recorder.recordOption("text2", string.replace('\n', ' '));
            }
        } else {
            string = null;
        }
        return string;
    }

    public void showDialog() {
        Component component;
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        if (this.macro) {
            this.dispose();
            return;
        }
        if (this.stringField != null && this.numberField == null) {
            component = (TextField)this.stringField.elementAt(0);
            ((TextComponent)component).selectAll();
        }
        component = new Panel();
        ((Container)component).setLayout(new FlowLayout(1, 5, 0));
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        this.okay = new Button("  OK  ");
        this.okay.addActionListener(this);
        if (IJ.isMacintosh()) {
            ((Container)component).add(this.cancel);
            ((Container)component).add(this.okay);
        } else {
            ((Container)component).add(this.okay);
            ((Container)component).add(this.cancel);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 2;
        this.c.insets = new Insets(15, 0, 0, 0);
        this.grid.setConstraints(component, this.c);
        this.add(component);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        this.setup();
        GUI.center(this);
        this.show();
        IJ.wait(250);
    }

    protected void setup() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.wasCanceled = actionEvent.getSource() == this.cancel;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void textValueChanged(TextEvent textEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof TextField) {
            ((TextField)component).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof TextField) {
            ((TextField)component).select(0, 0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
    }

    public void keyReleased(KeyEvent keyEvent) {
        IJ.setKeyUp(keyEvent.getKeyCode());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.firstPaint && this.numberField != null) {
            TextField textField = (TextField)this.numberField.elementAt(0);
            textField.requestFocus();
            this.firstPaint = false;
        }
    }
}

