/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import ij.plugin.Converter;
import ij.plugin.frame.Recorder;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector imageList = new Vector();
    private static Vector nonImageList = new Vector();
    private static ImageWindow currentWindow;
    private static Frame frontWindow;
    private static ImagePlus tempCurrentImage;

    public static synchronized void setCurrentWindow(ImageWindow imageWindow) {
        ImagePlus imagePlus;
        WindowManager.setWindow(imageWindow);
        tempCurrentImage = null;
        if (imageWindow == currentWindow || imageWindow == null || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imagePlus = currentWindow.getImagePlus()) != null && imagePlus.lockSilently()) {
            imagePlus.trimProcessor();
            Image image = imagePlus.getImage();
            if (!Converter.newWindowCreated) {
                imagePlus.saveRoi();
            }
            Converter.newWindowCreated = false;
            imagePlus.unlock();
        }
        Undo.reset();
        currentWindow = !imageWindow.isClosed() && imageWindow.getImagePlus() != null ? imageWindow : null;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        if (tempCurrentImage != null) {
            return tempCurrentImage;
        }
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        return imageList.size();
    }

    public static Frame getFrontWindow() {
        return frontWindow;
    }

    public static synchronized int[] getIDList() {
        int n = imageList.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n2);
            nArray[n2] = imageWindow.getImagePlus().getID();
            ++n2;
        }
        return nArray;
    }

    public static synchronized ImagePlus getImage(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = imageList.size();
        if (n2 == 0) {
            return null;
        }
        if (n > 0) {
            if (n > n2) {
                return null;
            }
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n - 1);
            if (imageWindow != null) {
                return imageWindow.getImagePlus();
            }
            return null;
        }
        ImagePlus imagePlus = null;
        int n3 = 0;
        while (n3 < imageList.size()) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n3);
            ImagePlus imagePlus2 = imageWindow.getImagePlus();
            if (n == imagePlus2.getID()) {
                imagePlus = imagePlus2;
                break;
            }
            ++n3;
        }
        return imagePlus;
    }

    public static synchronized void addWindow(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)frame);
        } else {
            Menus.insertWindowMenuItem(frame);
            nonImageList.addElement(frame);
        }
    }

    private static void addImageWindow(ImageWindow imageWindow) {
        imageList.addElement(imageWindow);
        Menus.addWindowMenuItem(imageWindow.getImagePlus());
        WindowManager.setCurrentWindow(imageWindow);
    }

    public static synchronized void removeWindow(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)frame);
        } else {
            int n = nonImageList.indexOf(frame);
            if (n >= 0) {
                Menus.removeWindowMenuItem(n);
                nonImageList.removeElement(frame);
            }
        }
        WindowManager.setWindow(null);
    }

    private static void removeImageWindow(ImageWindow imageWindow) {
        int n;
        int n2 = imageList.indexOf(imageWindow);
        if (n2 == -1) {
            return;
        }
        if (imageList.size() > 1) {
            n = n2 - 1;
            if (n < 0) {
                n = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(n));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(n2);
        n = nonImageList.size();
        if (n > 0) {
            ++n;
        }
        Menus.removeWindowMenuItem(n + n2);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame frame) {
        frontWindow = frame;
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int n = imageList.indexOf(currentWindow);
        if (--n < 0) {
            n = imageList.size() - 1;
        }
        ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n);
        WindowManager.setCurrentWindow(imageWindow);
        imageWindow.toFront();
        Menus.updateMenus();
    }

    public static void setTempCurrentImage(ImagePlus imagePlus) {
        tempCurrentImage = imagePlus;
    }

    public static Frame getFrame(String string) {
        int n = 0;
        while (n < nonImageList.size()) {
            Frame frame = (Frame)nonImageList.elementAt(n);
            if (string.equals(frame.getTitle())) {
                return frame;
            }
            ++n;
        }
        return null;
    }

    static synchronized void activateWindow(String string, MenuItem menuItem) {
        int n = 0;
        while (n < nonImageList.size()) {
            Frame frame = (Frame)nonImageList.elementAt(n);
            String string2 = frame.getTitle();
            if (string.equals(string2)) {
                frame.toFront();
                ((CheckboxMenuItem)menuItem).setState(false);
                if (Recorder.record) {
                    Recorder.record("selectWindow", string2);
                }
                return;
            }
            ++n;
        }
        int n2 = string.lastIndexOf(32);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        int n3 = 0;
        while (n3 < imageList.size()) {
            ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n3);
            String string3 = imageWindow.getImagePlus().getTitle();
            if (string.equals(string3)) {
                int n4;
                WindowManager.setCurrentWindow(imageWindow);
                imageWindow.toFront();
                int n5 = imageList.indexOf(imageWindow);
                int n6 = Menus.window.getItemCount();
                int n7 = n4 = 5 + Menus.windowMenuItems2;
                while (n7 < n6) {
                    MenuItem menuItem2 = Menus.window.getItem(n7);
                    ((CheckboxMenuItem)menuItem2).setState(n7 - n4 == n5);
                    ++n7;
                }
                if (!Recorder.record) break;
                Recorder.record("selectWindow", string3);
                break;
            }
            ++n3;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int n = 0;
            while (n < imageList.size()) {
                ImageWindow imageWindow = (ImageWindow)imageList.elementAt(n);
                ImagePlus imagePlus = imageWindow.getImagePlus();
                IJ.log(n + " " + imagePlus.getTitle() + (imageWindow == currentWindow ? "*" : ""));
                ++n;
            }
            IJ.log(" ");
        }
    }
}

