/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class IJ {
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isJava2;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    private static TextPanel logPanel;
    private static boolean notVerified;
    private static PluginClassLoader classLoader;
    private static boolean memMessageDisplayed;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imageJ, Applet applet) {
        ij = imageJ;
        IJ.applet = applet;
        progressBar = ij.getProgressBar();
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static Object runPlugIn(String string, String string2) {
        return IJ.runPlugIn("", string, string2);
    }

    static Object runPlugIn(String string, String string2, String string3) {
        if (debugMode) {
            IJ.log("runPlugin: " + string2 + " " + string3);
        }
        if (!string2.startsWith("ij") && applet == null) {
            boolean bl = IJ.altKeyDown();
            return IJ.runUserPlugIn(string, string2, string3, bl);
        }
        Object var3_4 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_4 = clazz.newInstance();
            if (var3_4 instanceof PlugIn) {
                ((PlugIn)var3_4).run(string3);
            } else {
                IJ.runFilterPlugIn(var3_4, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (IJ.getApplet() == null) {
                IJ.log("Plugin not found: " + string2);
            }
        }
        catch (InstantiationException instantiationException) {
            IJ.log("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.log("Unable to load plugin (acc)");
        }
        return var3_4;
    }

    static void runFilterPlugIn(Object object, String string, String string2) {
        ImageWindow imageWindow;
        boolean bl;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        int n = ((PlugInFilter)object).setup(string2, imagePlus);
        if ((n & 0x1000) != 0) {
            return;
        }
        if ((n & 0x200) != 0) {
            ((PlugInFilter)object).run(null);
            return;
        }
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if ((n & 0x400) != 0 && imagePlus.getRoi() == null) {
            IJ.error("Selection required");
            return;
        }
        if ((n & 0x800) != 0 && imagePlus.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        int n2 = imagePlus.getType();
        switch (n2) {
            case 0: {
                if ((n & 1) != 0) break;
                IJ.wrongType(n);
                return;
            }
            case 3: {
                if ((n & 2) != 0) break;
                IJ.wrongType(n);
                return;
            }
            case 1: {
                if ((n & 4) != 0) break;
                IJ.wrongType(n);
                return;
            }
            case 2: {
                if ((n & 8) != 0) break;
                IJ.wrongType(n);
                return;
            }
            case 4: {
                if ((n & 0x10) != 0) break;
                IJ.wrongType(n);
                return;
            }
        }
        int n3 = imagePlus.getStackSize();
        boolean bl2 = bl = (n & 0x20) != 0;
        if (!imagePlus.lock()) {
            return;
        }
        imagePlus.startTiming();
        IJ.showStatus(string + "...");
        ImageStack imageStack = null;
        if (n3 > 1) {
            imageStack = imagePlus.getStack();
        }
        int[] nArray = null;
        float[] fArray = imagePlus.getCalibration().getCTable();
        if (n3 == 1 || !bl) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            nArray = imagePlus.getMask();
            if ((n & 0x100) != 0) {
                Undo.reset();
            } else {
                Undo.setup(1, imagePlus);
                imageProcessor.snapshot();
            }
            imageProcessor.setCalibrationTable(fArray);
            ((PlugInFilter)object).run(imageProcessor);
            if ((n & 0x40) != 0) {
                imageProcessor.reset(imageProcessor.getMask());
            }
            IJ.showTime(imagePlus, imagePlus.getStartTime(), string + ": ", 1);
        } else {
            boolean bl3;
            Undo.reset();
            int n4 = imageStack.getSize();
            int n5 = imagePlus.getCurrentSlice();
            Rectangle rectangle = null;
            Roi roi = imagePlus.getRoi();
            if (roi != null && roi.getType() < 5) {
                rectangle = roi.getBoundingRect();
            }
            nArray = imagePlus.getMask();
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            double d = imageProcessor.getMinThreshold();
            double d2 = imageProcessor.getMaxThreshold();
            imageProcessor = imageStack.getProcessor(1);
            imageProcessor.setLineWidth(Line.getWidth());
            boolean bl4 = bl3 = roi != null && roi.getType() != 0 && (n & 0x40) != 0;
            if (d != -808080.0) {
                imageProcessor.setThreshold(d, d2, 2);
            }
            boolean bl5 = IJ.isWindows() && !IJ.isJava2();
            int n6 = 1;
            while (n6 <= n4) {
                imageProcessor.setPixels(imageStack.getPixels(n6));
                imageProcessor.setMask(nArray);
                imageProcessor.setRoi(rectangle);
                imageProcessor.setCalibrationTable(fArray);
                if (bl3) {
                    imageProcessor.snapshot();
                }
                ((PlugInFilter)object).run(imageProcessor);
                if (bl3) {
                    imageProcessor.reset(nArray);
                }
                if (bl5 && n6 % 10 == 0) {
                    System.gc();
                }
                IJ.showProgress((double)n6 / (double)n4);
                ++n6;
            }
            if (roi != null) {
                imagePlus.setRoi(roi);
            }
            IJ.showProgress(1.0);
            IJ.showTime(imagePlus, imagePlus.getStartTime(), string + ": ", n4);
        }
        if ((n & 0x80) == 0) {
            imagePlus.changes = true;
            if (n3 > 1 && (n2 == 1 || n2 == 2)) {
                imagePlus.getProcessor().resetMinAndMax();
            }
            imagePlus.updateAndDraw();
        }
        if ((imageWindow = imagePlus.getWindow()) != null) {
            imageWindow.running = false;
        }
        imagePlus.unlock();
    }

    static Object runUserPlugIn(String string, String string2, String string3, boolean bl) {
        PluginClassLoader pluginClassLoader;
        if (applet != null) {
            return null;
        }
        String string4 = Menus.getPlugInsPath();
        if (string4 == null) {
            return null;
        }
        if (notVerified) {
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            notVerified = false;
        }
        if (bl) {
            pluginClassLoader = new PluginClassLoader(string4);
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(string4);
            }
            pluginClassLoader = classLoader;
        }
        Object var6_6 = null;
        try {
            var6_6 = pluginClassLoader.loadClass(string2).newInstance();
            if (var6_6 instanceof PlugIn) {
                ((PlugIn)var6_6).run(string3);
            } else if (var6_6 instanceof PlugInFilter) {
                IJ.runFilterPlugIn(var6_6, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string2.indexOf(95) != -1) {
                IJ.error("Plugin not found: " + string2);
            }
        }
        catch (InstantiationException instantiationException) {
            IJ.error("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.error("Unable to load plugin (acc)");
        }
        return var6_6;
    }

    static void wrongType(int n) {
        String string = "This command requires an image of type:\n \n";
        if ((n & 1) != 0) {
            string = string + "    8-bit grayscale\n";
        }
        if ((n & 2) != 0) {
            string = string + "    8-bit color\n";
        }
        if ((n & 4) != 0) {
            string = string + "    16-bit grayscale\n";
        }
        if ((n & 8) != 0) {
            string = string + "    32-bit (float) grayscale\n";
        }
        if ((n & 0x10) != 0) {
            string = string + "    RGB color\n";
        }
        IJ.error(string);
    }

    public static void doCommand(String string) {
        if (ij != null) {
            ij.doCommand(string);
        }
    }

    public static void run(String string) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro.abort = false;
        Macro.setOptions(null);
        macroRunning = true;
        Executer executer = new Executer(string);
        executer.run();
        macroRunning = false;
        IJ.testAbort();
    }

    public static void run(String string, String string2) {
        Object object;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro.abort = false;
        Macro.setOptions(string2);
        Thread thread = Thread.currentThread();
        if (!(previousThread != null && thread == previousThread || ((String)(object = thread.getName())).startsWith("Run$_"))) {
            thread.setName("Run$_" + (String)object);
        }
        previousThread = thread;
        macroRunning = true;
        object = new Executer(string);
        ((Executer)object).run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
    }

    static void init() {
        Menus menus = new Menus(null, null);
        Prefs.load(menus, null);
        menus.addMenuBar();
    }

    private static void testAbort() {
        if (Macro.abort) {
            IJ.abort();
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String string) {
        if (ij != null) {
            ij.showStatus(string);
        }
    }

    public static void write(String string) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.append(string);
        } else {
            System.out.println(string);
        }
    }

    public static synchronized void log(String string) {
        if (logPanel == null && ij != null) {
            TextWindow textWindow = new TextWindow("Log", "", 300, 200);
            logPanel = textWindow.getTextPanel();
        }
        if (logPanel != null) {
            if (string.equals("$Closed")) {
                logPanel = null;
            } else {
                logPanel.append(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public static void setColumnHeadings(String string) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(string);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel textPanel) {
        IJ.textPanel = textPanel;
    }

    public static void noImage() {
        IJ.showMessage("No Image", "There are no images open.");
        Macro.abort();
    }

    public static void outOfMemory(String string) {
        IJ.log("<<" + string + ": out of memory>>");
        if (!memMessageDisplayed) {
            IJ.log("<<See the \"Memory\" section of the installation notes for>>");
            IJ.log("<<your OS at \"http://rsb.info.nih.gov/ij/docs/install/\".>>");
            memMessageDisplayed = true;
        }
        Macro.abort();
    }

    public static void showProgress(double d) {
        if (progressBar != null) {
            progressBar.show(d);
        }
    }

    public static void showProgress(int n, int n2) {
        if (progressBar != null) {
            progressBar.show(n, n2);
        }
    }

    public static void showMessage(String string, String string2) {
        if (ij != null) {
            new MessageDialog((Frame)ij, string, string2);
        } else {
            System.out.println(string2);
        }
    }

    public static void showMessage(String string) {
        IJ.showMessage("Message", string);
    }

    public static void error(String string) {
        if (ij != null) {
            new MessageDialog((Frame)ij, "ImageJ", string);
        } else {
            System.out.println(string);
        }
        Macro.abort();
    }

    public static boolean showMessageWithCancel(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addMessage(string2);
        genericDialog.showDialog();
        return !genericDialog.wasCanceled();
    }

    public static double getNumber(String string, double d) {
        GenericDialog genericDialog = new GenericDialog("");
        int n = (double)((int)d) == d ? 0 : 2;
        genericDialog.addNumericField(string, d, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -2.147483648E9;
        }
        double d2 = genericDialog.getNextNumber();
        if (genericDialog.invalidNumber()) {
            return d;
        }
        return d2;
    }

    public static String getString(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog("");
        genericDialog.addStringField(string, string2, 20);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return "";
        }
        return genericDialog.getNextString();
    }

    public static synchronized void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return "Memory: " + (l2 - l) / 1024L + "K";
    }

    public static void showTime(ImagePlus imagePlus, long l, String string) {
        IJ.showTime(imagePlus, l, string, 1);
    }

    static void showTime(ImagePlus imagePlus, long l, String string, int n) {
        long l2 = System.currentTimeMillis() - l;
        double d = (double)l2 / 1000.0;
        long l3 = imagePlus.getWidth() * imagePlus.getHeight();
        int n2 = (int)((double)l3 * (double)n / d);
        String string2 = n2 > 1000000000 ? "" : (n2 < 1000000 ? ", " + n2 + " pixels/second" : ", " + IJ.d2s((double)n2 / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(string + d + " seconds" + string2);
    }

    public static String d2s(double d) {
        return IJ.d2s(d, 2);
    }

    public static String d2s(double d, int n) {
        boolean bl;
        if (d == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.round(d * Math.pow(10.0, n));
        double d3 = d2 / Math.pow(10.0, n);
        if (bl) {
            d3 = -d3;
        }
        if (n != dfDigits) {
            switch (n) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                }
            }
        }
        String string = df.format(d3);
        return string;
    }

    public static void register(Class clazz) {
        if (ij != null) {
            ij.register(clazz);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static void setKeyDown(int n) {
        switch (n) {
            case 18: {
                altDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1, -1, -1);
            }
        }
    }

    public static void setKeyUp(int n) {
        switch (n) {
            case 18: {
                altDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1, -1, -1);
            }
        }
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return IJ.isMacintosh() && IJ.isJava2();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isJava2() {
        return isJava2;
    }

    public static boolean versionLessThan(String string) {
        boolean bl;
        boolean bl2 = bl = "1.30s".compareTo(string) < 0;
        if (bl) {
            IJ.error("This plugin or macro requires ImageJ " + string + " or later.");
        }
        return bl;
    }

    public static int setupDialog(ImagePlus imagePlus, int n) {
        if (imagePlus == null || ij != null && IJ.ij.hotkey || hideProcessStackDialog) {
            return n;
        }
        int n2 = imagePlus.getStackSize();
        if (n2 > 1) {
            String string = Macro.getOptions();
            if (string != null) {
                if (string.indexOf("stack ") >= 0) {
                    return n + 32;
                }
                return n;
            }
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + n2 + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (yesNoCancelDialog.cancelPressed()) {
                return 4096;
            }
            if (yesNoCancelDialog.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return n + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return n;
    }

    public static void makeRectangle(int n, int n2, int n3, int n4) {
        IJ.getImage().setRoi(n, n2, n3, n4);
    }

    public static void makeOval(int n, int n2, int n3, int n4) {
        IJ.getImage().setRoi(new OvalRoi(n, n2, n3, n4));
    }

    public static void makeLine(int n, int n2, int n3, int n4) {
        IJ.getImage().setRoi(new Line(n, n2, n3, n4));
    }

    public static void setMinAndMax(double d, double d2) {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().setMinAndMax(d, d2);
        imagePlus.updateAndDraw();
    }

    public static void resetMinAndMax() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().resetMinAndMax();
        imagePlus.updateAndDraw();
    }

    public static void setThreshold(double d, double d2) {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().setThreshold(d, d2, 0);
        imagePlus.updateAndDraw();
    }

    public static void resetThreshold() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().resetThreshold();
        imagePlus.updateAndDraw();
    }

    public static void selectWindow(int n) {
        ImagePlus imagePlus = WindowManager.getImage(n);
        if (imagePlus == null) {
            IJ.showMessage("Macro Error", "Image " + n + " not found or no images are open.");
            IJ.abort();
        }
        String string = imagePlus.getTitle();
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow != null) {
            imageWindow.toFront();
            WindowManager.setWindow(imageWindow);
            long l = System.currentTimeMillis();
            do {
                IJ.wait(10);
                imagePlus = WindowManager.getCurrentImage();
                if (imagePlus == null || !imagePlus.getTitle().equals(string)) continue;
                return;
            } while (System.currentTimeMillis() - l <= 2000L);
            WindowManager.setCurrentWindow(imageWindow);
            return;
        }
    }

    public static void selectWindow(String string) {
        Frame frame = WindowManager.getFrame(string);
        if (frame != null && !(frame instanceof ImageWindow)) {
            IJ.selectWindow(frame);
            return;
        }
        int[] nArray = WindowManager.getIDList();
        int n = nArray != null ? nArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[n2]);
            if (imagePlus != null && imagePlus.getTitle().equals(string)) {
                IJ.selectWindow(imagePlus.getID());
                return;
            }
            ++n2;
        }
        IJ.showMessage("Macro Error", "No window with the title \"" + string + "\" found.");
        IJ.abort();
    }

    static void selectWindow(Frame frame) {
        frame.toFront();
        long l = System.currentTimeMillis();
        do {
            IJ.wait(10);
            if (WindowManager.getFrontWindow() != frame) continue;
            return;
        } while (System.currentTimeMillis() - l <= 1000L);
        WindowManager.setWindow(frame);
    }

    public static void setForegroundColor(int n, int n2, int n3) {
        IJ.setColor(n, n2, n3, true);
    }

    public static void setBackgroundColor(int n, int n2, int n3) {
        IJ.setColor(n, n2, n3, false);
    }

    static void setColor(int n, int n2, int n3, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        Color color = new Color(n, n2, n3);
        if (bl) {
            Toolbar.setForegroundColor(color);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.getProcessor().setColor(color);
            }
        } else {
            Toolbar.setBackgroundColor(color);
        }
    }

    public static void setTool(int n) {
        Toolbar.getInstance().setTool(n);
    }

    public static int doWand(int n, int n2) {
        ImagePlus imagePlus = IJ.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Wand wand = new Wand(imageProcessor);
        double d = imageProcessor.getMinThreshold();
        if (d == -808080.0) {
            wand.autoOutline(n, n2);
        } else {
            wand.autoOutline(n, n2, (int)d, (int)imageProcessor.getMaxThreshold());
        }
        if (wand.npoints > 0) {
            PolygonRoi polygonRoi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 4);
            imagePlus.setRoi(polygonRoi);
        }
        return wand.npoints;
    }

    public static void setPasteMode(String string) {
        string = string.toLowerCase(Locale.US);
        int n = 0;
        if (string.startsWith("ble") || string.startsWith("ave")) {
            n = 7;
        } else if (string.startsWith("diff")) {
            n = 8;
        } else if (string.startsWith("tran")) {
            n = 2;
        } else if (string.startsWith("and")) {
            n = 9;
        } else if (string.startsWith("or")) {
            n = 10;
        } else if (string.startsWith("xor")) {
            n = 11;
        } else if (string.startsWith("sub")) {
            n = 4;
        } else if (string.startsWith("add")) {
            n = 3;
        } else if (string.startsWith("div")) {
            n = 6;
        } else if (string.startsWith("mul")) {
            n = 5;
        }
        Roi.setPasteMode(n);
    }

    public static ImagePlus getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            IJ.abort();
        }
        return imagePlus;
    }

    static void abort() {
        throw new RuntimeException("Macro canceled");
    }

    static {
        notVerified = true;
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        String string = System.getProperty("java.version");
        isJava2 = !string.startsWith("1.1") && !string.startsWith("3.");
        df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        dfDigits = 2;
    }
}

