/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.util.Locale;

abstract class AnElement {
    static int InvalidType = -10;
    static int ByteType = 0;
    static int IntegerType = 1;
    static int FloatType = 2;
    static int DoubleType = 3;
    static int ComplexType = 4;
    static int ShortType = 5;
    static int LongType = 6;
    static int NumTypes = 7;
    static String[] TypeNames = new String[]{"Byte", "Integer", "Float", "Double", "Complex", "Short", "Long"};
    static String[] UTypeNames = new String[]{"Unsigned Byte", "Unsigned Integer", "Float", "Double", "Complex", "Unsigned Short", "Unsigned Long"};
    public int[] Sizes;
    public double[] Scales;
    public double ScaleV;
    public double OffsetV;
    public double[] Offsets;
    public String[] Units;
    public String[] Names;
    public String UnitV;
    public String NameV;
    static int DataType;
    double MaxValue;
    double scaleB = 1.0;
    double scaleI = 1.0;
    double shift = 0.0;
    double Min = 0.0;
    double Max = 0.0;
    AnElement DataToHistogramX = null;
    AnElement DataToHistogramY = null;
    AnElement DataToHistogramZ = null;
    public NumberFormat nf;

    AnElement(int n, int n2, int n3, double d) {
        this.MaxValue = d;
        this.Sizes = new int[3];
        this.Units = new String[5];
        this.Names = new String[5];
        this.Sizes[0] = n;
        this.Sizes[1] = n2;
        this.Sizes[2] = n3;
        this.Scales = new double[5];
        this.Offsets = new double[5];
        this.Scales[0] = 1.0;
        this.Scales[1] = 1.0;
        this.Scales[2] = 1.0;
        this.Scales[3] = 1.0;
        this.Scales[4] = 1.0;
        this.ScaleV = 1.0;
        this.OffsetV = 0.0;
        this.Offsets[0] = 0.0;
        this.Offsets[1] = 0.0;
        this.Offsets[2] = 0.0;
        this.Offsets[3] = 0.0;
        this.Offsets[4] = 0.0;
        this.Names[0] = "X";
        this.Names[1] = "Y";
        this.Names[2] = "Z";
        this.Names[3] = "Element";
        this.Names[4] = "Time";
        this.Units[0] = "pixels";
        this.Units[1] = "pixels";
        this.Units[2] = "pixels";
        this.Units[3] = "elements";
        this.Units[4] = "steps";
        this.NameV = "intensity";
        this.UnitV = "a.u.";
        DataType = InvalidType;
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setGroupingUsed(false);
    }

    abstract void Clear();

    abstract void DeleteData();

    abstract void SetValueAt(int var1, int var2, int var3, double var4);

    abstract int GetStdByteNum();

    int GetStdBitNum() {
        return 8 * this.GetStdByteNum();
    }

    abstract double GetRawValueAt(int var1, int var2, int var3);

    abstract double GetValueAt(int var1, int var2, int var3);

    String GetValueStringAt(int n, int n2, int n3) {
        return this.nf.format(this.GetValueAt(n, n2, n3));
    }

    boolean InsideBounds(int n, int n2, int n3) {
        if (n >= this.Sizes[0]) {
            return false;
        }
        if (n2 >= this.Sizes[1]) {
            return false;
        }
        if (n3 >= this.Sizes[2]) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        return n3 >= 0;
    }

    double GetValueWithBounds(int n, int n2, int n3) {
        if (n >= this.Sizes[0]) {
            n = this.Sizes[0] - 1;
        }
        if (n2 >= this.Sizes[1]) {
            n2 = this.Sizes[1] - 1;
        }
        if (n3 >= this.Sizes[2]) {
            n3 = this.Sizes[2] - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return this.GetValueAt(n, n2, n3);
    }

    abstract int GetIntValueAt(int var1, int var2, int var3);

    int GetIntValueWithBounds(int n, int n2, int n3) {
        if (n >= this.Sizes[0]) {
            n = this.Sizes[0] - 1;
        }
        if (n2 >= this.Sizes[1]) {
            n2 = this.Sizes[1] - 1;
        }
        if (n3 >= this.Sizes[2]) {
            n3 = this.Sizes[2] - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return this.GetIntValueAt(n, n2, n3);
    }

    abstract int GetByteValueAt(int var1, int var2, int var3);

    abstract void ConvertSliceFromSimilar(int var1, int var2, Object var3, int var4, int var5);

    abstract void ConvertSliceFromByte(int var1, int var2, byte[] var3, int var4, int var5);

    abstract void ConvertSliceFromRGB(int var1, int var2, int[] var3, int var4, int var5, int var6);

    abstract void CopySliceToSimilar(int var1, Object var2);

    void AdvanceReadMode() {
    }

    void SetReadMode(int n) {
    }

    void SetScales(AnElement anElement) {
        this.Scales[0] = anElement.Scales[0];
        this.Scales[1] = anElement.Scales[1];
        this.Scales[2] = anElement.Scales[2];
        this.Scales[3] = anElement.Scales[3];
        this.Scales[4] = anElement.Scales[4];
        this.Offsets[0] = anElement.Offsets[0];
        this.Offsets[1] = anElement.Offsets[1];
        this.Offsets[2] = anElement.Offsets[2];
        this.Offsets[3] = anElement.Offsets[3];
        this.Offsets[4] = anElement.Offsets[4];
        this.ScaleV = anElement.ScaleV;
        this.OffsetV = anElement.OffsetV;
        this.NameV = anElement.NameV;
        this.UnitV = anElement.UnitV;
        this.Units = anElement.Units;
        this.Names = anElement.Names;
    }

    void SetScales(double d, double d2, String string, String string2) {
        this.ScaleV = d;
        this.OffsetV = d2;
        this.NameV = string;
        this.UnitV = string2;
    }

    void SetScales(double[] dArray, double[] dArray2, double d, double d2) {
        this.Scales = dArray;
        this.Offsets = dArray2;
        this.ScaleV = d;
        this.OffsetV = d2;
    }

    void Add(AnElement anElement) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    this.SetValueAt(k, j, i, this.GetValueAt(k, j, i) + anElement.GetValueAt(k, j, i));
                }
            }
        }
    }

    void Sub(AnElement anElement) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    this.SetValueAt(k, j, i, this.GetValueAt(k, j, i) - anElement.GetValueAt(k, j, i));
                }
            }
        }
    }

    void Mul(AnElement anElement) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    this.SetValueAt(k, j, i, this.GetValueAt(k, j, i) * anElement.GetValueAt(k, j, i));
                }
            }
        }
    }

    void Div(AnElement anElement) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    if (anElement.GetValueAt(k, j, i) != 0.0) {
                        this.SetValueAt(k, j, i, this.GetValueAt(k, j, i) / anElement.GetValueAt(k, j, i));
                        continue;
                    }
                    if (this.GetValueAt(k, j, i) == 0.0) {
                        this.SetValueAt(k, j, i, 0.0);
                        continue;
                    }
                    this.SetValueAt(k, j, i, 1.0E32);
                }
            }
        }
    }

    static double ComputeIntMaxScale(int n, int n2, int n3, double d) {
        double d2 = 0.0;
        double d3 = d / 2.0 * (d / 2.0) / Math.log(2.0);
        for (int i = -n3; i <= n3; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n; k <= n; ++k) {
                    double d4 = k * k + j * j + i * i;
                    d2 += Math.exp(-d4 / d3);
                }
            }
        }
        if (d2 > 0.0) {
            return 1.0 / d2;
        }
        return 0.0;
    }

    void SubtractGauss(double d, double d2, double d3, double d4, int n, int n2, int n3, double d5) {
        double d6;
        double d7;
        int n4;
        int n5 = (int)(d + 0.5);
        int n6 = (int)(d2 + 0.5);
        int n7 = (int)(d3 + 0.5);
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = d5 / 2.0 * (d5 / 2.0) / Math.log(2.0);
        double d11 = this.GetValueAt(n5, n6, n7);
        for (int i = n7 - n3; i <= n7 + n3; ++i) {
            for (int j = n6 - n2; j <= n6 + n2; ++j) {
                for (n4 = n5 - n; n4 <= n5 + n; ++n4) {
                    d7 = ((double)n4 - d) * ((double)n4 - d) + ((double)j - d2) * ((double)j - d2) + ((double)i - d3) * ((double)i - d3);
                    d8 += Math.exp(-d7 / d10);
                    d6 = this.GetValueAt(n4, j, i);
                    d9 += d6;
                    if (!(d6 < d11)) continue;
                    d11 = d6;
                }
            }
        }
        double d12 = (d9 - d11 * (double)(n * 2 + 1) * (double)(n2 * 2 + 1) * (double)(n3 * 2 + 1)) / d8;
        for (n4 = n7 - n3; n4 <= n7 + n3; ++n4) {
            for (int i = n6 - n2; i <= n6 + n2; ++i) {
                for (int j = n5 - n; j <= n5 + n; ++j) {
                    d7 = ((double)j - d) * ((double)j - d) + ((double)i - d2) * ((double)i - d2) + ((double)n4 - d3) * ((double)n4 - d3);
                    d6 = this.GetValueAt(j, i, n4) - d12 * Math.exp(-d7 / d10);
                    this.SetValueAt(j, i, n4, d6);
                }
            }
        }
    }

    void CopyVal(AnElement anElement) {
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    this.SetValueAt(k, j, i, anElement.GetValueAt(k, j, i));
                }
            }
        }
    }

    void SetScaleShift(double d, double d2) {
        this.scaleB = 256.0 / (d2 - d);
        this.scaleI = 32769.0 / (d2 - d);
        this.shift = d;
    }

    void SetMinMax() {
        this.Max = this.GetRawValueAt(0, 0, 0);
        this.Min = this.GetRawValueAt(0, 0, 0);
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    double d = this.GetRawValueAt(k, j, i);
                    if (d > this.Max) {
                        this.Max = d;
                    }
                    if (!(d < this.Min)) continue;
                    this.Min = d;
                }
            }
        }
    }

    double ROIMaximum(ROI rOI) {
        double d = -1.0E30;
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    if (!rOI.InROIRange(k, j, i) || !(this.GetRawValueAt(k, j, i) > d)) continue;
                    d = this.GetRawValueAt(k, j, i);
                }
            }
        }
        return d;
    }

    double ROIMinimum(ROI rOI) {
        double d = 1.0E30;
        for (int i = 0; i < this.Sizes[2]; ++i) {
            for (int j = 0; j < this.Sizes[1]; ++j) {
                for (int k = 0; k < this.Sizes[0]; ++k) {
                    if (!rOI.InROIRange(k, j, i) || !(this.GetRawValueAt(k, j, i) < d)) continue;
                    d = this.GetRawValueAt(k, j, i);
                }
            }
        }
        return d;
    }

    void GenerateMask(ROI rOI, AnElement anElement, AnElement anElement2, boolean bl) {
        if (!bl) {
            for (int i = 0; i < this.Sizes[2]; ++i) {
                for (int j = 0; j < this.Sizes[1]; ++j) {
                    for (int k = 0; k < this.Sizes[0]; ++k) {
                        if (!rOI.InROIRange(k, j, i)) continue;
                        if (anElement.GetIntValueAt(k, j, i) > 0) {
                            this.SetValueAt(k, j, i, 1.0);
                            continue;
                        }
                        this.SetValueAt(k, j, i, 0.0);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.Sizes[2]; ++i) {
                for (int j = 0; j < this.Sizes[1]; ++j) {
                    for (int k = 0; k < this.Sizes[0]; ++k) {
                        if (!rOI.InROIRange(k, j, i)) continue;
                        if (anElement.GetIntValueAt(k, j, i) > 0) {
                            this.SetValueAt(k, j, i, anElement2.GetRawValueAt(k, j, i));
                            continue;
                        }
                        this.SetValueAt(k, j, i, 0.0);
                    }
                }
            }
        }
    }

    void ComputeHistMask(AnElement anElement, ROI rOI) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.DataToHistogramX == null) {
            System.out.println("Error : No X-direction present for Histogram !\n");
            return;
        }
        for (int i = 0; i < this.DataToHistogramX.Sizes[2]; ++i) {
            for (int j = 0; j < this.DataToHistogramX.Sizes[1]; ++j) {
                for (int k = 0; k < this.DataToHistogramX.Sizes[0]; ++k) {
                    if (this.DataToHistogramX != null) {
                        d = this.DataToHistogramX.GetValueAt(k, j, i);
                    }
                    if (this.DataToHistogramY != null) {
                        d2 = this.DataToHistogramY.GetValueAt(k, j, i);
                    }
                    if (this.DataToHistogramZ != null) {
                        d3 = this.DataToHistogramZ.GetValueAt(k, j, i);
                    }
                    if (rOI.InROIRange((int)((d - this.Offsets[0]) / this.Scales[0] + 0.5), (int)((d2 - this.Offsets[1]) / this.Scales[1] + 0.5), (int)((d3 - this.Offsets[2]) / this.Scales[2] + 0.5))) {
                        anElement.SetValueAt(k, j, i, 1.0);
                        continue;
                    }
                    anElement.SetValueAt(k, j, i, 0.0);
                }
            }
        }
        anElement.Max = 1.0;
        anElement.Min = 0.0;
        anElement.MaxValue = 5.0;
    }

    public int ComputeHistogram(AnElement anElement, ROI rOI) {
        this.NameV = "frequency";
        this.UnitV = "cnts";
        System.out.println("Computing Histogram with Hscale (X,Y,Z): " + this.Scales[0] + ", " + this.Scales[1] + ", " + this.Scales[2] + "\n");
        System.out.println("Offsets: " + this.Offsets[0] + ", " + this.Offsets[1] + ", " + this.Offsets[2] + "\n");
        if (this.DataToHistogramX == null) {
            System.out.println("Error: No data connected to this histogram");
            return 0;
        }
        this.Units[0] = this.DataToHistogramX.UnitV;
        this.Names[0] = this.DataToHistogramX.NameV;
        if (this.DataToHistogramY != null) {
            this.Units[1] = this.DataToHistogramY.UnitV;
            this.Names[1] = this.DataToHistogramY.NameV;
        }
        if (this.DataToHistogramZ != null) {
            this.Units[2] = this.DataToHistogramZ.UnitV;
            this.Names[2] = this.DataToHistogramZ.NameV;
        }
        int n = 0;
        for (int i = 0; i < this.DataToHistogramX.Sizes[2]; ++i) {
            for (int j = 0; j < this.DataToHistogramX.Sizes[1]; ++j) {
                for (int k = 0; k < this.DataToHistogramX.Sizes[0]; ++k) {
                    double d;
                    if (!rOI.InROIRange(k, j, i) || anElement.GetIntValueAt(k, j, i) <= 0) continue;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    if (this.DataToHistogramX != null) {
                        d = this.DataToHistogramX.GetValueAt(k, j, i);
                        n2 = (int)((d - this.Offsets[0]) / this.Scales[0]);
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        if (n2 >= this.Sizes[0]) {
                            n2 = this.Sizes[0] - 1;
                        }
                    }
                    if (this.DataToHistogramY != null) {
                        d = this.DataToHistogramY.GetValueAt(k, j, i);
                        n3 = (int)((d - this.Offsets[1]) / this.Scales[1]);
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        if (n3 >= this.Sizes[1]) {
                            n3 = this.Sizes[1] - 1;
                        }
                    }
                    if (this.DataToHistogramZ != null) {
                        d = this.DataToHistogramZ.GetValueAt(k, j, i);
                        n4 = (int)((d - this.Offsets[2]) / this.Scales[2]);
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (n4 >= this.Sizes[2]) {
                            n4 = this.Sizes[2] - 1;
                        }
                    }
                    int n5 = (int)this.GetRawValueAt(n2, n3, n4) + 1;
                    this.SetValueAt(n2, n3, n4, n5);
                    if (n5 <= n) continue;
                    n = n5;
                }
            }
        }
        System.out.println("max : " + n + "\n");
        this.Max = n;
        this.Min = 0.0;
        this.MaxValue = this.Max;
        this.SetScaleShift(0.0, this.Max);
        return n;
    }
}

