/*
 * Filename: dip_chaincode.h
 *
 * Defines and functions for the chaincode datastructure
 *
 * AUTHOR
 *    Geert van Kempen, Unilever Research Vlaardingen, 1999
 */

#ifndef DIP_CHAIN_CODE
#define DIP_CHAIN_CODE
#ifdef __cplusplus
extern "C" {
#endif

typedef struct _dip_chain
{
	dip_int code;
   dip_int border;
	struct _dip_chain *next;
} dip_Chain;

typedef struct
{
   void *chaincode;
} dip__ChainCode, *dip_ChainCode;

typedef struct
{
	dip_int size;
	dip_ChainCode *array;
} dip__ChainCodeArray, *dip_ChainCodeArray;

typedef struct
{
	dip_float maxDiameter;
	dip_float minDiameter;
	dip_float maxPerpendicular; /* the width of the object perpendicular */
	dip_float maxAngle;         /* to minDiameter                        */
	dip_float minAngle;
} dip_Feret;

DIP_ERROR dip_ImageChainCode     ( dip_Image, dip_int, dip_IntegerArray,
										     dip_ChainCodeArray *, dip_Resources );

DIP_ERROR dip_ChainCodeNew       ( dip_ChainCode *, dip_Resources );
DIP_ERROR dip_ChainCodeArrayNew  ( dip_ChainCodeArray *, dip_int,
                                   dip_Resources);
DIP_ERROR dip_ChainCodeFree      ( dip_ChainCode * );
DIP_ERROR dip_ChainCodeArrayFree ( dip_ChainCodeArray *);

DIP_ERROR dip_ChainCodeGetSize         ( dip_ChainCode, dip_int * );
DIP_ERROR dip_ChainCodeGetChains       ( dip_ChainCode, dip_Chain ** );
DIP_ERROR dip_ChainCodeGetStart        ( dip_ChainCode, dip_int *, dip_int * );
DIP_ERROR dip_ChainCodeGetLabel        ( dip_ChainCode, dip_int * );
DIP_ERROR dip_ChainCodeGetConnectivity ( dip_ChainCode, dip_int * );
DIP_ERROR dip_ChainCodeGetLength       ( dip_ChainCode, dip_float * );
DIP_ERROR dip_ChainCodeGetFeret        ( dip_ChainCode, dip_float,
													  dip_Feret * );
DIP_ERROR dip_ChainCodeGetLongestRun   ( dip_ChainCode, dip_int * );

#ifdef __cplusplus
}
#endif
#endif
