#ifndef DIP_ARCH_H
#define DIP_ARCH_H

#define DIP_ARCH Cygwin

/* The unsigned integer types (uint) */
typedef unsigned char dip_uint8;
typedef unsigned short dip_uint16;
typedef unsigned int dip_uint32;

/* The signed integer types (sint) */
typedef signed char dip_sint8;
typedef signed short dip_sint16;
typedef signed int dip_sint32;

#define DIP_DTI_INT_IS_INT32


/* The generic integer types */
typedef signed int dip_int;
typedef signed int dip_dim;
typedef signed int dip_sint;
typedef unsigned int dip_uint;

#define _POSIX_SOURCE 1

#define DIP_PORT_HAS_TIME

#ifdef DIP_DLL_CREATE
#define DIP_EXPORT __declspec(dllexport)
#else
#define DIP_EXPORT __declspec(dllimport)
#endif

#ifdef DIPIO_DLL_CREATE
#define DIPIO_EXPORT __declspec(dllexport)
#else
#define DIPIO_EXPORT __declspec(dllimport)
#endif

#ifdef DML_DLL_CREATE
#define DML_EXPORT __declspec(dllexport)
#else
#define DML_EXPORT __declspec(dllimport)
#endif

#define DIP_ERROR DIP_EXPORT dip_Error
#define DIPIO_ERROR DIPIO_EXPORT dip_Error

#define DIPIO_DIRECTORY_SEPARATOR '\\'
#define DIPIO_EXTENSION_SEPARATOR '.'

#endif
