%REAL   The real part of pixel values.
%   REAL(B) returns the real part of each pixel in B.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% 13 March 2006: Avoid calling DIP_IMAGE, it squeezes data.

function out = real(in)
if ~isscalar(in), error('Parameter 1 is an array of images.'); end
if strcmp(in.dip_type(2:end),'complex')
   %out = dip_image(real(in.data)); % squeezes image!
   out = in;
   out.data = real(in.data);
   out.dip_type = [in.dip_type(1),'float'];
else % do nothing!
   out = in;
end
