%[IN1,IN2,ARRAYOP] = DOARRAYINPUTS(IN1,IN2)
%    Checks the input images. If either one is an image array, ARRAYOP is
%    non-zero. IN1 and IN2 are converted to dip_image objects iff ARRAYOP
%    is non-zero. If ARRAYOP is zero, IN1 and IN2 are returned without
%    change. Furthermore, if any or both are of type DIP_IMAGE_ARRAY, an
%    error is produced if not all the images are of the same size.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, July 2000.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)

function [in1,in2,arrayop] = doarrayinputs(in1,in2)
if nargin ~= 2, error('Erroneus input.'); end
if nargout ~= 3, error('Erroneus output.'); end
in1array = 0;
in2array = 0;
arrayop = 1;
if di_isdipimobj(in1)
   if ~isscalar(in1)
      in1array = 1;
   end
end
if di_isdipimobj(in2)
   if ~isscalar(in2)
      in2array = 1;
   end
end
arrayop = in1array | in2array;
if ~arrayop
   return
end
if in1array
   if ~istensor(in1)
      error('Parameter 1 is an array of images, but not a tensor.')
   end
   if ~di_isdipimobj(in2)
      in2 = create_tensor(in2);
   end
end
if in2array
   if ~istensor(in2)
      error('Parameter 2 is an array of images, but not a tensor.')
   end
   if ~di_isdipimobj(in1)
      in1 = create_tensor(in1);
   end
end
% Check image sizes.
s1 = size(in1(1).data); s2 = size(in2(1).data);
if (prod(s1) ~= 1) & (prod(s2) ~= 1)
   if length(s1)~=length(s2), error('Dimensionalities do not match.'); end
   if any(s1~=s2), error('Sizes do not match.'); end
% else: let one or both images be scalar.
end
% We don't check tensor sizes, since we don't know what operations will
% be carried out.


function out = create_tensor(in)
out = dip_image('array',size(in));
for ii=1:prod(size(in))
   out(ii) = dip_image(in(ii));
end
