%POWER   Overloaded operator for a.^b.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 6 November 2000: Also overloaded for tensor images.
% Jan 2004, Added possibility of in2 being a dip_image or array
% April 2004, added support for complex images (BR)
% February 2008: Adding pixel dimensions and units to dip_image. (BR)
% 6 March 2008: Fixed to work again with image arrays. (CL)

function out = power(in1,in2)

if ~di_isdipimobj(in1)
   if isnumeric(in1)
      in1 = dip_image(in1);
   else
      error('Please don''t elevate just any object to the power of a dip_image!')
   end
end
if ~isnumeric(in2) | prod(size(in2))~=1
   in2 = dip_image(in2);
   if ~isscalar(in2)
      error('Power must be a scalar or scalar image.');
   end
   if ~isequal (size(in1(1).data),size(in2(1).data))
      error('Sizes do not match.');
   end
   %in2 is also a dip_image, do point-by-point power
end
out = in1;
col = in1(1).color;
out_phys = in1(1).physDims;
for ii=1:prod(imarsize(in1))
   if strcmp(in1(ii).dip_type,'dfloat')
      out_type = 'dfloat';
   elseif strcmp(in1(ii).dip_type,'scomplex') | strcmp(in1(ii).dip_type,'dcomplex')
      out_type = in1(ii).dip_type;
   else
      out_type = 'sfloat';      
   end
   if mod(in2,1) & any(in1(ii)<0)
      out_type = [out_type(1),'complex'];
   end
   if isnumeric(in2)
      exponent = double(in2);
   else 
      exponent = in2(ii).data; 
   end
   try
      out(ii) = compute2('power',in1(ii).data,exponent,in1(ii).dims,out_type,out_phys);
   catch
      error(di_firsterr)
   end
   out(ii).color = col;
end
