%NOT   Overloaded operator for ~a.

% (C) Copyright 1999-2008               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, April 2000.
% 15 September 2001: We don't need to use COMPUTE1 for logical operators.
% 15 November 2002: Fixed binary images to work in MATLAB 6.5 (R13)
% February 2008: Adding pixel dimensions and units to dip_image. (BR)

function out = not(in)
try
   [in,dims,out_type,out_phys] = do1input(in);
   out = dip_image;
   out.data = uint8(+(~in));
      % ~IN is not 'uint8' if IN1 is 'double'.
   out.dims = dims;
   out.dip_type = 'bin';
   out.physDims = out_phys;
catch
   error(di_firsterr)
end
