%IMAG   The imaginary part of pixel values.
%   IMAG(B) returns the imaginary part of each pixel in B.

% (C) Copyright 1999-2007               Pattern Recognition Group
%     All rights reserved               Faculty of Applied Physics
%                                       Delft University of Technology
%                                       Lorentzweg 1
%                                       2628 CJ Delft
%                                       The Netherlands
%
% Cris Luengo, May 2000.
% 13 March 2006: Avoid calling DIP_IMAGE, it squeezes data.

function out = imag(in)
if ~isscalar(in), error('Parameter 1 is an array of images.'); end
if strcmp(in.dip_type(2:end),'complex')
   %out = dip_image(imag(in.data)); % squeezes image!
   out = in;
   out.data = imag(in.data);
   out.dip_type = [in.dip_type(1),'float'];
else % return empty image
   out = dip_image(di_create(size(in.data),di_mattype(in.dip_type)));
   out.dims = in.dims;
end
