/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener {
    private TextPanel textPanel;

    public TextWindow(String string, String string2, int n, int n2) {
        this(string, "", string2, n, n2);
    }

    public TextWindow(String string, String string2, String string3, int n, int n2) {
        super(string);
        Image image;
        this.enableEvents(64L);
        this.textPanel = new TextPanel(string);
        this.textPanel.setTitle(string);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(string2);
        this.textPanel.append(string3);
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null && (image = imageJ.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.addFocusListener(this);
        this.addMenuBar();
        WindowManager.addWindow(this);
        ((Component)this).setSize(n, n2);
        GUI.center(this);
        this.show();
    }

    public TextWindow(String string, int n, int n2) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.add("Center", this.textPanel);
        if (this.openFile(string)) {
            WindowManager.addWindow(this);
            ((Component)this).setSize(n, n2);
            this.show();
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add(new MenuItem("Save As..."));
        menu.addActionListener(this);
        menuBar.add(menu);
        menu = new Menu("Edit");
        menu.add(new MenuItem("Cut"));
        menu.add(new MenuItem("Copy"));
        menu.add(new MenuItem("Copy All"));
        menu.add(new MenuItem("Clear"));
        menu.add(new MenuItem("Select All"));
        if (this.getTitle().equals("Results")) {
            menu.addSeparator();
            menu.add(new MenuItem("Clear Results"));
            menu.add(new MenuItem("Summarize"));
            menu.add(new MenuItem("Set Measurements..."));
        }
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
    }

    public void append(String string) {
        this.textPanel.append(string);
    }

    public void setFont(Font font) {
        this.textPanel.setFont(font);
    }

    boolean openFile(String string) {
        OpenDialog openDialog = new OpenDialog("Open Text File...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return false;
        }
        string = string2 + string3;
        IJ.showStatus("Opening: " + string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2 + string3));
            this.load(bufferedReader);
            bufferedReader.close();
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return true;
        }
        this.textPanel.setTitle(string3);
        this.setTitle(string3);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            this.textPanel.appendLine(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.textPanel.doCommand(string);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        int n = windowEvent.getID();
        if (n == 201) {
            this.close();
        } else if (n == 205) {
            WindowManager.setWindow(this);
        }
    }

    public void close() {
        if (this.getTitle().equals("Results")) {
            if (!Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
        }
        if (this.getTitle().equals("Log")) {
            IJ.debugMode = false;
            IJ.log("$Closed");
        }
        ((Component)this).setVisible(false);
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void focusGained(FocusEvent focusEvent) {
        WindowManager.setWindow(this);
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

