/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class ByteBlitter
implements Blitter {
    private ByteProcessor ip;
    private int width;
    private int height;
    private byte[] pixels;
    private int transparent = 255;

    public ByteBlitter(ByteProcessor byteProcessor) {
        this.ip = byteProcessor;
        this.width = byteProcessor.getWidth();
        this.height = byteProcessor.getHeight();
        this.pixels = (byte[])byteProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
        this.transparent = this.ip.getBestIndex(color);
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4;
        int n5;
        byte[] byArray;
        int n6;
        int n7 = imageProcessor.getWidth();
        int n8 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n7, n8);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        if (imageProcessor instanceof ColorProcessor) {
            int[] nArray = (int[])imageProcessor.getPixels();
            n6 = imageProcessor.getWidth() * imageProcessor.getHeight();
            byArray = new byte[n6];
            if (this.ip.isInvertedLut()) {
                n5 = 0;
                while (n5 < n6) {
                    byArray[n5] = (byte)(255 - nArray[n5] & 0xFF);
                    ++n5;
                }
            } else {
                n4 = 0;
                while (n4 < n6) {
                    byArray[n4] = (byte)(nArray[n4] & 0xFF);
                    ++n4;
                }
            }
        } else {
            byArray = (byte[])imageProcessor.getPixels();
        }
        rectangle = rectangle.intersection(rectangle2);
        int n9 = n < 0 ? -n : 0;
        int n10 = n2 < 0 ? -n2 : 0;
        n5 = rectangle.y;
        while (n5 < rectangle.y + rectangle.height) {
            int n11 = (n5 - n2) * n7 + (rectangle.x - n);
            int n12 = n5 * this.width + rectangle.x;
            switch (n3) {
                case 0: {
                    n4 = rectangle.width;
                    while (--n4 >= 0) {
                        this.pixels[n12++] = byArray[n11++];
                    }
                    break;
                }
                case 1: {
                    int n13 = rectangle.width;
                    while (--n13 >= 0) {
                        this.pixels[n12++] = (byte)(255 - byArray[n11++] & 0xFF);
                    }
                    break;
                }
                case 2: {
                    int n14 = rectangle.width;
                    while (--n14 >= 0) {
                        int n15;
                        n6 = (n15 = byArray[n11++] & 0xFF) == this.transparent ? this.pixels[n12] : n15;
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 3: {
                    int n16 = rectangle.width;
                    while (--n16 >= 0) {
                        if ((n6 = (byArray[n11++] & 0xFF) + (this.pixels[n12] & 0xFF)) > 255) {
                            n6 = 255;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 7: {
                    int n17 = rectangle.width;
                    while (--n17 >= 0) {
                        n6 = ((byArray[n11++] & 0xFF) + (this.pixels[n12] & 0xFF)) / 2;
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 4: {
                    int n18 = rectangle.width;
                    while (--n18 >= 0) {
                        if ((n6 = (this.pixels[n12] & 0xFF) - (byArray[n11++] & 0xFF)) < 0) {
                            n6 = 0;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 8: {
                    int n19 = rectangle.width;
                    while (--n19 >= 0) {
                        if ((n6 = (this.pixels[n12] & 0xFF) - (byArray[n11++] & 0xFF)) < 0) {
                            n6 = -n6;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 5: {
                    int n20 = rectangle.width;
                    while (--n20 >= 0) {
                        if ((n6 = (byArray[n11++] & 0xFF) * (this.pixels[n12] & 0xFF)) > 255) {
                            n6 = 255;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 6: {
                    int n21 = rectangle.width;
                    while (--n21 >= 0) {
                        int n22;
                        n6 = (n22 = byArray[n11++] & 0xFF) == 0 ? 255 : (this.pixels[n12] & 0xFF) / n22;
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 9: {
                    int n23 = rectangle.width;
                    while (--n23 >= 0) {
                        n6 = byArray[n11++] & this.pixels[n12];
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 10: {
                    int n24 = rectangle.width;
                    while (--n24 >= 0) {
                        n6 = byArray[n11++] | this.pixels[n12];
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 11: {
                    int n25 = rectangle.width;
                    while (--n25 >= 0) {
                        n6 = byArray[n11++] ^ this.pixels[n12];
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 12: {
                    int n26 = rectangle.width;
                    while (--n26 >= 0) {
                        int n27;
                        n6 = this.pixels[n12] & 0xFF;
                        if ((n27 = byArray[n11++] & 0xFF) < n6) {
                            n6 = n27;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
                case 13: {
                    int n28 = rectangle.width;
                    while (--n28 >= 0) {
                        int n29;
                        n6 = this.pixels[n12] & 0xFF;
                        if ((n29 = byArray[n11++] & 0xFF) > n6) {
                            n6 = n29;
                        }
                        this.pixels[n12++] = (byte)n6;
                    }
                    break;
                }
            }
            if (n5 % 20 == 0) {
                imageProcessor.showProgress((double)(n5 - rectangle.y) / (double)rectangle.height);
            }
            ++n5;
        }
        imageProcessor.hideProgress();
    }
}

