/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Properties;

public class GelAnalyzer
implements PlugIn {
    static final String GEL = "gel.options";
    static final int OD = 1;
    static final int PERCENT = 2;
    static final int OUTLINE = 4;
    static final int INVERT = 8;
    static int saveID;
    static int nLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] x;
    static PlotsCanvas plotsCanvas;
    static ImageProcessor ipLanes;
    static ImagePlus lanes;
    static ImagePlus gel;
    static int plotHeight;
    static int options;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    static boolean outlineLanes;
    static boolean invertPeaks;
    boolean invertedLut;
    ImagePlus imp;
    Font f;
    FontMetrics fm;
    double odMin = Double.MAX_VALUE;
    double odMax = -1.7976931348623157E308;
    static boolean isVertical;
    static /* synthetic */ Class class$ij$plugin$GelAnalyzer;

    public void run(String string) {
        Roi roi;
        if (string.equals("options")) {
            this.showDialog();
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("reset")) {
            nLanes = 0;
            saveID = 0;
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            ipLanes = null;
            return;
        }
        if (string.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (string.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (this.imp.getID() != saveID) {
            nLanes = 0;
            ipLanes = null;
            saveID = 0;
        }
        if ((roi = this.imp.getRoi()) == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        Rectangle rectangle = roi.getBoundingRect();
        if (nLanes == 0) {
            this.invertedLut = this.imp.isInvertedLut();
            IJ.register(class$ij$plugin$GelAnalyzer == null ? (class$ij$plugin$GelAnalyzer = GelAnalyzer.class$("ij.plugin.GelAnalyzer")) : class$ij$plugin$GelAnalyzer);
        }
        if (string.equals("first")) {
            this.selectFirstLane(rectangle);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (string.equals("next")) {
            this.selectNextLane(rectangle);
            return;
        }
        if (string.equals("plot")) {
            if (isVertical && rectangle.x != x[nLanes] || !isVertical && rectangle.y != x[nLanes]) {
                this.selectNextLane(rectangle);
            }
            if (lanes != null) {
                lanes.killRoi();
            }
            this.plotLanes(gel);
            return;
        }
    }

    void showDialog() {
        GenericDialog genericDialog = new GenericDialog("Gel Analyzer");
        genericDialog.addCheckbox("Uncalibrated OD", uncalibratedOD);
        genericDialog.addCheckbox("Label with Percentages", labelWithPercentages);
        genericDialog.addCheckbox("Outline Lanes", outlineLanes);
        genericDialog.addCheckbox("Invert Peaks", invertPeaks);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        uncalibratedOD = genericDialog.getNextBoolean();
        labelWithPercentages = genericDialog.getNextBoolean();
        outlineLanes = genericDialog.getNextBoolean();
        invertPeaks = genericDialog.getNextBoolean();
        options = 0;
        if (uncalibratedOD) {
            options |= 1;
        }
        if (labelWithPercentages) {
            options |= 2;
        }
        if (outlineLanes) {
            options |= 4;
        }
        if (invertPeaks) {
            options |= 8;
        }
    }

    void selectFirstLane(Rectangle rectangle) {
        isVertical = rectangle.height > rectangle.width;
        if (isVertical && rectangle.height / rectangle.width < 2 || !isVertical && rectangle.width / rectangle.height < 2) {
            GenericDialog genericDialog = new GenericDialog("Lane Orientation");
            String[] stringArray = new String[]{"Vertical", "Horizontal"};
            int n = isVertical ? 0 : 1;
            genericDialog.addChoice("Lane Orientation:", stringArray, stringArray[n]);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            String string = genericDialog.getNextChoice();
            isVertical = string.equals(stringArray[0]);
        }
        IJ.showStatus("Lane 1 selected");
        firstRect = rectangle;
        nLanes = 1;
        GelAnalyzer.x[1] = isVertical ? rectangle.x : rectangle.y;
        if (outlineLanes) {
            this.outlineLane(x[1]);
        } else {
            gel = this.imp;
            saveID = this.imp.getID();
        }
    }

    void selectNextLane(Rectangle rectangle) {
        if (rectangle.width != GelAnalyzer.firstRect.width || rectangle.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.x[GelAnalyzer.nLanes] = isVertical ? rectangle.x : rectangle.y;
        if (outlineLanes) {
            this.outlineLane(x[nLanes]);
        }
    }

    void outlineLane(int n) {
        Object object;
        if (!outlineLanes) {
            return;
        }
        int n2 = (int)(1.0 / this.imp.getWindow().getCanvas().getMagnification());
        if (n2 < 1) {
            n2 = 1;
        }
        if (nLanes == 1) {
            this.f = new Font("Helvetica", 0, 12 * n2);
            object = this.imp.getProcessor();
            gel = this.imp;
            ipLanes = ((ImageProcessor)object).duplicate();
            if (!(ipLanes instanceof ByteProcessor)) {
                ipLanes = ipLanes.convertToByte(true);
            }
            ipLanes.setFont(this.f);
            ipLanes.setLineWidth(n2);
            this.setCustomLut(ipLanes);
            lanes = new ImagePlus("Lanes of " + this.imp.getShortTitle(), ipLanes);
            GelAnalyzer.lanes.changes = true;
            lanes.show();
            lanes.setRoi(this.imp.getRoi());
            this.imp.killRoi();
            saveID = lanes.getID();
        }
        if (ipLanes == null) {
            return;
        }
        if (isVertical) {
            ipLanes.drawRect(n, GelAnalyzer.firstRect.y, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        } else {
            ipLanes.drawRect(GelAnalyzer.firstRect.x, n, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        }
        object = "" + nLanes;
        if (isVertical) {
            int n3 = GelAnalyzer.firstRect.y;
            if (n3 < n2 * 12) {
                n3 += n2 * 14;
            }
            ipLanes.drawString((String)object, n + GelAnalyzer.firstRect.width / 2 - ipLanes.getStringWidth((String)object) / 2, n3);
        } else {
            int n4 = GelAnalyzer.firstRect.x - ipLanes.getStringWidth((String)object) - 2;
            if (n4 < n2 * 10) {
                n4 = GelAnalyzer.firstRect.x + 2;
            }
            ipLanes.drawString((String)object, n4, n + GelAnalyzer.firstRect.height / 2 + 6);
        }
        lanes.updateAndDraw();
    }

    void plotLanes(ImagePlus imagePlus) {
        Object object;
        int n;
        Object object2;
        int n2 = 16;
        int n3 = 2;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[][] dArrayArray = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (isVertical) {
            imageProcessor = imageProcessor.rotateLeft();
        }
        ImagePlus imagePlus2 = new ImagePlus("", imageProcessor);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        if (uncalibratedOD && (imagePlus2.getType() == 1 || imagePlus2.getType() == 2)) {
            new ImageConverter(imagePlus2).convertToGray8();
        }
        if (invertPeaks) {
            ImageProcessor imageProcessor2 = imagePlus2.getProcessor().duplicate();
            imageProcessor2.invert();
            imagePlus2.setProcessor(null, imageProcessor2);
        }
        int n4 = 1;
        while (n4 <= nLanes) {
            if (isVertical) {
                imagePlus2.setRoi(GelAnalyzer.firstRect.y, imageProcessor.getHeight() - x[n4] - GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height, GelAnalyzer.firstRect.width);
            } else {
                imagePlus2.setRoi(GelAnalyzer.firstRect.x, x[n4], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            }
            object2 = new ProfilePlot(imagePlus2);
            dArrayArray[n4] = ((ProfilePlot)object2).getProfile();
            if (((ProfilePlot)object2).getMin() < d) {
                d = ((ProfilePlot)object2).getMin();
            }
            if (((ProfilePlot)object2).getMax() > d2) {
                d2 = ((ProfilePlot)object2).getMax();
            }
            if (uncalibratedOD) {
                dArrayArray[n4] = this.od(dArrayArray[n4]);
            }
            ++n4;
        }
        if (uncalibratedOD) {
            d = this.odMin;
            d2 = this.odMax;
        }
        if ((n = isVertical ? GelAnalyzer.firstRect.height : GelAnalyzer.firstRect.width) < 500) {
            n = 500;
        }
        if (isVertical) {
            if (n > 2 * GelAnalyzer.firstRect.height) {
                n = 2 * GelAnalyzer.firstRect.height;
            }
        } else if (n > 2 * GelAnalyzer.firstRect.width) {
            n = 2 * GelAnalyzer.firstRect.width;
        }
        object2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n > ((Dimension)object2).width - 40) {
            n = ((Dimension)object2).width - 40;
        }
        if ((plotHeight = n / 2) < 200) {
            plotHeight = 200;
        }
        if (plotHeight > 400) {
            plotHeight = 400;
        }
        ByteProcessor byteProcessor = new ByteProcessor(n, n2 + nLanes * plotHeight + n3);
        ((ImageProcessor)byteProcessor).setColor(Color.white);
        byteProcessor.fill();
        ((ImageProcessor)byteProcessor).setColor(Color.black);
        int n5 = byteProcessor.getHeight();
        byteProcessor.moveTo(0, 0);
        byteProcessor.lineTo(n - 1, 0);
        byteProcessor.lineTo(n - 1, n5 - 1);
        byteProcessor.lineTo(0, n5 - 1);
        byteProcessor.lineTo(0, 0);
        byteProcessor.moveTo(0, n5 - 2);
        byteProcessor.lineTo(n - 1, n5 - 2);
        String string = imagePlus.getTitle() + "; ";
        Calibration calibration = imagePlus.getCalibration();
        string = calibration.calibrated() ? string + calibration.getValueUnit() : (uncalibratedOD ? string + "Uncalibrated OD" : string + "Uncalibrated");
        byteProcessor.moveTo(5, n2);
        byteProcessor.drawString(string);
        double d3 = (double)n / (double)dArrayArray[1].length;
        double d4 = d2 - d == 0.0 ? 1.0 : (double)plotHeight / (d2 - d);
        int n6 = 1;
        while (n6 <= nLanes) {
            object = dArrayArray[n6];
            int n7 = (n6 - 1) * plotHeight + n2;
            int n8 = n7 + plotHeight;
            byteProcessor.moveTo(0, n8);
            byteProcessor.lineTo((int)((double)((Object)object).length * d3), n8);
            byteProcessor.moveTo(0, n8 - (int)((object[0] - d) * d4));
            int n9 = 1;
            while (n9 < ((Object)object).length) {
                byteProcessor.lineTo((int)((double)n9 * d3 + 0.5), n8 - (int)((object[n9] - d) * d4 + 0.5));
                ++n9;
            }
            ++n6;
        }
        Line.setWidth(1);
        object = new Plots();
        ((ImagePlus)object).setProcessor("Plots of " + imagePlus.getShortTitle(), byteProcessor);
        ((ImagePlus)object).changes = true;
        byteProcessor.setThreshold(0.0, 0.0, 2);
        ((ImagePlus)object).show();
        nLanes = 0;
        saveID = 0;
        lanes = null;
        gel = null;
        ipLanes = null;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow imageWindow = WindowManager.getCurrentWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        plotsCanvas = imageCanvas instanceof PlotsCanvas ? (PlotsCanvas)imageCanvas : null;
    }

    double[] od(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            double d = 0.434294481 * Math.log(255.0 / (255.0 - dArray[n]));
            if (d < this.odMin) {
                this.odMin = d;
            }
            if (d > this.odMax) {
                this.odMax = d;
            }
            dArray[n] = d;
            ++n;
        }
        return dArray;
    }

    void setCustomLut(ImageProcessor imageProcessor) {
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        byArray[1] = -1;
        byArray2[1] = 0;
        byArray3[1] = 0;
        imageProcessor.setColorModel(new IndexColorModel(8, 256, byArray, byArray2, byArray3));
        byte[] byArray4 = (byte[])imageProcessor.getPixels();
        int n = 0;
        while (n < byArray4.length) {
            if ((byArray4[n] & 0xFF) == 1) {
                byArray4[n] = 0;
            }
            ++n;
        }
        imageProcessor.setColor(1);
    }

    void show(String string) {
        IJ.showMessage("Gel Analyzer", string);
    }

    public static void savePreferences(Properties properties) {
        ((Hashtable)properties).put(GEL, Integer.toString(options));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nLanes = 0;
        x = new int[101];
        options = Prefs.getInt(GEL, 2);
        uncalibratedOD = (options & 1) != 0;
        labelWithPercentages = (options & 2) != 0;
        outlineLanes = (options & 4) != 0;
        invertPeaks = (options & 8) != 0;
    }
}

